/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class OptionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GridBagLayout bl = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private ActionListener tl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Component source = (Component)ae.getSource();
            try {
                Setter s = (Setter)OptionPanel.this.setters.get(source);
                if (null != s) {
                    s.setFrom(source);
                }
            }
            catch (Exception e) {
                Utils.log2("Invalid value!");
            }
        }
    };
    private KeyListener kl = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent ke) {
            Component source = (Component)ke.getSource();
            try {
                Setter s = (Setter)OptionPanel.this.setters.get(source);
                if (null != s) {
                    s.setFrom(source);
                }
            }
            catch (Throwable t) {
                Utils.logAll("Invalid value " + ((JTextField)source).getText());
            }
        }
    };
    private MouseWheelListener mwl = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            Component source = (Component)mwe.getSource();
            try {
                Setter s = (Setter)OptionPanel.this.setters.get(source);
                if (s instanceof NumericalSetter && null != s) {
                    ((JTextField)source).setText(((NumericalSetter)s).setFrom(source, mwe.getWheelRotation()).toString());
                }
            }
            catch (Throwable t) {
                Utils.logAll("Invalid value " + ((JTextField)source).getText());
            }
        }
    };
    private List<JTextField> numeric_fields = new ArrayList<JTextField>();
    private List<JCheckBox> checkboxes = new ArrayList<JCheckBox>();
    private List<JComboBox> choices = new ArrayList<JComboBox>();
    private List<Component> all = new ArrayList<Component>();
    private HashMap<Component, Setter> setters = new HashMap();
    private int rows = 0;

    public OptionPanel() {
        this.setLayout(this.bl);
        this.c.ipady = 10;
    }

    public void addMessage(String text) {
        JLabel label = new JLabel(text);
        this.c.gridy = this.rows++;
        this.c.gridx = 0;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridwidth = 2;
        this.c.fill = 0;
        this.bl.setConstraints(label, this.c);
        this.add(label);
    }

    public void bottomPadding() {
        this.c.gridy = this.rows++;
        this.c.gridx = 0;
        this.c.anchor = 18;
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        JPanel space = new JPanel();
        this.bl.setConstraints(space, this.c);
        this.add(space);
    }

    private void addLabel(String label) {
        this.c.gridy = this.rows++;
        this.c.gridx = 0;
        JLabel l = new JLabel(label);
        this.c.anchor = 12;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.ipadx = 10;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.bl.setConstraints(l, this.c);
        this.add(l);
    }

    private void addField(Component comp, Setter setter) {
        this.c.gridx = 1;
        this.c.weightx = 0.0;
        this.c.anchor = 18;
        this.c.ipadx = 0;
        this.c.gridwidth = 1;
        this.c.fill = 2;
        this.bl.setConstraints(comp, this.c);
        this.add(comp);
        this.setters.put(comp, setter);
    }

    public JTextField addNumericField(String label, double value, int digits) {
        return this.addNumericField(label, value, digits, null);
    }

    public JTextField addNumericField(String label, double value, int digits, Setter setter) {
        return this.addNumericField(label, Utils.cutNumber(value, digits), setter);
    }

    public JTextField addNumericField(String label, int value) {
        return this.addNumericField(label, value, null);
    }

    public JTextField addNumericField(String label, int value, Setter setter) {
        return this.addNumericField(label, Integer.toString(value), setter);
    }

    private JTextField addNumericField(String label, String value, Setter setter) {
        this.addLabel(label);
        JTextField tval = new JTextField(value, 7);
        this.numeric_fields.add(tval);
        this.addField(tval, setter);
        tval.addKeyListener(this.kl);
        tval.addMouseWheelListener(this.mwl);
        return tval;
    }

    public JCheckBox addCheckbox(String label, boolean selected) {
        return this.addCheckbox(label, selected, null);
    }

    public JCheckBox addCheckbox(String label, boolean selected, Setter setter) {
        this.addLabel(label);
        JCheckBox cb = new JCheckBox();
        cb.setSelected(selected);
        this.checkboxes.add(cb);
        this.all.add(cb);
        this.addField(cb, setter);
        cb.addActionListener(this.tl);
        return cb;
    }

    public JComboBox addChoice(String label, String[] items, int selected) {
        return this.addChoice(label, items, selected, null);
    }

    public JComboBox addChoice(String label, String[] items, int selected, Setter setter) {
        this.addLabel(label);
        JComboBox<String> choice = new JComboBox<String>(items);
        choice.setBackground(Color.white);
        choice.setSelectedIndex(selected);
        choice.addActionListener(this.tl);
        this.all.add(choice);
        this.addField(choice, setter);
        return choice;
    }

    public List<JTextField> getNumericFields() {
        return new ArrayList<JTextField>(this.numeric_fields);
    }

    public double getNumber(int index) throws Exception {
        this.check(this.numeric_fields, index);
        return Double.parseDouble(this.numeric_fields.get(index).getText());
    }

    public List<JCheckBox> getCheckBoxes() {
        return new ArrayList<JCheckBox>(this.checkboxes);
    }

    public boolean getCheckbox(int index) throws Exception {
        this.check(this.checkboxes, index);
        return this.checkboxes.get(index).isSelected();
    }

    public List<JComboBox> getChoices() {
        return new ArrayList<JComboBox>(this.choices);
    }

    public int getChoiceIndex(int index) throws Exception {
        this.check(this.choices, index);
        return this.choices.get(index).getSelectedIndex();
    }

    public String getChoiceString(int index) throws Exception {
        return this.getChoiceObject(index).toString();
    }

    public Object getChoiceObject(int index) throws Exception {
        this.check(this.choices, index);
        return this.choices.get(index).getSelectedItem();
    }

    private void check(List<?> list, int index) throws Exception {
        if (index < 0 || index > list.size() - 1) {
            throw new IllegalArgumentException("Index out of bounds: " + index);
        }
    }

    public static class ChoiceObjectSetter
    extends Setter {
        public ChoiceObjectSetter(Object ob, String field) {
            super(ob, field);
        }

        public ChoiceObjectSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        @Override
        public Object getValue(Component source) {
            return ((JComboBox)source).getSelectedItem();
        }
    }

    public static class ChoiceStringSetter
    extends Setter {
        public ChoiceStringSetter(Object ob, String field) {
            super(ob, field);
        }

        public ChoiceStringSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        @Override
        public Object getValue(Component source) {
            return ((JComboBox)source).getSelectedItem().toString();
        }
    }

    public static class ChoiceIntSetter
    extends Setter {
        public ChoiceIntSetter(Object ob, String field) {
            super(ob, field);
        }

        public ChoiceIntSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        @Override
        public Object getValue(Component source) {
            return ((JComboBox)source).getSelectedIndex();
        }
    }

    public static class StringSetter
    extends Setter {
        public StringSetter(Object ob, String field) {
            super(ob, field);
        }

        public StringSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        @Override
        public Object getValue(Component source) {
            return ((JTextComponent)source).getText();
        }
    }

    public static class BooleanSetter
    extends Setter {
        public BooleanSetter(Object ob, String field) {
            super(ob, field);
        }

        public BooleanSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        @Override
        public Object getValue(Component source) {
            return ((JCheckBox)source).isSelected();
        }
    }

    public static class FloatSetter
    extends NumericalSetter {
        public FloatSetter(Object ob, String field) {
            super(ob, field);
        }

        public FloatSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        public FloatSetter(Object ob, String field, Runnable reaction, int min, int max) {
            super(ob, field, reaction, min, max);
        }

        @Override
        public Object getValue(Component source) {
            return Float.valueOf(Float.parseFloat(((JTextField)source).getText()));
        }

        @Override
        public Object getValue(Component source, int inc) {
            float val = Float.parseFloat(((JTextField)source).getText()) + (float)inc;
            if (val < (float)this.min) {
                return Float.valueOf(this.min);
            }
            if (val > (float)this.max) {
                return Float.valueOf(this.max);
            }
            return Float.valueOf(val);
        }
    }

    public static class DoubleSetter
    extends NumericalSetter {
        public DoubleSetter(Object ob, String field) {
            super(ob, field);
        }

        public DoubleSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        public DoubleSetter(Object ob, String field, Runnable reaction, int min, int max) {
            super(ob, field, reaction, min, max);
        }

        @Override
        public Object getValue(Component source) {
            return Double.parseDouble(((JTextField)source).getText());
        }

        @Override
        protected Object getValue(Component source, int inc) {
            double val = Double.parseDouble(((JTextField)source).getText()) + (double)inc;
            if (val < (double)this.min) {
                return (double)this.min;
            }
            if (val > (double)this.max) {
                return (double)this.max;
            }
            return val;
        }
    }

    public static class IntSetter
    extends NumericalSetter {
        public IntSetter(Object ob, String field) {
            super(ob, field);
        }

        public IntSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        public IntSetter(Object ob, String field, Runnable reaction, int min, int max) {
            super(ob, field, reaction, min, max);
        }

        @Override
        public Object getValue(Component source) {
            return (int)Double.parseDouble(((JTextField)source).getText());
        }

        @Override
        protected Object getValue(Component source, int inc) {
            int val = (int)Double.parseDouble(((JTextField)source).getText()) + inc;
            if (val < this.min) {
                return this.min;
            }
            if (val > this.max) {
                return this.max;
            }
            return val;
        }
    }

    public static abstract class NumericalSetter
    extends Setter {
        protected int min = Integer.MIN_VALUE;
        protected int max = Integer.MAX_VALUE;

        public NumericalSetter(Object ob, String field) {
            super(ob, field);
        }

        public NumericalSetter(Object ob, String field, Runnable reaction) {
            super(ob, field, reaction);
        }

        public NumericalSetter(Object ob, String field, Runnable reaction, int min, int max) {
            super(ob, field, reaction);
            this.min = min;
            this.max = max;
        }

        public Object setFrom(Component source, int inc) throws Exception {
            Field f = this.ob.getClass().getDeclaredField(this.field);
            f.setAccessible(true);
            Object val = this.getValue(source, inc);
            f.set(this.ob, val);
            Utils.log2("set value of " + this.field + " to " + f.get(this.ob));
            if (null != this.reaction) {
                this.reaction.run();
            }
            return val;
        }

        protected abstract Object getValue(Component var1, int var2);
    }

    public static abstract class Setter {
        protected final Object ob;
        protected final String field;
        protected Runnable reaction;

        public Setter(Object ob, String field) {
            this.ob = ob;
            this.field = field;
        }

        public Setter(Object ob, String field, Runnable reaction) {
            this(ob, field);
            this.reaction = reaction;
        }

        public void setFrom(Component source) throws Exception {
            Field f = this.ob.getClass().getDeclaredField(this.field);
            f.setAccessible(true);
            f.set(this.ob, this.getValue(source));
            if (null != this.reaction) {
                this.reaction.run();
            }
        }

        public abstract Object getValue(Component var1);
    }
}

