/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display.imagej;

import ij.ImagePlus;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.image.display.imagej.InverseTransformDescription;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.multithreading.Stopable;
import mpicbg.imglib.type.Type;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.RigidModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.TranslationModel3D;

public abstract class SliceTransformableExtraction<T extends Type<T>>
extends Thread
implements Stopable {
    final InverseTransformDescription<T> desc;
    final InvertibleCoordinateTransform transform;
    final Interpolator<T> it;
    final float[] offset;
    final ImagePlus parent;
    final Display<T> display;
    final T type;
    final int[] dimensionPositions;
    final int dimX;
    final int dimY;
    final int dimZ;
    final int slice;
    final int sizeX;
    final int sizeY;
    final int numDimensions;
    final float numImages;
    final boolean isAffine;
    protected boolean stopThread = false;

    public SliceTransformableExtraction(int numImages, InverseTransformDescription<T> desc, ImagePlus parent, int[] dimensionPositions, int dimX, int dimY, int dimZ, int sizeX, int sizeY, int slice) {
        this.desc = desc;
        this.transform = desc.getTransform();
        this.it = desc.getImage().createInterpolator(desc.getInterpolatorFactory());
        this.offset = desc.getOffset();
        this.numDimensions = desc.getImage().getNumDimensions();
        this.isAffine = AffineModel2D.class.isInstance(desc.getTransform()) || AffineModel3D.class.isInstance(desc.getTransform()) || RigidModel2D.class.isInstance(desc.getTransform()) || TranslationModel2D.class.isInstance(desc.getTransform()) || TranslationModel3D.class.isInstance(desc.getTransform());
        this.parent = parent;
        this.display = this.it.getImage().getDisplay();
        this.type = this.it.getType();
        this.dimX = dimX;
        this.dimY = dimY;
        this.dimZ = dimZ;
        this.slice = slice;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.numImages = numImages;
        this.dimensionPositions = (int[])dimensionPositions.clone();
        if (dimensionPositions.length != this.numDimensions) {
            throw new RuntimeException("SliceTransformableExtraction.constructor(): dimensions of image and dimensionPositions not equal.");
        }
    }

    protected abstract void setIntensity(int var1);

    @Override
    public void run() {
        double[] initialPosition = new double[this.numDimensions];
        if (this.dimX >= initialPosition.length) {
            throw new RuntimeException("SliceTransformableExtraction.run(): x-Dimension for display higher than available dimensions: " + this.dimX + " >= " + initialPosition.length);
        }
        if (this.dimY >= initialPosition.length) {
            throw new RuntimeException("SliceTransformableExtraction.run(): y-Dimension for display higher than available dimensions: " + this.dimY + " >= " + initialPosition.length);
        }
        if (this.dimZ >= initialPosition.length) {
            throw new RuntimeException("SliceTransformableExtraction.run(): z-Dimension for display higher than available dimensions: " + this.dimZ + " >= " + initialPosition.length);
        }
        for (int d = 0; d < initialPosition.length; ++d) {
            initialPosition[d] = this.dimensionPositions[d];
        }
        initialPosition[this.dimZ] = this.slice;
        double[] position1 = (double[])initialPosition.clone();
        double[] position2 = (double[])initialPosition.clone();
        try {
            int i = 0;
            if (this.isAffine) {
                int d;
                double[] vectorX = new double[initialPosition.length];
                double[] vectorY = new double[initialPosition.length];
                if (this.sizeX > 1) {
                    position1[this.dimY] = 0.0;
                    position1[this.dimX] = 0.0;
                    position2[this.dimX] = this.sizeX - 1;
                    position2[this.dimY] = 0.0;
                    for (d = 0; d < this.numDimensions; ++d) {
                        int n = d;
                        position1[n] = position1[n] + (double)this.offset[d];
                        int n2 = d;
                        position2[n2] = position2[n2] + (double)this.offset[d];
                    }
                    this.transform.applyInverseInPlace(position1);
                    this.transform.applyInverseInPlace(position2);
                    this.it.moveTo(position1);
                    this.it.moveTo(position2);
                    for (d = 0; d < initialPosition.length; ++d) {
                        vectorX[d] = (position2[d] - position1[d]) / (double)this.sizeX;
                        position1[d] = initialPosition[d];
                        position2[d] = initialPosition[d];
                    }
                }
                if (this.sizeY > 1) {
                    position1[this.dimY] = 0.0;
                    position1[this.dimX] = 0.0;
                    position2[this.dimX] = 0.0;
                    position2[this.dimY] = this.sizeY - 1;
                    for (d = 0; d < this.numDimensions; ++d) {
                        int n = d;
                        position1[n] = position1[n] + (double)this.offset[d];
                        int n3 = d;
                        position2[n3] = position2[n3] + (double)this.offset[d];
                    }
                    this.transform.applyInverseInPlace(position1);
                    this.transform.applyInverseInPlace(position2);
                    this.it.moveTo(position1);
                    this.it.moveTo(position2);
                    for (d = 0; d < initialPosition.length; ++d) {
                        vectorY[d] = (position2[d] - position1[d]) / (double)this.sizeY;
                        position1[d] = initialPosition[d];
                        position2[d] = initialPosition[d];
                    }
                }
                position2[this.dimX] = 0.0;
                position1[this.dimX] = 0.0;
                position2[this.dimY] = 0.0;
                position1[this.dimY] = 0.0;
                for (d = 0; d < this.numDimensions; ++d) {
                    int n = d;
                    position1[n] = position1[n] + (double)this.offset[d];
                }
                this.transform.applyInverseInPlace(position1);
                this.it.moveTo(position1);
                for (int y = 0; y < this.sizeY; ++y) {
                    for (int x = 0; x < this.sizeX; ++x) {
                        if (this.stopThread) {
                            this.it.close();
                            return;
                        }
                        this.setIntensity(i);
                        ++i;
                        this.it.moveRel(vectorX);
                    }
                    for (int d2 = 0; d2 < initialPosition.length; ++d2) {
                        int n = d2;
                        position1[n] = position1[n] + vectorY[d2];
                    }
                    this.it.setPosition(position1);
                    if (this.parent == null || y % 10 != 0) continue;
                    this.parent.updateAndDraw();
                }
            } else {
                for (int y = 0; y < this.sizeY; ++y) {
                    initialPosition[this.dimY] = y;
                    for (int x = 0; x < this.sizeX; ++x) {
                        if (this.stopThread) {
                            this.it.close();
                            return;
                        }
                        for (int d = 0; d < initialPosition.length; ++d) {
                            position1[d] = initialPosition[d] + (double)this.offset[d];
                        }
                        position1[this.dimX] = (float)x + this.offset[this.dimX];
                        this.transform.applyInPlace(position1);
                        this.it.moveTo(position1);
                        this.setIntensity(i);
                        ++i;
                    }
                    if (this.parent == null || y % 50 != 0) continue;
                    this.parent.updateAndDraw();
                }
            }
        }
        catch (NoninvertibleModelException e) {
            System.out.println(this.it + " has a not invertible model: " + (Object)((Object)e));
        }
        this.it.close();
        if (this.parent != null) {
            this.parent.updateAndDraw();
        }
    }

    @Override
    public void stopThread() {
        this.stopThread = true;
    }
}

