/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.analysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Collection;
import java.util.Map;
import javax.swing.JFrame;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import script.imglib.analysis.ChartUtils;

public class BarChart
extends JFrame {
    private static final long serialVersionUID = 7347559630675867104L;
    private final JFreeChart chart;

    public BarChart(Collection<? extends Number> data) {
        this(data, "Bar chart", "", "");
    }

    public BarChart(Collection<? extends Number> data, String title, String xLabel, String yLabel) {
        super(title);
        this.chart = BarChart.createChart(data, title, xLabel, yLabel);
        this.getContentPane().add((Component)new ChartPanel(this.chart));
        this.pack();
        this.setVisible(true);
    }

    public BarChart(Map<? extends Number, ? extends Number> data) {
        this(data, "Bar chart", "", "");
    }

    public BarChart(Map<? extends Number, ? extends Number> data, String title, String xLabel, String yLabel) {
        super(title);
        this.chart = BarChart.createChart(data, title, xLabel, yLabel);
        this.getContentPane().add((Component)new ChartPanel(this.chart));
        this.pack();
        this.setVisible(true);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private static final JFreeChart createChart(Collection<? extends Number> data, String title, String xLabel, String yLabel) {
        DefaultCategoryDataset dcd = new DefaultCategoryDataset();
        int k = 1;
        for (Number number : data) {
            dcd.addValue(number, (Comparable)((Object)""), (Comparable)Integer.valueOf(k++));
        }
        boolean legend = false;
        boolean bl = true;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createBarChart((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dcd, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)bl, (boolean)urls);
        BarChart.setBarTheme(chart);
        return chart;
    }

    private static final JFreeChart createChart(Map<? extends Number, ? extends Number> data, String title, String xLabel, String yLabel) {
        DefaultCategoryDataset dcd = new DefaultCategoryDataset();
        for (Map.Entry<? extends Number, ? extends Number> e : data.entrySet()) {
            dcd.addValue(e.getValue(), (Comparable)((Object)""), (Comparable)((Object)e.getKey()));
        }
        boolean legend = false;
        boolean tooltips = true;
        boolean urls = false;
        JFreeChart chart = ChartFactory.createBarChart((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dcd, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)tooltips, (boolean)urls);
        BarChart.setBarTheme(chart);
        return chart;
    }

    private static final void setBarTheme(JFreeChart chart) {
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setSeriesOutlinePaint(0, (Paint)Color.lightGray);
        renderer.setShadowVisible(false);
        renderer.setDrawBarOutline(true);
        BarChart.setBackgroundDefault(chart);
    }

    private static void setBackgroundDefault(JFreeChart chart) {
        BasicStroke gridStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 1.0f}, 0.0f);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setRangeGridlineStroke((Stroke)gridStroke);
        plot.setDomainGridlineStroke((Stroke)gridStroke);
        plot.setBackgroundPaint((Paint)new Color(235, 235, 235));
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setOutlineVisible(false);
        plot.getDomainAxis().setAxisLineVisible(false);
        plot.getRangeAxis().setAxisLineVisible(false);
        plot.getDomainAxis().setLabelPaint((Paint)Color.gray);
        plot.getRangeAxis().setLabelPaint((Paint)Color.gray);
        plot.getDomainAxis().setTickLabelPaint((Paint)Color.gray);
        plot.getRangeAxis().setTickLabelPaint((Paint)Color.gray);
        chart.getTitle().setPaint((Paint)Color.gray);
    }

    public Image<RGBALegacyType> asImage() {
        return ChartUtils.asImage(this.chart);
    }
}

