/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.math;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.FloatType;
import script.imglib.math.fn.IFunction;
import script.imglib.math.fn.ImageFunction;

public class Compute {
    public static final void checkContainers(Collection<Image<?>> images) throws Exception {
        if (images.isEmpty()) {
            throw new Exception("There aren't any images!");
        }
        Image<?> first = images.iterator().next();
        for (Image<?> img : images) {
            if (!img.getContainer().compareStorageContainerDimensions(first.getContainer())) {
                throw new Exception("Images have different dimensions!");
            }
            if (img.getContainer().compareStorageContainerCompatibility(first.getContainer())) continue;
            throw new Exception("Images are of incompatible container types!");
        }
    }

    public static final Set<Image<?>> findImages(IFunction op) throws Exception {
        HashSet cs = new HashSet();
        op.findCursors(cs);
        HashSet images = new HashSet();
        for (Cursor<?> c : cs) {
            images.add(c.getImage());
        }
        return images;
    }

    public static final <R extends RealType<R>> Image<R> apply(IFunction op, R output, int numThreads) throws Exception {
        Loop loop = new Loop<R>(op, output, numThreads){

            @Override
            public final void loop(Cursor<R> resultCursor, long loopSize, IFunction fn) {
                for (long j = loopSize; j > 0L; --j) {
                    resultCursor.fwd();
                    ((RealType)resultCursor.getType()).setReal(fn.eval());
                }
            }
        };
        return loop.run();
    }

    public static final Image<RGBALegacyType> apply(IFunction op, RGBALegacyType output, int numThreads) throws Exception {
        Loop<RGBALegacyType> loop = new Loop<RGBALegacyType>(op, output, numThreads){

            @Override
            public final void loop(Cursor<RGBALegacyType> resultCursor, long loopSize, IFunction fn) {
                for (long j = loopSize; j > 0L; --j) {
                    resultCursor.fwd();
                    resultCursor.getType().set((int)fn.eval());
                }
            }
        };
        return loop.run();
    }

    public static final Image<FloatType> inFloats(IFunction op) throws Exception {
        return Compute.inFloats(Runtime.getRuntime().availableProcessors(), op);
    }

    public static final Image<FloatType> inFloats(int numThreads, IFunction op) throws Exception {
        return Compute.apply(op, new FloatType(), numThreads);
    }

    public static final Image<DoubleType> inDoubles(int numThreads, IFunction op) throws Exception {
        return Compute.apply(op, new DoubleType(), numThreads);
    }

    public static final Image<DoubleType> inDoubles(IFunction op) throws Exception {
        return Compute.inDoubles(Runtime.getRuntime().availableProcessors(), op);
    }

    public static final Image<RGBALegacyType> inRGBA(int numThreads, IFunction op) throws Exception {
        return Compute.apply(op, new RGBALegacyType(), numThreads);
    }

    public static final Image<RGBALegacyType> inRGBA(IFunction op) throws Exception {
        return Compute.apply(op, new RGBALegacyType(), Runtime.getRuntime().availableProcessors());
    }

    public static final Image<FloatType> inFloats(Image<? extends RealType<?>> img) throws Exception {
        return Compute.inFloats(new ImageFunction(img));
    }

    public static final Image<DoubleType> inDoubles(Image<? extends RealType<?>> img) throws Exception {
        return Compute.inDoubles(new ImageFunction(img));
    }

    public static final Image<RGBALegacyType> inRGBA(Image<? extends RealType<?>> img) throws Exception {
        return Compute.inRGBA(new ImageFunction(img));
    }

    private static abstract class Loop<R extends NumericType<R>> {
        private final IFunction op;
        private final Collection<Image<?>> images;
        private final Collection<Cursor<?>> cursors;
        private final R output;
        private int numThreads;

        public Loop(IFunction op, R output, int numThreads) throws Exception {
            this.op = op;
            this.output = output;
            this.numThreads = Math.max(1, numThreads);
            this.cursors = new HashSet();
            op.findCursors(this.cursors);
            this.images = new HashSet();
            for (Cursor<?> c : this.cursors) {
                this.images.add(c.getImage());
            }
        }

        public abstract void loop(Cursor<R> var1, long var2, IFunction var4);

        protected void cleanupCursors() {
            for (Cursor<?> c : this.cursors) {
                c.close();
            }
        }

        public Image<R> run() throws Exception {
            try {
                Image<R> image = this.innerRun();
                return image;
            }
            finally {
                this.cleanupCursors();
            }
        }

        private final Image<R> innerRun() throws Exception {
            if (this.images.size() > 0) {
                Compute.checkContainers(this.images);
                Image<?> first = this.images.iterator().next();
                ImageFactory<R> factory = new ImageFactory<R>(this.output, first.getContainerFactory());
                final Image<R> result = factory.createImage(first.getDimensions(), "result");
                final AtomicInteger ai = new AtomicInteger(0);
                final IFunction[] functions = new IFunction[this.numThreads];
                try {
                    for (int i = 0; i < this.numThreads; ++i) {
                        functions[i] = this.op.duplicate();
                    }
                }
                catch (Exception e) {
                    System.out.println("Running single threaded, operations cannot be duplicated:\n" + e);
                    this.numThreads = 1;
                }
                Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
                final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(first.getNumPixels(), this.numThreads);
                for (int ithread = 0; ithread < threads.length; ++ithread) {
                    threads[ithread] = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            int myNumber = ai.getAndIncrement();
                            Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                            Cursor resultCursor = result.createCursor();
                            resultCursor.fwd(myChunk.getStartPosition());
                            IFunction fn = functions[myNumber];
                            HashSet cs = new HashSet();
                            fn.findCursors(cs);
                            for (Cursor cursor : cs) {
                                cursor.fwd(myChunk.getStartPosition());
                            }
                            cursors.addAll(cs);
                            cursors.add(resultCursor);
                            this.loop(resultCursor, myChunk.getLoopSize(), fn);
                        }
                    });
                }
                SimpleMultiThreading.startAndJoin(threads);
                return result;
            }
            ImageFactory<R> factory = new ImageFactory<R>(this.output, new ArrayContainerFactory());
            Image<R> result = factory.createImage(new int[]{1}, "result");
            Cursor<R> c = result.createCursor();
            this.cursors.add(c);
            this.loop(c, result.size(), this.op);
            return result;
        }
    }
}

