/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import java.util.ArrayList;
import net.imglib2.realtransform.RealTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.CoordinateSystem;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.graph.CoordinateSystems;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;

public abstract class AbstractCoordinateTransform<T extends RealTransform>
implements CoordinateTransform<T> {
    protected String type;
    protected String name;
    protected String input;
    protected String output;
    protected transient String[] inputAxes;
    protected transient String[] outputAxes;
    protected transient CoordinateSystem inputSpaceObj;
    protected transient CoordinateSystem outputSpaceObj;

    @Override
    public abstract T getTransform();

    public AbstractCoordinateTransform(String type, String name, String inputSpace, String outputSpace) {
        this.type = type;
        this.name = name;
        this.input = inputSpace;
        this.output = outputSpace;
    }

    public AbstractCoordinateTransform(String type, String name, String[] inputAxes, String[] outputAxes) {
        this.type = type;
        this.name = name;
        this.inputAxes = inputAxes;
        this.outputAxes = outputAxes;
    }

    public AbstractCoordinateTransform(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public AbstractCoordinateTransform(String type) {
        this.type = type;
    }

    public AbstractCoordinateTransform(CoordinateTransform<T> other) {
        this.name = other.getName();
        this.type = other.getType();
        this.input = other.getInput();
        this.output = other.getOutput();
        this.inputAxes = other.getInputAxes();
        this.outputAxes = other.getOutputAxes();
    }

    public AbstractCoordinateTransform(CoordinateTransform<T> other, String[] inputAxes, String[] outputAxes) {
        this.name = other.getName();
        this.type = other.getType();
        this.input = other.getInput();
        this.output = other.getOutput();
        this.inputAxes = inputAxes;
        this.outputAxes = outputAxes;
    }

    public boolean inferSpacesFromAxes(CoordinateSystems spaces) {
        if (this.input == null && this.outputAxes != null) {
            this.input = AbstractCoordinateTransform.spaceNameFromAxesLabels(spaces, this.inputAxes);
        }
        if (this.output == null && this.outputAxes != null) {
            this.output = AbstractCoordinateTransform.spaceNameFromAxesLabels(spaces, this.outputAxes);
        }
        return this.input != null && this.output != null;
    }

    @Override
    public String[] getInputAxes() {
        if (this.inputAxes != null) {
            return this.inputAxes;
        }
        return this.inputSpaceObj.getAxisNames();
    }

    @Override
    public String[] getOutputAxes() {
        if (this.outputAxes != null) {
            return this.outputAxes;
        }
        return this.outputSpaceObj.getAxisNames();
    }

    private static String spaceNameFromAxesLabels(CoordinateSystems spaces, String[] axes) {
        ArrayList<CoordinateSystem> candidateSpaces = spaces.getSpacesFromAxes(axes);
        if (candidateSpaces.size() == 1) {
            return candidateSpaces.get(0).getName();
        }
        return null;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    public void setInput(CoordinateSystem inputSpace) {
        this.inputSpaceObj = inputSpace;
    }

    public void setOutput(CoordinateSystem outputSpace) {
        this.outputSpaceObj = outputSpace;
    }

    public CoordinateSystem getInputSpaceObj() {
        return this.inputSpaceObj;
    }

    public CoordinateSystem getOutputSpaceObj() {
        return this.outputSpaceObj;
    }

    public AbstractCoordinateTransform<T> setNameSpaces(String name, String in, String out) {
        this.name = name;
        this.input = in;
        this.output = out;
        return this;
    }

    public String toString() {
        return String.format("%s:(%s > %s)", this.name, this.input, this.output);
    }
}

