/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import ij.IJ;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import nrrd.NrrdHeader;

public class TransformIO {
    public boolean normaliseScaleFactors = false;
    public static final int matRows = 4;
    public static final int matCols = 4;
    public static final int matSize = 16;
    NrrdHeader nh;

    String getTags() {
        return this.nh == null ? null : this.nh.getTagStrings();
    }

    String getFields() {
        return this.nh == null ? null : this.nh.getFieldStrings();
    }

    String getHeader() {
        return this.nh == null ? null : this.nh.toString();
    }

    public float[] openAffineTransform(String path) {
        this.nh = new NrrdHeader();
        float[] mat = new float[16];
        try {
            String s;
            this.nh.readHeader(path);
            LineNumberReader in = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            int nLines = 0;
            while ((s = in.readLine()) != null) {
                if (s.startsWith("#")) continue;
                String[] floatStrings = s.split("\\s+");
                if (floatStrings.length != 4) {
                    in.close();
                    throw new Exception("Could not read 4 floats from line " + in.getLineNumber() + " (" + s + ") of file " + path);
                }
                for (int i = 0; i < floatStrings.length; ++i) {
                    mat[nLines * 4 + i] = this.s2f(floatStrings[i]);
                }
                ++nLines;
            }
            in.close();
        }
        catch (Exception e) {
            IJ.error((String)("Unable to read affine transfomation from file: " + path + "\n" + e));
        }
        return mat;
    }

    public float[] openAffineTransform() {
        OpenDialog od = new OpenDialog("Open Affine Transformation...", "");
        String directory = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return null;
        }
        return this.openAffineTransform(new File(directory, fileName).getPath());
    }

    public boolean saveAffineTransform(String path, float[] mat) {
        File f = new File(path);
        if (mat.length != 16) {
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
            out.write("# Simple Affine Transformation written by Transform_IO\n");
            out.write("# at " + new Date() + "\n");
            out.write(this.toString(mat));
            ((Writer)out).close();
        }
        catch (Exception e) {
            IJ.error((String)("Unable to write transformation to file: " + f.getAbsolutePath() + "error: " + e));
            return false;
        }
        return true;
    }

    public String toString(float[] mat) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            sb.append(mat[i * 4] + " " + mat[i * 4 + 1] + " " + mat[i * 4 + 2] + " " + mat[i * 4 + 3] + "\n");
        }
        return sb.toString();
    }

    public boolean saveAffineTransform(float[] mat) {
        SaveDialog sd = new SaveDialog("Save Affine Transformation ...", "", ".mat");
        String file = sd.getFileName();
        if (file == null) {
            return false;
        }
        String directory = sd.getDirectory();
        return this.saveAffineTransform(new File(directory, file).getPath(), mat);
    }

    float s2f(String s) {
        Float f = null;
        try {
            f = new Float(s);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f != null ? f.floatValue() : Float.NaN;
    }
}

