/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.ImagePlus;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import stacks.CropHandleRectangle;
import stacks.ThreePaneCrop;
import stacks.ThreePanes;
import stacks.ThreePanesCanvas;

public class ThreePaneCropCanvas
extends ThreePanesCanvas {
    int crop_min_offscreen_x;
    int crop_max_offscreen_x;
    int crop_min_offscreen_y;
    int crop_max_offscreen_y;
    int offscreen_width;
    int offscreen_height;
    static final int HANDLE_NW = 1;
    static final int HANDLE_NE = 2;
    static final int HANDLE_SW = 3;
    static final int HANDLE_SE = 4;
    int dragging;
    int x_pressed_at;
    int y_pressed_at;
    int offset_x_in_handle;
    int offset_y_in_handle;
    CropHandleRectangle nw;
    CropHandleRectangle ne;
    CropHandleRectangle sw;
    CropHandleRectangle se;
    private int backBufferWidth;
    private int backBufferHeight;
    private Graphics backBufferGraphics;
    private Image backBufferImage;

    public ThreePaneCropCanvas(ImagePlus imagePlus, ThreePanes owner, int plane) {
        super(imagePlus, owner, plane);
        this.offscreen_width = imagePlus.getWidth();
        this.offscreen_height = imagePlus.getHeight();
        this.crop_min_offscreen_x = 0;
        this.crop_max_offscreen_x = this.offscreen_width - 1;
        this.crop_min_offscreen_y = 0;
        this.crop_max_offscreen_y = this.offscreen_height - 1;
        this.nw = new CropHandleRectangle(plane, 12, this);
        this.ne = new CropHandleRectangle(plane, 12, this);
        this.sw = new CropHandleRectangle(plane, 12, this);
        this.se = new CropHandleRectangle(plane, 12, this);
        this.setHandlesFromBounds();
    }

    private void setHandlesFromBounds() {
        this.nw.top_left_x = this.crop_min_offscreen_x;
        this.nw.top_left_y = this.crop_min_offscreen_y;
        this.ne.top_left_x = this.crop_max_offscreen_x - this.ne.side + 1;
        this.ne.top_left_y = this.crop_min_offscreen_y;
        this.sw.top_left_x = this.crop_min_offscreen_x;
        this.sw.top_left_y = this.crop_max_offscreen_y - this.sw.side + 1;
        this.se.top_left_x = this.crop_max_offscreen_x - this.se.side + 1;
        this.se.top_left_y = this.crop_max_offscreen_y - this.se.side + 1;
    }

    public static Object newThreePanesCanvas(ImagePlus imagePlus, ThreePaneCrop owner, int plane) {
        return new ThreePaneCropCanvas(imagePlus, owner, plane);
    }

    public void setCropBounds(int offscreen_min_x, int offscreen_max_x, int offscreen_min_y, int offscreen_max_y) {
        this.crop_min_offscreen_x = offscreen_min_x;
        this.crop_max_offscreen_x = offscreen_max_x;
        this.crop_min_offscreen_y = offscreen_min_y;
        this.crop_max_offscreen_y = offscreen_max_y;
        this.setHandlesFromBounds();
    }

    private void resetBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
            this.backBufferGraphics = null;
        }
        if (this.backBufferImage != null) {
            this.backBufferImage.flush();
            this.backBufferImage = null;
        }
        this.backBufferWidth = this.getSize().width;
        this.backBufferHeight = this.getSize().height;
        this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
        this.backBufferGraphics = this.backBufferImage.getGraphics();
    }

    @Override
    public void paint(Graphics g) {
        if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
            this.resetBackBuffer();
        }
        super.paint(this.backBufferGraphics);
        this.drawOverlay(this.backBufferGraphics);
        this.nw.draw(this.backBufferGraphics);
        this.ne.draw(this.backBufferGraphics);
        this.sw.draw(this.backBufferGraphics);
        this.se.draw(this.backBufferGraphics);
        g.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
    }

    @Override
    protected void drawOverlay(Graphics g) {
        super.drawOverlay(g);
        g.setColor(Color.MAGENTA);
        g.drawLine(this.screenX(this.crop_min_offscreen_x), this.screenY(0), this.screenX(this.crop_min_offscreen_x), this.screenY(this.offscreen_height) - 1);
        g.drawLine(this.screenX(this.crop_max_offscreen_x + 1) - 1, this.screenY(0), this.screenX(this.crop_max_offscreen_x + 1) - 1, this.screenY(this.offscreen_height) - 1);
        g.drawLine(this.screenX(0), this.screenY(this.crop_min_offscreen_y), this.screenX(this.offscreen_width) - 1, this.screenY(this.crop_min_offscreen_y));
        g.drawLine(this.screenX(0), this.screenY(this.crop_max_offscreen_y + 1) - 1, this.screenX(this.offscreen_width) - 1, this.screenY(this.crop_max_offscreen_y + 1) - 1);
    }

    public void mousePressed(MouseEvent e) {
        int x_pressed_at = this.offScreenX(e.getX());
        int y_pressed_at = this.offScreenY(e.getY());
        if (this.nw.pointInside(this.offScreenX(e.getX()), this.offScreenY(e.getY()))) {
            this.dragging = 1;
            this.offset_x_in_handle = x_pressed_at - this.nw.top_left_x;
            this.offset_y_in_handle = y_pressed_at - this.nw.top_left_y;
        } else if (this.ne.pointInside(this.offScreenX(e.getX()), this.offScreenY(e.getY()))) {
            this.dragging = 2;
            this.offset_x_in_handle = x_pressed_at - this.ne.top_left_x - this.ne.side;
            this.offset_y_in_handle = y_pressed_at - this.ne.top_left_y;
        } else if (this.sw.pointInside(this.offScreenX(e.getX()), this.offScreenY(e.getY()))) {
            this.dragging = 3;
            this.offset_x_in_handle = x_pressed_at - this.sw.top_left_x;
            this.offset_y_in_handle = y_pressed_at - this.sw.top_left_y - this.sw.side;
        } else if (this.se.pointInside(this.offScreenX(e.getX()), this.offScreenY(e.getY()))) {
            this.dragging = 4;
            this.offset_x_in_handle = x_pressed_at - this.se.top_left_x - this.se.side;
            this.offset_y_in_handle = y_pressed_at - this.se.top_left_y - this.se.side;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragging = 0;
    }

    public void mouseDragged(MouseEvent e) {
        ((ThreePaneCrop)this.owner).handleDraggedTo(this.offScreenX(e.getX()) - this.offset_x_in_handle, this.offScreenY(e.getY()) - this.offset_y_in_handle, this.dragging, this.plane);
    }
}

