/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;

public class Bresenham3D {
    public static int sign(int a) {
        return a < 0 ? -1 : (a > 0 ? 1 : 0);
    }

    public static ArrayList<IntegerPoint> bresenham3D(IntegerPoint p1, IntegerPoint p2) {
        return Bresenham3D.bresenham3D(p1.x, p1.y, p1.z, p2.x, p2.y, p2.z);
    }

    public static ArrayList<IntegerPoint> bresenham3D(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<IntegerPoint> result = new ArrayList<IntegerPoint>();
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int ax = Math.abs(dx) << 1;
        int ay = Math.abs(dy) << 1;
        int az = Math.abs(dz) << 1;
        int sx = Bresenham3D.sign(dx);
        int sy = Bresenham3D.sign(dy);
        int sz = Bresenham3D.sign(dz);
        int x = x1;
        int y = y1;
        int z = z1;
        if (ax >= Math.max(ay, az)) {
            int yd = ay - (ax >> 1);
            int zd = az - (ax >> 1);
            while (true) {
                result.add(new IntegerPoint(x, y, z));
                if (x == x2) {
                    return result;
                }
                if (yd >= 0) {
                    y += sy;
                    yd -= ax;
                }
                if (zd >= 0) {
                    z += sz;
                    zd -= ax;
                }
                x += sx;
                yd += ay;
                zd += az;
            }
        }
        if (ay >= Math.max(ax, az)) {
            int xd = ax - (ay >> 1);
            int zd = az - (ay >> 1);
            while (true) {
                result.add(new IntegerPoint(x, y, z));
                if (y == y2) {
                    return result;
                }
                if (xd >= 0) {
                    x += sx;
                    xd -= ay;
                }
                if (zd >= 0) {
                    z += sz;
                    zd -= ay;
                }
                y += sy;
                xd += ax;
                zd += az;
            }
        }
        if (az >= Math.max(ax, ay)) {
            int xd = ax - (az >> 1);
            int yd = ay - (az >> 1);
            while (true) {
                result.add(new IntegerPoint(x, y, z));
                if (z == z2) {
                    return result;
                }
                if (xd >= 0) {
                    x += sx;
                    xd -= az;
                }
                if (yd >= 0) {
                    y += sy;
                    yd -= az;
                }
                z += sz;
                xd += ax;
                yd += ay;
            }
        }
        return null;
    }

    public static class IntegerPoint {
        public int x;
        public int y;
        public int z;

        public IntegerPoint(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean diagonallyAdjacentOrEqual(IntegerPoint other) {
            int xdiff = Math.abs(other.x - this.x);
            int ydiff = Math.abs(other.y - this.y);
            int zdiff = Math.abs(other.z - this.z);
            return xdiff < 1 && ydiff < 1 && zdiff < 1;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + "," + this.z + ")";
        }
    }
}

