/*
 * Decompiled with CFR 0.152.
 */
package vib.app;

import amira.AmiraMeshDecoder;
import amira.AmiraTable;
import amira.AmiraTableEncoder;
import ij.text.TextPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import vib.FloatMatrix;

public class ImageMetaData {
    public Material[] materials = new Material[0];
    public Transformation[] transformations = new Transformation[0];
    private String statisticsPath;
    private static final String AMIRA_HEADINGS = "Nr\tMaterial\tCount\tVolume\tCenterX\tCenterY\tCenterZ";

    public ImageMetaData() {
    }

    public ImageMetaData(String fileName) {
        this();
        this.loadFrom(fileName);
    }

    public FloatMatrix getMatrix(String name) {
        for (int i = 0; i < this.transformations.length; ++i) {
            if (!this.transformations[i].name.equals(name)) continue;
            return this.transformations[i].matrix;
        }
        return null;
    }

    public void setMatrix(String name, FloatMatrix matrix) {
        for (int i = 0; i < this.transformations.length; ++i) {
            if (!this.transformations[i].name.equals(name)) continue;
            this.transformations[i].matrix = matrix;
            return;
        }
        Transformation[] newTransformations = new Transformation[this.transformations.length + 1];
        System.arraycopy(this.transformations, 0, newTransformations, 0, this.transformations.length);
        Transformation newTransformation = new Transformation();
        newTransformation.name = name;
        newTransformation.matrix = matrix;
        newTransformations[this.transformations.length] = newTransformation;
        this.transformations = newTransformations;
    }

    public Material getMaterial(String name) {
        for (int i = 0; i < this.materials.length; ++i) {
            if (!this.materials[i].name.equals(name)) continue;
            return this.materials[i];
        }
        return null;
    }

    public int getMaterialIndex(String name) {
        for (int i = 0; i < this.materials.length; ++i) {
            if (!this.materials[i].name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void setMaterial(String name, int count, double volume, double centerX, double centerY, double centerZ) {
        int i = this.getMaterialIndex(name);
        if (i < 0) {
            Material[] newMaterials = new Material[this.materials.length + 1];
            i = this.materials.length;
            System.arraycopy(this.materials, 0, newMaterials, 0, i);
            this.materials = newMaterials;
            this.materials[i] = new Material();
        }
        Material m = this.materials[i];
        m.name = name;
        m.count = count;
        m.volume = volume;
        m.centerX = centerX;
        m.centerY = centerY;
        m.centerZ = centerZ;
    }

    public void loadFrom(String path) {
        this.statisticsPath = path;
        if (!new File(path).exists()) {
            return;
        }
        AmiraMeshDecoder decoder = new AmiraMeshDecoder();
        if (!decoder.open(path) || !decoder.isTable()) {
            return;
        }
        AmiraTable table = decoder.getTable();
        TextPanel panel = table.getTextPanel();
        this.materials = new Material[panel.getLineCount()];
        for (int i = 0; i < this.materials.length; ++i) {
            String[] values = ImageMetaData.split(panel.getLine(i));
            this.materials[i] = new Material();
            this.materials[i].name = values[1];
            this.materials[i].count = Integer.parseInt(values[2]);
            this.materials[i].volume = Double.parseDouble(values[3]);
            this.materials[i].centerX = Double.parseDouble(values[4]);
            this.materials[i].centerY = Double.parseDouble(values[5]);
            this.materials[i].centerZ = Double.parseDouble(values[6]);
        }
        Hashtable props = table.getParameters();
        table.close();
        ArrayList<Transformation> transforms = new ArrayList<Transformation>();
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.indexOf("Transformation") < 0) continue;
            Transformation t = new Transformation();
            t.name = key;
            String matrix = (String)props.get(key);
            t.matrix = FloatMatrix.parseMatrix(matrix);
            transforms.add(t);
        }
        this.transformations = new Transformation[transforms.size()];
        for (int i = 0; i < this.transformations.length; ++i) {
            this.transformations[i] = (Transformation)transforms.get(i);
        }
    }

    public boolean saveTo(String path) {
        this.statisticsPath = path;
        String data = "";
        for (int i = 0; i < this.materials.length; ++i) {
            Material m = this.materials[i];
            data = data + "" + (i + 1) + "\t" + m.name + "\t" + m.count + "\t" + m.volume + "\t" + m.centerX + "\t" + m.centerY + "\t" + m.centerZ + "\n";
        }
        AmiraTable table = new AmiraTable("Statistics for " + path, AMIRA_HEADINGS, data, true);
        Hashtable p = table.getParameters();
        for (int i = 0; i < this.transformations.length; ++i) {
            Transformation t = this.transformations[i];
            p.put(t.name, t.matrix.toStringForAmira());
        }
        AmiraTableEncoder encoder = new AmiraTableEncoder(table);
        return encoder.write(path);
    }

    private static String[] split(String line) {
        ArrayList<String> list = new ArrayList<String>();
        int tab = -1;
        do {
            int lastTab = tab;
            if ((tab = line.indexOf(9, tab + 1)) >= 0) {
                list.add(line.substring(lastTab + 1, tab));
                continue;
            }
            list.add(line.substring(lastTab + 1));
        } while (tab >= 0);
        String[] result = new String[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)list.get(i);
        }
        return result;
    }

    public boolean upToDate(String sourcePath, String transformLabel) {
        File thisFile = new File(this.statisticsPath);
        if (!thisFile.exists()) {
            return false;
        }
        File sourceFile = new File(sourcePath);
        if (sourceFile.exists() && thisFile.lastModified() < sourceFile.lastModified()) {
            return false;
        }
        return this.getMatrix(transformLabel) != null;
    }

    public static class Transformation {
        public String name;
        FloatMatrix matrix;
    }

    public static class Material {
        public String name;
        public int count;
        public double volume;
        public double centerX;
        public double centerY;
        public double centerZ;
    }
}

