/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.sobel;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.Sobel.class)
public class SobelRAI<T extends RealType<T>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>
implements Ops.Filter.Sobel {
    private UnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> createRAI;
    private UnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> squareMapOp;
    private UnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> sqrtMapOp;
    private BinaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> addOp;
    private UnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>[] derivativeComputers;

    @Override
    public void initialize() {
        this.createRAI = RAIs.function(this.ops(), Ops.Create.Img.class, (RandomAccessibleInterval)this.in(), new Object[0]);
        Ops.Math.Sqr squareOp = this.ops().op(Ops.Math.Sqr.class, RealType.class, RealType.class);
        this.squareMapOp = RAIs.computer(this.ops(), Ops.Map.class, (RandomAccessibleInterval)this.in(), squareOp);
        Ops.Math.Sqrt sqrtOp = this.ops().op(Ops.Math.Sqrt.class, RealType.class, RealType.class);
        this.sqrtMapOp = RAIs.computer(this.ops(), Ops.Map.class, (RandomAccessibleInterval)this.in(), sqrtOp);
        this.addOp = RAIs.binaryComputer(this.ops(), Ops.Math.Add.class, (RandomAccessibleInterval)this.in(), (RandomAccessibleInterval)this.in(), new Object[0]);
        this.derivativeComputers = new UnaryComputerOp[((RandomAccessibleInterval)this.in()).numDimensions()];
        for (int i = 0; i < ((RandomAccessibleInterval)this.in()).numDimensions(); ++i) {
            this.derivativeComputers[i] = RAIs.computer(this.ops(), Ops.Filter.PartialDerivative.class, (RandomAccessibleInterval)this.in(), i);
        }
    }

    @Override
    public void compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<T> output) {
        for (int i = 0; i < this.derivativeComputers.length; ++i) {
            RandomAccessibleInterval<T> derivative = this.createRAI.calculate(input);
            this.derivativeComputers[i].compute(input, derivative);
            this.squareMapOp.compute(derivative, derivative);
            this.addOp.compute(output, derivative, output);
        }
        this.sqrtMapOp.compute(output, output);
    }

    @Override
    public RandomAccessibleInterval<T> createOutput(RandomAccessibleInterval<T> input) {
        return this.createRAI.calculate(input);
    }
}

