/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scijava.convert.ConvertService;
import org.scijava.parse.ParseService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptInfo;
import org.scijava.script.process.ScriptProcessor;

public abstract class DirectiveScriptProcessor
implements ScriptProcessor {
    private final Pattern p = Pattern.compile("^#@(\\w*)\\s*(\\((.*)\\))?\\s*(.*)$");
    @Parameter
    private ConvertService convertService;
    @Parameter
    private ParseService parser;
    private ScriptInfo info;
    private Predicate<String> directivesToMatch;

    public DirectiveScriptProcessor(Predicate<String> directivesToMatch) {
        this.directivesToMatch = directivesToMatch;
    }

    @Override
    public void begin(ScriptInfo scriptInfo) {
        this.info = scriptInfo;
    }

    @Override
    public String process(String line) {
        if (!line.startsWith("#@")) {
            return line;
        }
        Matcher m = this.p.matcher(line);
        if (!m.matches()) {
            return line;
        }
        String directive = m.group(1);
        if (!this.directivesToMatch.test(directive)) {
            return line;
        }
        String attrString = m.group(3);
        Map<String, Object> attrs = attrString == null ? Collections.emptyMap() : this.parser.parse(attrString, false).asMap();
        String theRest = m.group(4);
        return this.process(directive, attrs, theRest);
    }

    protected abstract String process(String var1, Map<String, Object> var2, String var3);

    protected ScriptInfo info() {
        return this.info;
    }

    protected boolean is(String key, String desired) {
        return desired.equalsIgnoreCase(key);
    }

    protected <T> T as(Object v, Class<T> type) {
        T converted = this.convertService.convert(v, type);
        if (converted != null) {
            return converted;
        }
        return this.convertService.convert((Object)v.toString(), type);
    }

    protected <T> List<T> asList(Object v, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        List list = this.as(v, List.class);
        for (Object item : list) {
            result.add(this.as(item, type));
        }
        return result;
    }
}

