/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh;

public final class Geometry {
    private static final double EPSILON;
    private static final double SPLITTER;
    private static final double O2DERRBOUND;
    private static final double O3DERRBOUND;
    private static final double INCERRBOUND;
    private static final double INSERRBOUND;
    private static final double IOSERRBOUND;

    public static double leftOfLine(double xa, double ya, double xb, double yb, double xc, double yc) {
        double detsum;
        double detleft = (xa - xc) * (yb - yc);
        double detright = (ya - yc) * (xb - xc);
        double det = detleft - detright;
        if (detleft > 0.0) {
            if (detright <= 0.0) {
                return det;
            }
            detsum = detleft + detright;
        } else if (detleft < 0.0) {
            if (detright >= 0.0) {
                return det;
            }
            detsum = -detleft - detright;
        } else {
            return det;
        }
        double errbound = O2DERRBOUND * detsum;
        if (det >= errbound || -det >= errbound) {
            return det;
        }
        return Geometry.leftOfLineExact(xa, ya, xb, yb, xc, yc);
    }

    public static double leftOfLine(double[] pa, double[] pb, double[] pc) {
        return Geometry.leftOfLine(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1]);
    }

    public static double leftOfLine(float[] pa, float[] pb, float[] pc) {
        return Geometry.leftOfLine(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1]);
    }

    public static double leftOfLineFast(double xa, double ya, double xb, double yb, double xc, double yc) {
        double acx = xa - xc;
        double bcx = xb - xc;
        double acy = ya - yc;
        double bcy = yb - yc;
        return acx * bcy - acy * bcx;
    }

    public static double leftOfLineFast(double[] pa, double[] pb, double[] pc) {
        return Geometry.leftOfLineFast(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1]);
    }

    public static double leftOfLineFast(float[] pa, float[] pb, float[] pc) {
        return Geometry.leftOfLineFast(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1]);
    }

    public static double leftOfPlane(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double xd, double yd, double zd) {
        double permanent;
        double errbound;
        double adx = xa - xd;
        double bdx = xb - xd;
        double cdx = xc - xd;
        double ady = ya - yd;
        double bdy = yb - yd;
        double cdy = yc - yd;
        double adz = za - zd;
        double bdz = zb - zd;
        double cdz = zc - zd;
        double bdxcdy = bdx * cdy;
        double cdxbdy = cdx * bdy;
        double cdxady = cdx * ady;
        double adxcdy = adx * cdy;
        double adxbdy = adx * bdy;
        double bdxady = bdx * ady;
        double det = adz * (bdxcdy - cdxbdy) + bdz * (cdxady - adxcdy) + cdz * (adxbdy - bdxady);
        if (adz < 0.0) {
            adz = -adz;
        }
        if (bdz < 0.0) {
            bdz = -bdz;
        }
        if (cdz < 0.0) {
            cdz = -cdz;
        }
        if (bdxcdy < 0.0) {
            bdxcdy = -bdxcdy;
        }
        if (cdxbdy < 0.0) {
            cdxbdy = -cdxbdy;
        }
        if (cdxady < 0.0) {
            cdxady = -cdxady;
        }
        if (adxcdy < 0.0) {
            adxcdy = -adxcdy;
        }
        if (adxbdy < 0.0) {
            adxbdy = -adxbdy;
        }
        if (bdxady < 0.0) {
            bdxady = -bdxady;
        }
        if (det > (errbound = O3DERRBOUND * (permanent = (bdxcdy + cdxbdy) * adz + (cdxady + adxcdy) * bdz + (adxbdy + bdxady) * cdz)) || -det > errbound) {
            return det;
        }
        return Geometry.leftOfPlaneExact(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd);
    }

    public static double leftOfPlane(double[] pa, double[] pb, double[] pc, double[] pd) {
        return Geometry.leftOfPlane(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2]);
    }

    public static double leftOfPlane(float[] pa, float[] pb, float[] pc, float[] pd) {
        return Geometry.leftOfPlane(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2]);
    }

    public static double leftOfPlaneFast(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double xd, double yd, double zd) {
        double adx = xa - xd;
        double bdx = xb - xd;
        double cdx = xc - xd;
        double ady = ya - yd;
        double bdy = yb - yd;
        double cdy = yc - yd;
        double adz = za - zd;
        double bdz = zb - zd;
        double cdz = zc - zd;
        return adx * (bdy * cdz - bdz * cdy) + bdx * (cdy * adz - cdz * ady) + cdx * (ady * bdz - adz * bdy);
    }

    public static double leftOfPlaneFast(double[] pa, double[] pb, double[] pc, double[] pd) {
        return Geometry.leftOfPlaneFast(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2]);
    }

    public static double leftOfPlaneFast(float[] pa, float[] pb, float[] pc, float[] pd) {
        return Geometry.leftOfPlaneFast(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2]);
    }

    public static double inCircle(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd) {
        double permanent;
        double errbound;
        double adx = xa - xd;
        double bdx = xb - xd;
        double cdx = xc - xd;
        double ady = ya - yd;
        double bdy = yb - yd;
        double cdy = yc - yd;
        double bdxcdy = bdx * cdy;
        double cdxbdy = cdx * bdy;
        double alift = adx * adx + ady * ady;
        double cdxady = cdx * ady;
        double adxcdy = adx * cdy;
        double blift = bdx * bdx + bdy * bdy;
        double adxbdy = adx * bdy;
        double bdxady = bdx * ady;
        double clift = cdx * cdx + cdy * cdy;
        double det = alift * (bdxcdy - cdxbdy) + blift * (cdxady - adxcdy) + clift * (adxbdy - bdxady);
        if (bdxcdy < 0.0) {
            bdxcdy = -bdxcdy;
        }
        if (cdxbdy < 0.0) {
            cdxbdy = -cdxbdy;
        }
        if (adxcdy < 0.0) {
            adxcdy = -adxcdy;
        }
        if (cdxady < 0.0) {
            cdxady = -cdxady;
        }
        if (adxbdy < 0.0) {
            adxbdy = -adxbdy;
        }
        if (bdxady < 0.0) {
            bdxady = -bdxady;
        }
        if (det > (errbound = INCERRBOUND * (permanent = alift * (bdxcdy + cdxbdy) + blift * (cdxady + adxcdy) + clift * (adxbdy + bdxady))) || -det > errbound) {
            return det;
        }
        return Geometry.inCircleExact(xa, ya, xb, yb, xc, yc, xd, yd);
    }

    public static double inCircle(double[] pa, double[] pb, double[] pc, double[] pd) {
        return Geometry.inCircle(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1], pd[0], pd[1]);
    }

    public static double inCircle(float[] pa, float[] pb, float[] pc, float[] pd) {
        return Geometry.inCircle(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1], pd[0], pd[1]);
    }

    public static double inCircleFast(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd) {
        double adx = xa - xd;
        double ady = ya - yd;
        double bdx = xb - xd;
        double bdy = yb - yd;
        double cdx = xc - xd;
        double cdy = yc - yd;
        double abdet = adx * bdy - bdx * ady;
        double bcdet = bdx * cdy - cdx * bdy;
        double cadet = cdx * ady - adx * cdy;
        double alift = adx * adx + ady * ady;
        double blift = bdx * bdx + bdy * bdy;
        double clift = cdx * cdx + cdy * cdy;
        return alift * bcdet + blift * cadet + clift * abdet;
    }

    public static double inCircleFast(double[] pa, double[] pb, double[] pc, double[] pd) {
        return Geometry.inCircleFast(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1], pd[0], pd[1]);
    }

    public static double inCircleFast(float[] pa, float[] pb, float[] pc, float[] pd) {
        return Geometry.inCircleFast(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1], pd[0], pd[1]);
    }

    public static double inSphere(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double xd, double yd, double zd, double xe, double ye, double ze) {
        double permanent;
        double errbound;
        double aex = xa - xe;
        double bex = xb - xe;
        double cex = xc - xe;
        double dex = xd - xe;
        double aey = ya - ye;
        double bey = yb - ye;
        double cey = yc - ye;
        double dey = yd - ye;
        double aez = za - ze;
        double bez = zb - ze;
        double cez = zc - ze;
        double dez = zd - ze;
        double aexbey = aex * bey;
        double bexaey = bex * aey;
        double ab = aexbey - bexaey;
        double bexcey = bex * cey;
        double cexbey = cex * bey;
        double bc = bexcey - cexbey;
        double cexdey = cex * dey;
        double dexcey = dex * cey;
        double cd = cexdey - dexcey;
        double dexaey = dex * aey;
        double aexdey = aex * dey;
        double da = dexaey - aexdey;
        double aexcey = aex * cey;
        double cexaey = cex * aey;
        double ac = aexcey - cexaey;
        double bexdey = bex * dey;
        double dexbey = dex * bey;
        double bd = bexdey - dexbey;
        double abc = aez * bc - bez * ac + cez * ab;
        double bcd = bez * cd - cez * bd + dez * bc;
        double cda = cez * da + dez * ac + aez * cd;
        double dab = dez * ab + aez * bd + bez * da;
        double alift = aex * aex + aey * aey + aez * aez;
        double blift = bex * bex + bey * bey + bez * bez;
        double clift = cex * cex + cey * cey + cez * cez;
        double dlift = dex * dex + dey * dey + dez * dez;
        double det = dlift * abc - clift * dab + (blift * cda - alift * bcd);
        if (aez < 0.0) {
            aez = -aez;
        }
        if (bez < 0.0) {
            bez = -bez;
        }
        if (cez < 0.0) {
            cez = -cez;
        }
        if (dez < 0.0) {
            dez = -dez;
        }
        if (aexbey < 0.0) {
            aexbey = -aexbey;
        }
        if (bexaey < 0.0) {
            bexaey = -bexaey;
        }
        if (bexcey < 0.0) {
            bexcey = -bexcey;
        }
        if (cexbey < 0.0) {
            cexbey = -cexbey;
        }
        if (cexdey < 0.0) {
            cexdey = -cexdey;
        }
        if (dexcey < 0.0) {
            dexcey = -dexcey;
        }
        if (dexaey < 0.0) {
            dexaey = -dexaey;
        }
        if (aexdey < 0.0) {
            aexdey = -aexdey;
        }
        if (aexcey < 0.0) {
            aexcey = -aexcey;
        }
        if (cexaey < 0.0) {
            cexaey = -cexaey;
        }
        if (bexdey < 0.0) {
            bexdey = -bexdey;
        }
        if (dexbey < 0.0) {
            dexbey = -dexbey;
        }
        if (det > (errbound = INSERRBOUND * (permanent = ((cexdey + dexcey) * bez + (dexbey + bexdey) * cez + (bexcey + cexbey) * dez) * alift + ((dexaey + aexdey) * cez + (aexcey + cexaey) * dez + (cexdey + dexcey) * aez) * blift + ((aexbey + bexaey) * dez + (bexdey + dexbey) * aez + (dexaey + aexdey) * bez) * clift + ((bexcey + cexbey) * aez + (cexaey + aexcey) * bez + (aexbey + bexaey) * cez) * dlift)) || -det > errbound) {
            return det;
        }
        return Geometry.inSphereExact(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd, xe, ye, ze);
    }

    public static double inSphere(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        return Geometry.inSphere(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2], pe[0], pe[1], pe[2]);
    }

    public static double inSphere(float[] pa, float[] pb, float[] pc, float[] pd, float[] pe) {
        return Geometry.inSphere(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2], pe[0], pe[1], pe[2]);
    }

    public static double inSphereFast(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double xd, double yd, double zd, double xe, double ye, double ze) {
        double aex = xa - xe;
        double bex = xb - xe;
        double cex = xc - xe;
        double dex = xd - xe;
        double aey = ya - ye;
        double bey = yb - ye;
        double cey = yc - ye;
        double dey = yd - ye;
        double aez = za - ze;
        double bez = zb - ze;
        double cez = zc - ze;
        double dez = zd - ze;
        double ab = aex * bey - bex * aey;
        double bc = bex * cey - cex * bey;
        double cd = cex * dey - dex * cey;
        double da = dex * aey - aex * dey;
        double ac = aex * cey - cex * aey;
        double bd = bex * dey - dex * bey;
        double abc = aez * bc - bez * ac + cez * ab;
        double bcd = bez * cd - cez * bd + dez * bc;
        double cda = cez * da + dez * ac + aez * cd;
        double dab = dez * ab + aez * bd + bez * da;
        double alift = aex * aex + aey * aey + aez * aez;
        double blift = bex * bex + bey * bey + bez * bez;
        double clift = cex * cex + cey * cey + cez * cez;
        double dlift = dex * dex + dey * dey + dez * dez;
        return dlift * abc - clift * dab + (blift * cda - alift * bcd);
    }

    public static double inSphereFast(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        return Geometry.inSphereFast(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2], pe[0], pe[1], pe[2]);
    }

    public static double inSphereFast(float[] pa, float[] pb, float[] pc, float[] pd, float[] pe) {
        return Geometry.inSphereFast(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2], pe[0], pe[1], pe[2]);
    }

    public static double inOrthoSphere(double xa, double ya, double za, double wa, double xb, double yb, double zb, double wb, double xc, double yc, double zc, double wc, double xd, double yd, double zd, double wd, double xe, double ye, double ze, double we) {
        double permanent;
        double errbound;
        double aex = xa - xe;
        double bex = xb - xe;
        double cex = xc - xe;
        double dex = xd - xe;
        double aey = ya - ye;
        double bey = yb - ye;
        double cey = yc - ye;
        double dey = yd - ye;
        double aez = za - ze;
        double bez = zb - ze;
        double cez = zc - ze;
        double dez = zd - ze;
        double aew = wa - we;
        double bew = wb - we;
        double cew = wc - we;
        double dew = wd - we;
        double aexbey = aex * bey;
        double bexaey = bex * aey;
        double ab = aexbey - bexaey;
        double bexcey = bex * cey;
        double cexbey = cex * bey;
        double bc = bexcey - cexbey;
        double cexdey = cex * dey;
        double dexcey = dex * cey;
        double cd = cexdey - dexcey;
        double dexaey = dex * aey;
        double aexdey = aex * dey;
        double da = dexaey - aexdey;
        double aexcey = aex * cey;
        double cexaey = cex * aey;
        double ac = aexcey - cexaey;
        double bexdey = bex * dey;
        double dexbey = dex * bey;
        double bd = bexdey - dexbey;
        double abc = aez * bc - bez * ac + cez * ab;
        double bcd = bez * cd - cez * bd + dez * bc;
        double cda = cez * da + dez * ac + aez * cd;
        double dab = dez * ab + aez * bd + bez * da;
        double alift = aex * aex + aey * aey + aez * aez;
        double blift = bex * bex + bey * bey + bez * bez;
        double clift = cex * cex + cey * cey + cez * cez;
        double dlift = dex * dex + dey * dey + dez * dez;
        double det = (dlift - dew) * abc - (clift - cew) * dab + ((blift - bew) * cda - (alift - aew) * bcd);
        if (aez < 0.0) {
            aez = -aez;
        }
        if (bez < 0.0) {
            bez = -bez;
        }
        if (cez < 0.0) {
            cez = -cez;
        }
        if (dez < 0.0) {
            dez = -dez;
        }
        if (aew < 0.0) {
            aew = -aew;
        }
        if (bew < 0.0) {
            bew = -bew;
        }
        if (cew < 0.0) {
            cew = -cew;
        }
        if (dew < 0.0) {
            dew = -dew;
        }
        if (aexbey < 0.0) {
            aexbey = -aexbey;
        }
        if (bexaey < 0.0) {
            bexaey = -bexaey;
        }
        if (bexcey < 0.0) {
            bexcey = -bexcey;
        }
        if (cexbey < 0.0) {
            cexbey = -cexbey;
        }
        if (cexdey < 0.0) {
            cexdey = -cexdey;
        }
        if (dexcey < 0.0) {
            dexcey = -dexcey;
        }
        if (dexaey < 0.0) {
            dexaey = -dexaey;
        }
        if (aexdey < 0.0) {
            aexdey = -aexdey;
        }
        if (aexcey < 0.0) {
            aexcey = -aexcey;
        }
        if (cexaey < 0.0) {
            cexaey = -cexaey;
        }
        if (bexdey < 0.0) {
            bexdey = -bexdey;
        }
        if (dexbey < 0.0) {
            dexbey = -dexbey;
        }
        if (det > (errbound = IOSERRBOUND * (permanent = ((cexdey + dexcey) * bez + (dexbey + bexdey) * cez + (bexcey + cexbey) * dez) * (alift + aew) + ((dexaey + aexdey) * cez + (aexcey + cexaey) * dez + (cexdey + dexcey) * aez) * (blift + bew) + ((aexbey + bexaey) * dez + (bexdey + dexbey) * aez + (dexaey + aexdey) * bez) * (clift + cew) + ((bexcey + cexbey) * aez + (cexaey + aexcey) * bez + (aexbey + bexaey) * cez) * (dlift + dew))) || -det > errbound) {
            return det;
        }
        return Geometry.inOrthoSphereExact(xa, ya, za, wa, xb, yb, zb, wb, xc, yc, zc, wc, xd, yd, zd, wd, xe, ye, ze, we);
    }

    public static double inOrthoSphere(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        return Geometry.inOrthoSphere(pa[0], pa[1], pa[2], pa[3], pb[0], pb[1], pb[2], pb[3], pc[0], pc[1], pc[2], pc[3], pd[0], pd[1], pd[2], pd[3], pe[0], pe[1], pe[2], pe[3]);
    }

    public static double inOrthoSphere(float[] pa, float[] pb, float[] pc, float[] pd, float[] pe) {
        return Geometry.inOrthoSphere(pa[0], pa[1], pa[2], pa[3], pb[0], pb[1], pb[2], pb[3], pc[0], pc[1], pc[2], pc[3], pd[0], pd[1], pd[2], pd[3], pe[0], pe[1], pe[2], pe[3]);
    }

    public static double inOrthoSphereFast(double xa, double ya, double za, double wa, double xb, double yb, double zb, double wb, double xc, double yc, double zc, double wc, double xd, double yd, double zd, double wd, double xe, double ye, double ze, double we) {
        double aex = xa - xe;
        double bex = xb - xe;
        double cex = xc - xe;
        double dex = xd - xe;
        double aey = ya - ye;
        double bey = yb - ye;
        double cey = yc - ye;
        double dey = yd - ye;
        double aez = za - ze;
        double bez = zb - ze;
        double cez = zc - ze;
        double dez = zd - ze;
        double aew = wa - we;
        double bew = wb - we;
        double cew = wc - we;
        double dew = wd - we;
        double ab = aex * bey - bex * aey;
        double bc = bex * cey - cex * bey;
        double cd = cex * dey - dex * cey;
        double da = dex * aey - aex * dey;
        double ac = aex * cey - cex * aey;
        double bd = bex * dey - dex * bey;
        double abc = aez * bc - bez * ac + cez * ab;
        double bcd = bez * cd - cez * bd + dez * bc;
        double cda = cez * da + dez * ac + aez * cd;
        double dab = dez * ab + aez * bd + bez * da;
        double alift = aex * aex + aey * aey + aez * aez - aew;
        double blift = bex * bex + bey * bey + bez * bez - bew;
        double clift = cex * cex + cey * cey + cez * cez - cew;
        double dlift = dex * dex + dey * dey + dez * dez - dew;
        return dlift * abc - clift * dab + (blift * cda - alift * bcd);
    }

    public static double inOrthoSphereFast(double[] pa, double[] pb, double[] pc, double[] pd, double[] pe) {
        return Geometry.inOrthoSphereFast(pa[0], pa[1], pa[2], pa[3], pb[0], pb[1], pb[2], pb[3], pc[0], pc[1], pc[2], pc[3], pd[0], pd[1], pd[2], pd[3], pe[0], pe[1], pe[2], pe[3]);
    }

    public static double inOrthoSphereFast(float[] pa, float[] pb, float[] pc, float[] pd, float[] pe) {
        return Geometry.inOrthoSphereFast(pa[0], pa[1], pa[2], pa[3], pb[0], pb[1], pb[2], pb[3], pc[0], pc[1], pc[2], pc[3], pd[0], pd[1], pd[2], pd[3], pe[0], pe[1], pe[2], pe[3]);
    }

    public static void centerCircle(float xa, float ya, float xb, float yb, float xc, float yc, float[] po) {
        double acx = xa - xc;
        double bcx = xb - xc;
        double acy = ya - yc;
        double bcy = yb - yc;
        double acs = acx * acx + acy * acy;
        double bcs = bcx * bcx + bcy * bcy;
        double scale = 0.5 / Geometry.leftOfLine(xa, ya, xb, yb, xc, yc);
        po[0] = (float)((double)xc + scale * (acs * bcy - bcs * acy));
        po[1] = (float)((double)yc + scale * (bcs * acx - acs * bcx));
    }

    public static void centerCircle(float[] pa, float[] pb, float[] pc, float[] po) {
        Geometry.centerCircle(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1], po);
    }

    public static void centerCircle(double xa, double ya, double xb, double yb, double xc, double yc, double[] po) {
        double acx = xa - xc;
        double bcx = xb - xc;
        double acy = ya - yc;
        double bcy = yb - yc;
        double acs = acx * acx + acy * acy;
        double bcs = bcx * bcx + bcy * bcy;
        double scale = 0.5 / Geometry.leftOfLine(xa, ya, xb, yb, xc, yc);
        po[0] = xc + scale * (acs * bcy - bcs * acy);
        po[1] = yc + scale * (bcs * acx - acs * bcx);
    }

    public static void centerCircle(double[] pa, double[] pb, double[] pc, double[] po) {
        Geometry.centerCircle(pa[0], pa[1], pb[0], pb[1], pc[0], pc[1], po);
    }

    public static void centerSphere(float xa, float ya, float za, float xb, float yb, float zb, float xc, float yc, float zc, float xd, float yd, float zd, float[] po) {
        double adx = xa - xd;
        double bdx = xb - xd;
        double cdx = xc - xd;
        double ady = ya - yd;
        double bdy = yb - yd;
        double cdy = yc - yd;
        double adz = za - zd;
        double bdz = zb - zd;
        double cdz = zc - zd;
        double ads = adx * adx + ady * ady + adz * adz;
        double bds = bdx * bdx + bdy * bdy + bdz * bdz;
        double cds = cdx * cdx + cdy * cdy + cdz * cdz;
        double scale = 0.5 / Geometry.leftOfPlane(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd);
        po[0] = xd + (float)(scale * (ads * (bdy * cdz - cdy * bdz) + bds * (cdy * adz - ady * cdz) + cds * (ady * bdz - bdy * adz)));
        po[1] = yd + (float)(scale * (ads * (bdz * cdx - cdz * bdx) + bds * (cdz * adx - adz * cdx) + cds * (adz * bdx - bdz * adx)));
        po[2] = zd + (float)(scale * (ads * (bdx * cdy - cdx * bdy) + bds * (cdx * ady - adx * cdy) + cds * (adx * bdy - bdx * ady)));
    }

    public static void centerSphere(float[] pa, float[] pb, float[] pc, float[] pd, float[] po) {
        Geometry.centerSphere(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2], po);
    }

    public static void centerSphere(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double xd, double yd, double zd, double[] po) {
        double adx = xa - xd;
        double bdx = xb - xd;
        double cdx = xc - xd;
        double ady = ya - yd;
        double bdy = yb - yd;
        double cdy = yc - yd;
        double adz = za - zd;
        double bdz = zb - zd;
        double cdz = zc - zd;
        double ads = adx * adx + ady * ady + adz * adz;
        double bds = bdx * bdx + bdy * bdy + bdz * bdz;
        double cds = cdx * cdx + cdy * cdy + cdz * cdz;
        double scale = 0.5 / Geometry.leftOfPlane(xa, ya, za, xb, yb, zb, xc, yc, zc, xd, yd, zd);
        po[0] = xd + scale * (ads * (bdy * cdz - cdy * bdz) + bds * (cdy * adz - ady * cdz) + cds * (ady * bdz - bdy * adz));
        po[1] = yd + scale * (ads * (bdz * cdx - cdz * bdx) + bds * (cdz * adx - adz * cdx) + cds * (adz * bdx - bdz * adx));
        po[2] = zd + scale * (ads * (bdx * cdy - cdx * bdy) + bds * (cdx * ady - adx * cdy) + cds * (adx * bdy - bdx * ady));
    }

    public static void centerSphere(double[] pa, double[] pb, double[] pc, double[] pd, double[] po) {
        Geometry.centerSphere(pa[0], pa[1], pa[2], pb[0], pb[1], pb[2], pc[0], pc[1], pc[2], pd[0], pd[1], pd[2], po);
    }

    public static void centerCircle3D(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double[] po) {
        double acx = xa - xc;
        double acy = ya - yc;
        double acz = za - zc;
        double bcx = xb - xc;
        double bcy = yb - yc;
        double bcz = zb - zc;
        double acs = acx * acx + acy * acy + acz * acz;
        double bcs = bcx * bcx + bcy * bcy + bcz * bcz;
        double abx = Geometry.leftOfLine(ya, za, yb, zb, yc, zc);
        double aby = Geometry.leftOfLine(za, xa, zb, xb, zc, xc);
        double abz = Geometry.leftOfLine(xa, ya, xb, yb, xc, yc);
        double scale = 0.5 / (abx * abx + aby * aby + abz * abz);
        po[0] = xc + scale * ((acs * bcy - bcs * acy) * abz - (acs * bcz - bcs * acz) * aby);
        po[1] = yc + scale * ((acs * bcz - bcs * acz) * abx - (acs * bcx - bcs * acx) * abz);
        po[2] = zc + scale * ((acs * bcx - bcs * acx) * aby - (acs * bcy - bcs * acy) * abx);
    }

    private static strictfp void twoSum(double a, double b, Two t) {
        double x = a + b;
        double bvirt = x - a;
        double avirt = x - bvirt;
        double bround = b - bvirt;
        double around = a - avirt;
        t.x = x;
        t.y = around + bround;
    }

    private static strictfp void twoSumFast(double a, double b, Two t) {
        double x = a + b;
        double bvirt = x - a;
        t.x = x;
        t.y = b - bvirt;
    }

    private static strictfp void twoDiff(double a, double b, Two t) {
        double x = a - b;
        double bvirt = a - x;
        double avirt = x + bvirt;
        double bround = bvirt - b;
        double around = a - avirt;
        t.x = x;
        t.y = around + bround;
    }

    private static strictfp void split(double a, Two t) {
        double c = SPLITTER * a;
        double abig = c - a;
        t.x = c - abig;
        t.y = a - t.x;
    }

    private static strictfp void twoProduct1Presplit(double a, double b, double bhi, double blo, Two t) {
        Geometry.split(a, t);
        double ahi = t.x;
        double alo = t.y;
        t.x = a * b;
        double err1 = t.x - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        t.y = alo * blo - err3;
    }

    private static strictfp void twoProduct2Presplit(double a, double ahi, double alo, double b, double bhi, double blo, Two t) {
        t.x = a * b;
        double err1 = t.x - ahi * bhi;
        double err2 = err1 - alo * bhi;
        double err3 = err2 - ahi * blo;
        t.y = alo * blo - err3;
    }

    private static strictfp void twoTwoProduct(double a1, double a0, double b1, double b0, double[] x) {
        Two t = new Two();
        Geometry.split(a0, t);
        double a0hi = t.x;
        double a0lo = t.y;
        Geometry.split(b0, t);
        double b0hi = t.x;
        double b0lo = t.y;
        Geometry.twoProduct2Presplit(a0, a0hi, a0lo, b0, b0hi, b0lo, t);
        double ui = t.x;
        x[0] = t.y;
        Geometry.split(a1, t);
        double a1hi = t.x;
        double a1lo = t.y;
        Geometry.twoProduct2Presplit(a1, a1hi, a1lo, b0, b0hi, b0lo, t);
        double uj = t.x;
        double u0 = t.y;
        Geometry.twoSum(ui, u0, t);
        double uk = t.x;
        double u1 = t.y;
        Geometry.twoSumFast(uj, uk, t);
        double ul = t.x;
        double u2 = t.y;
        Geometry.split(b1, t);
        double b1hi = t.x;
        double b1lo = t.y;
        Geometry.twoProduct2Presplit(a0, a0hi, a0lo, b1, b1hi, b1lo, t);
        ui = t.x;
        u0 = t.y;
        Geometry.twoSum(u1, u0, t);
        uk = t.x;
        x[1] = t.y;
        Geometry.twoSum(u2, uk, t);
        uj = t.x;
        u1 = t.y;
        Geometry.twoSum(ul, uj, t);
        double um = t.x;
        u2 = t.y;
        Geometry.twoProduct2Presplit(a1, a1hi, a1lo, b1, b1hi, b1lo, t);
        uj = t.x;
        u0 = t.y;
        Geometry.twoSum(ui, u0, t);
        double un = t.x;
        u0 = t.y;
        Geometry.twoSum(u1, u0, t);
        ui = t.x;
        x[2] = t.y;
        Geometry.twoSum(u2, ui, t);
        uk = t.x;
        u1 = t.y;
        Geometry.twoSum(um, uk, t);
        ul = t.x;
        u2 = t.y;
        Geometry.twoSum(uj, un, t);
        uk = t.x;
        u0 = t.y;
        Geometry.twoSum(u1, u0, t);
        uj = t.x;
        x[3] = t.y;
        Geometry.twoSum(u2, uj, t);
        ui = t.x;
        u1 = t.y;
        Geometry.twoSum(ul, ui, t);
        um = t.x;
        u2 = t.y;
        Geometry.twoSum(u1, uk, t);
        ui = t.x;
        x[4] = t.y;
        Geometry.twoSum(u2, ui, t);
        uk = t.x;
        x[5] = t.y;
        Geometry.twoSum(um, uk, t);
        x[7] = t.x;
        x[6] = t.y;
    }

    private static int expansionSumZeroElimFast(int elen, double[] e, int flen, double[] f, double[] h) {
        double hh;
        double qnew;
        double q;
        Two t = new Two();
        double enow = e[0];
        double fnow = f[0];
        int eindex = 0;
        int findex = 0;
        if (fnow > enow == fnow > -enow) {
            q = enow;
            if (++eindex < elen) {
                enow = e[eindex];
            }
        } else {
            q = fnow;
            if (++findex < flen) {
                fnow = f[findex];
            }
        }
        int hindex = 0;
        if (eindex < elen && findex < flen) {
            if (fnow > enow == fnow > -enow) {
                Geometry.twoSumFast(enow, q, t);
                qnew = t.x;
                hh = t.y;
                if (++eindex < elen) {
                    enow = e[eindex];
                }
            } else {
                Geometry.twoSumFast(fnow, q, t);
                qnew = t.x;
                hh = t.y;
                if (++findex < flen) {
                    fnow = f[findex];
                }
            }
            q = qnew;
            if (hh != 0.0) {
                h[hindex++] = hh;
            }
            while (eindex < elen && findex < flen) {
                if (fnow > enow == fnow > -enow) {
                    Geometry.twoSum(q, enow, t);
                    qnew = t.x;
                    hh = t.y;
                    if (++eindex < elen) {
                        enow = e[eindex];
                    }
                } else {
                    Geometry.twoSum(q, fnow, t);
                    qnew = t.x;
                    hh = t.y;
                    if (++findex < flen) {
                        fnow = f[findex];
                    }
                }
                q = qnew;
                if (hh == 0.0) continue;
                h[hindex++] = hh;
            }
        }
        while (eindex < elen) {
            Geometry.twoSum(q, enow, t);
            qnew = t.x;
            hh = t.y;
            if (++eindex < elen) {
                enow = e[eindex];
            }
            q = qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        while (findex < flen) {
            Geometry.twoSum(q, fnow, t);
            qnew = t.x;
            hh = t.y;
            if (++findex < flen) {
                fnow = f[findex];
            }
            q = qnew;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        if (q != 0.0 || hindex == 0) {
            h[hindex++] = q;
        }
        return hindex;
    }

    private static int scaleExpansionZeroElim(int elen, double[] e, double b, double[] h) {
        Two t = new Two();
        Geometry.split(b, t);
        double bhi = t.x;
        double blo = t.y;
        Geometry.twoProduct1Presplit(e[0], b, bhi, blo, t);
        double q = t.x;
        double hh = t.y;
        int hindex = 0;
        if (hh != 0.0) {
            h[hindex++] = hh;
        }
        for (int eindex = 1; eindex < elen; ++eindex) {
            double enow = e[eindex];
            Geometry.twoProduct1Presplit(enow, b, bhi, blo, t);
            double product1 = t.x;
            double product0 = t.y;
            Geometry.twoSum(q, product0, t);
            double sum = t.x;
            hh = t.y;
            if (hh != 0.0) {
                h[hindex++] = hh;
            }
            Geometry.twoSumFast(product1, sum, t);
            q = t.x;
            hh = t.y;
            if (hh == 0.0) continue;
            h[hindex++] = hh;
        }
        if (q != 0.0 || hindex == 0) {
            h[hindex++] = q;
        }
        return hindex;
    }

    private static double leftOfLineExact(double xa, double ya, double xb, double yb, double xc, double yc) {
        Two t = new Two();
        Geometry.twoDiff(xa, xc, t);
        double acx = t.x;
        double acxtail = t.y;
        Geometry.twoDiff(ya, yc, t);
        double acy = t.x;
        double acytail = t.y;
        Geometry.twoDiff(xb, xc, t);
        double bcx = t.x;
        double bcxtail = t.y;
        Geometry.twoDiff(yb, yc, t);
        double bcy = t.x;
        double bcytail = t.y;
        double[] axby = new double[8];
        double[] bxay = new double[8];
        Geometry.twoTwoProduct(acx, acxtail, bcy, bcytail, axby);
        double negate = -acy;
        double negatetail = -acytail;
        Geometry.twoTwoProduct(bcx, bcxtail, negate, negatetail, bxay);
        double[] det = new double[16];
        int detlen = Geometry.expansionSumZeroElimFast(8, axby, 8, bxay, det);
        return det[detlen - 1];
    }

    private static double leftOfPlaneExact(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double xd, double yd, double zd) {
        Two t = new Two();
        Geometry.twoDiff(xa, xd, t);
        double adx = t.x;
        double adxtail = t.y;
        Geometry.twoDiff(ya, yd, t);
        double ady = t.x;
        double adytail = t.y;
        Geometry.twoDiff(za, zd, t);
        double adz = t.x;
        double adztail = t.y;
        Geometry.twoDiff(xb, xd, t);
        double bdx = t.x;
        double bdxtail = t.y;
        Geometry.twoDiff(yb, yd, t);
        double bdy = t.x;
        double bdytail = t.y;
        Geometry.twoDiff(zb, zd, t);
        double bdz = t.x;
        double bdztail = t.y;
        Geometry.twoDiff(xc, xd, t);
        double cdx = t.x;
        double cdxtail = t.y;
        Geometry.twoDiff(yc, yd, t);
        double cdy = t.x;
        double cdytail = t.y;
        Geometry.twoDiff(zc, zd, t);
        double cdz = t.x;
        double cdztail = t.y;
        double[] axby = new double[8];
        Geometry.twoTwoProduct(adx, adxtail, bdy, bdytail, axby);
        double negate = -ady;
        double negatetail = -adytail;
        double[] bxay = new double[8];
        Geometry.twoTwoProduct(bdx, bdxtail, negate, negatetail, bxay);
        double[] bxcy = new double[8];
        Geometry.twoTwoProduct(bdx, bdxtail, cdy, cdytail, bxcy);
        negate = -bdy;
        negatetail = -bdytail;
        double[] cxby = new double[8];
        Geometry.twoTwoProduct(cdx, cdxtail, negate, negatetail, cxby);
        double[] cxay = new double[8];
        Geometry.twoTwoProduct(cdx, cdxtail, ady, adytail, cxay);
        negate = -cdy;
        negatetail = -cdytail;
        double[] axcy = new double[8];
        Geometry.twoTwoProduct(adx, adxtail, negate, negatetail, axcy);
        double[] t16 = new double[16];
        double[] t32 = new double[32];
        double[] t32t = new double[32];
        int t16len = Geometry.expansionSumZeroElimFast(8, bxcy, 8, cxby, t16);
        int t32len = Geometry.scaleExpansionZeroElim(t16len, t16, adz, t32);
        int t32tlen = Geometry.scaleExpansionZeroElim(t16len, t16, adztail, t32t);
        double[] adet = new double[64];
        int alen = Geometry.expansionSumZeroElimFast(t32len, t32, t32tlen, t32t, adet);
        t16len = Geometry.expansionSumZeroElimFast(8, cxay, 8, axcy, t16);
        t32len = Geometry.scaleExpansionZeroElim(t16len, t16, bdz, t32);
        t32tlen = Geometry.scaleExpansionZeroElim(t16len, t16, bdztail, t32t);
        double[] bdet = new double[64];
        int blen = Geometry.expansionSumZeroElimFast(t32len, t32, t32tlen, t32t, bdet);
        t16len = Geometry.expansionSumZeroElimFast(8, axby, 8, bxay, t16);
        t32len = Geometry.scaleExpansionZeroElim(t16len, t16, cdz, t32);
        t32tlen = Geometry.scaleExpansionZeroElim(t16len, t16, cdztail, t32t);
        double[] cdet = new double[64];
        int clen = Geometry.expansionSumZeroElimFast(t32len, t32, t32tlen, t32t, cdet);
        double[] abdet = new double[128];
        int ablen = Geometry.expansionSumZeroElimFast(alen, adet, blen, bdet, abdet);
        double[] det = new double[192];
        int detlen = Geometry.expansionSumZeroElimFast(ablen, abdet, clen, cdet, det);
        return det[detlen - 1];
    }

    private static double inCircleExact(double xa, double ya, double xb, double yb, double xc, double yc, double xd, double yd) {
        Two t = new Two();
        Geometry.twoDiff(xa, xd, t);
        double adx = t.x;
        double adxtail = t.y;
        Geometry.twoDiff(ya, yd, t);
        double ady = t.x;
        double adytail = t.y;
        Geometry.twoDiff(xb, xd, t);
        double bdx = t.x;
        double bdxtail = t.y;
        Geometry.twoDiff(yb, yd, t);
        double bdy = t.x;
        double bdytail = t.y;
        Geometry.twoDiff(xc, xd, t);
        double cdx = t.x;
        double cdxtail = t.y;
        Geometry.twoDiff(yc, yd, t);
        double cdy = t.x;
        double cdytail = t.y;
        double[] axby = new double[8];
        double[] bxay = new double[8];
        Geometry.twoTwoProduct(adx, adxtail, bdy, bdytail, axby);
        double negate = -ady;
        double negatetail = -adytail;
        Geometry.twoTwoProduct(bdx, bdxtail, negate, negatetail, bxay);
        double[] bxcy = new double[8];
        double[] cxby = new double[8];
        Geometry.twoTwoProduct(bdx, bdxtail, cdy, cdytail, bxcy);
        negate = -bdy;
        negatetail = -bdytail;
        Geometry.twoTwoProduct(cdx, cdxtail, negate, negatetail, cxby);
        double[] cxay = new double[8];
        double[] axcy = new double[8];
        Geometry.twoTwoProduct(cdx, cdxtail, ady, adytail, cxay);
        negate = -cdy;
        negatetail = -cdytail;
        Geometry.twoTwoProduct(adx, adxtail, negate, negatetail, axcy);
        double[] t16 = new double[16];
        int t16len = Geometry.expansionSumZeroElimFast(8, bxcy, 8, cxby, t16);
        double[] detx = new double[32];
        double[] detxx = new double[64];
        double[] detxt = new double[32];
        double[] detxxt = new double[64];
        double[] detxtxt = new double[64];
        double[] x1 = new double[128];
        double[] x2 = new double[192];
        int xlen = Geometry.scaleExpansionZeroElim(t16len, t16, adx, detx);
        int xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, adx, detxx);
        int xtlen = Geometry.scaleExpansionZeroElim(t16len, t16, adxtail, detxt);
        int xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, adx, detxxt);
        int i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        int xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, adxtail, detxtxt);
        int x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        int x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        double[] dety = new double[32];
        double[] detyy = new double[64];
        double[] detyt = new double[32];
        double[] detyyt = new double[64];
        double[] detytyt = new double[64];
        double[] y1 = new double[128];
        double[] y2 = new double[192];
        int ylen = Geometry.scaleExpansionZeroElim(t16len, t16, ady, dety);
        int yylen = Geometry.scaleExpansionZeroElim(ylen, dety, ady, detyy);
        int ytlen = Geometry.scaleExpansionZeroElim(t16len, t16, adytail, detyt);
        int yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, ady, detyyt);
        int i2 = 0;
        while (i2 < yytlen) {
            int n = i2++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        int ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, adytail, detytyt);
        int y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        int y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        double[] adet = new double[384];
        double[] bdet = new double[384];
        double[] cdet = new double[384];
        int alen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, adet);
        t16len = Geometry.expansionSumZeroElimFast(8, cxay, 8, axcy, t16);
        xlen = Geometry.scaleExpansionZeroElim(t16len, t16, bdx, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, bdx, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t16len, t16, bdxtail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, bdx, detxxt);
        int i3 = 0;
        while (i3 < xxtlen) {
            int n = i3++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, bdxtail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t16len, t16, bdy, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, bdy, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t16len, t16, bdytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, bdy, detyyt);
        i3 = 0;
        while (i3 < yytlen) {
            int n = i3++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, bdytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        int blen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, bdet);
        t16len = Geometry.expansionSumZeroElimFast(8, axby, 8, bxay, t16);
        xlen = Geometry.scaleExpansionZeroElim(t16len, t16, cdx, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, cdx, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t16len, t16, cdxtail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, cdx, detxxt);
        int i4 = 0;
        while (i4 < xxtlen) {
            int n = i4++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, cdxtail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t16len, t16, cdy, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, cdy, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t16len, t16, cdytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, cdy, detyyt);
        i4 = 0;
        while (i4 < yytlen) {
            int n = i4++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, cdytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        int clen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, cdet);
        double[] abdet = new double[768];
        double[] det = new double[1152];
        int ablen = Geometry.expansionSumZeroElimFast(alen, adet, blen, bdet, abdet);
        int detlen = Geometry.expansionSumZeroElimFast(ablen, abdet, clen, cdet, det);
        return det[detlen - 1];
    }

    private static double inSphereExact(double xa, double ya, double za, double xb, double yb, double zb, double xc, double yc, double zc, double xd, double yd, double zd, double xe, double ye, double ze) {
        Two t = new Two();
        Geometry.twoDiff(xa, xe, t);
        double aex = t.x;
        double aextail = t.y;
        Geometry.twoDiff(ya, ye, t);
        double aey = t.x;
        double aeytail = t.y;
        Geometry.twoDiff(za, ze, t);
        double aez = t.x;
        double aeztail = t.y;
        Geometry.twoDiff(xb, xe, t);
        double bex = t.x;
        double bextail = t.y;
        Geometry.twoDiff(yb, ye, t);
        double bey = t.x;
        double beytail = t.y;
        Geometry.twoDiff(zb, ze, t);
        double bez = t.x;
        double beztail = t.y;
        Geometry.twoDiff(xc, xe, t);
        double cex = t.x;
        double cextail = t.y;
        Geometry.twoDiff(yc, ye, t);
        double cey = t.x;
        double ceytail = t.y;
        Geometry.twoDiff(zc, ze, t);
        double cez = t.x;
        double ceztail = t.y;
        Geometry.twoDiff(xd, xe, t);
        double dex = t.x;
        double dextail = t.y;
        Geometry.twoDiff(yd, ye, t);
        double dey = t.x;
        double deytail = t.y;
        Geometry.twoDiff(zd, ze, t);
        double dez = t.x;
        double deztail = t.y;
        double[] axby = new double[8];
        double[] bxay = new double[8];
        double[] ab = new double[16];
        Geometry.twoTwoProduct(aex, aextail, bey, beytail, axby);
        double negate = -aey;
        double negatetail = -aeytail;
        Geometry.twoTwoProduct(bex, bextail, negate, negatetail, bxay);
        int ablen = Geometry.expansionSumZeroElimFast(8, axby, 8, bxay, ab);
        double[] bxcy = new double[8];
        double[] cxby = new double[8];
        double[] bc = new double[16];
        Geometry.twoTwoProduct(bex, bextail, cey, ceytail, bxcy);
        negate = -bey;
        negatetail = -beytail;
        Geometry.twoTwoProduct(cex, cextail, negate, negatetail, cxby);
        int bclen = Geometry.expansionSumZeroElimFast(8, bxcy, 8, cxby, bc);
        double[] cxdy = new double[8];
        double[] dxcy = new double[8];
        double[] cd = new double[16];
        Geometry.twoTwoProduct(cex, cextail, dey, deytail, cxdy);
        negate = -cey;
        negatetail = -ceytail;
        Geometry.twoTwoProduct(dex, dextail, negate, negatetail, dxcy);
        int cdlen = Geometry.expansionSumZeroElimFast(8, cxdy, 8, dxcy, cd);
        double[] dxay = new double[8];
        double[] axdy = new double[8];
        double[] da = new double[16];
        Geometry.twoTwoProduct(dex, dextail, aey, aeytail, dxay);
        negate = -dey;
        negatetail = -deytail;
        Geometry.twoTwoProduct(aex, aextail, negate, negatetail, axdy);
        int dalen = Geometry.expansionSumZeroElimFast(8, dxay, 8, axdy, da);
        double[] axcy = new double[8];
        double[] cxay = new double[8];
        double[] ac = new double[16];
        Geometry.twoTwoProduct(aex, aextail, cey, ceytail, axcy);
        negate = -aey;
        negatetail = -aeytail;
        Geometry.twoTwoProduct(cex, cextail, negate, negatetail, cxay);
        int aclen = Geometry.expansionSumZeroElimFast(8, axcy, 8, cxay, ac);
        double[] bxdy = new double[8];
        double[] dxby = new double[8];
        double[] bd = new double[16];
        Geometry.twoTwoProduct(bex, bextail, dey, deytail, bxdy);
        negate = -bey;
        negatetail = -beytail;
        Geometry.twoTwoProduct(dex, dextail, negate, negatetail, dxby);
        int bdlen = Geometry.expansionSumZeroElimFast(8, bxdy, 8, dxby, bd);
        double[] t32a = new double[32];
        double[] t32b = new double[32];
        double[] t64a = new double[64];
        double[] t64b = new double[64];
        double[] t64c = new double[64];
        double[] t128 = new double[128];
        double[] t192 = new double[192];
        int t32alen = Geometry.scaleExpansionZeroElim(cdlen, cd, -bez, t32a);
        int t32blen = Geometry.scaleExpansionZeroElim(cdlen, cd, -beztail, t32b);
        int t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(bdlen, bd, cez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bdlen, bd, ceztail, t32b);
        int t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(bclen, bc, -dez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bclen, bc, -deztail, t32b);
        int t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        int t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        int t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        double[] detx = new double[384];
        double[] detxx = new double[768];
        double[] detxt = new double[384];
        double[] detxxt = new double[768];
        double[] detxtxt = new double[768];
        double[] x1 = new double[1536];
        double[] x2 = new double[2304];
        int xlen = Geometry.scaleExpansionZeroElim(t192len, t192, aex, detx);
        int xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, aex, detxx);
        int xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, aextail, detxt);
        int xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, aex, detxxt);
        int i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        int xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, aextail, detxtxt);
        int x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        int x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        double[] dety = new double[384];
        double[] detyy = new double[768];
        double[] detyt = new double[384];
        double[] detyyt = new double[768];
        double[] detytyt = new double[768];
        double[] y1 = new double[1536];
        double[] y2 = new double[2304];
        int ylen = Geometry.scaleExpansionZeroElim(t192len, t192, aey, dety);
        int yylen = Geometry.scaleExpansionZeroElim(ylen, dety, aey, detyy);
        int ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, aeytail, detyt);
        int yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, aey, detyyt);
        int i2 = 0;
        while (i2 < yytlen) {
            int n = i2++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        int ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, aeytail, detytyt);
        int y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        int y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        double[] detz = new double[384];
        double[] detzz = new double[768];
        double[] detzt = new double[384];
        double[] detzzt = new double[768];
        double[] detztzt = new double[768];
        double[] z1 = new double[1536];
        double[] z2 = new double[2304];
        int zlen = Geometry.scaleExpansionZeroElim(t192len, t192, aez, detz);
        int zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, aez, detzz);
        int ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, aeztail, detzt);
        int zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, aez, detzzt);
        int i3 = 0;
        while (i3 < zztlen) {
            int n = i3++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        int ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, aeztail, detztzt);
        int z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        int z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        double[] detxy = new double[4608];
        double[] adet = new double[6912];
        double[] bdet = new double[6912];
        double[] cdet = new double[6912];
        double[] ddet = new double[6912];
        int xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        int alen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, adet);
        t32alen = Geometry.scaleExpansionZeroElim(dalen, da, cez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(dalen, da, ceztail, t32b);
        t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(aclen, ac, dez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(aclen, ac, deztail, t32b);
        t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(cdlen, cd, aez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(cdlen, cd, aeztail, t32b);
        t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        xlen = Geometry.scaleExpansionZeroElim(t192len, t192, bex, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, bex, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, bextail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, bex, detxxt);
        int i4 = 0;
        while (i4 < xxtlen) {
            int n = i4++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, bextail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t192len, t192, bey, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, bey, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, beytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, bey, detyyt);
        i4 = 0;
        while (i4 < yytlen) {
            int n = i4++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, beytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        zlen = Geometry.scaleExpansionZeroElim(t192len, t192, bez, detz);
        zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, bez, detzz);
        ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, beztail, detzt);
        zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, bez, detzzt);
        i4 = 0;
        while (i4 < zztlen) {
            int n = i4++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, beztail, detztzt);
        z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        int blen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, bdet);
        t32alen = Geometry.scaleExpansionZeroElim(ablen, ab, -dez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(ablen, ab, -deztail, t32b);
        t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(bdlen, bd, -aez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bdlen, bd, -aeztail, t32b);
        t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(dalen, da, -bez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(dalen, da, -beztail, t32b);
        t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        xlen = Geometry.scaleExpansionZeroElim(t192len, t192, cex, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, cex, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, cextail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, cex, detxxt);
        int i5 = 0;
        while (i5 < xxtlen) {
            int n = i5++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, cextail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t192len, t192, cey, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, cey, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, ceytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, cey, detyyt);
        i5 = 0;
        while (i5 < yytlen) {
            int n = i5++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, ceytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        zlen = Geometry.scaleExpansionZeroElim(t192len, t192, cez, detz);
        zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, cez, detzz);
        ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, ceztail, detzt);
        zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, cez, detzzt);
        i5 = 0;
        while (i5 < zztlen) {
            int n = i5++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, ceztail, detztzt);
        z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        int clen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, cdet);
        t32alen = Geometry.scaleExpansionZeroElim(bclen, bc, aez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bclen, bc, aeztail, t32b);
        t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(aclen, ac, -bez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(aclen, ac, -beztail, t32b);
        t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(ablen, ab, cez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(ablen, ab, ceztail, t32b);
        t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        xlen = Geometry.scaleExpansionZeroElim(t192len, t192, dex, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, dex, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, dextail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, dex, detxxt);
        int i6 = 0;
        while (i6 < xxtlen) {
            int n = i6++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, dextail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t192len, t192, dey, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, dey, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, deytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, dey, detyyt);
        i6 = 0;
        while (i6 < yytlen) {
            int n = i6++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, deytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        zlen = Geometry.scaleExpansionZeroElim(t192len, t192, dez, detz);
        zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, dez, detzz);
        ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, deztail, detzt);
        zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, dez, detzzt);
        i6 = 0;
        while (i6 < zztlen) {
            int n = i6++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, deztail, detztzt);
        z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        int dlen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, ddet);
        double[] abdet = new double[13824];
        double[] cddet = new double[13824];
        double[] det = new double[27648];
        ablen = Geometry.expansionSumZeroElimFast(alen, adet, blen, bdet, abdet);
        cdlen = Geometry.expansionSumZeroElimFast(clen, cdet, dlen, ddet, cddet);
        int detlen = Geometry.expansionSumZeroElimFast(ablen, abdet, cdlen, cddet, det);
        return det[detlen - 1];
    }

    private static double inOrthoSphereExact(double xa, double ya, double za, double wa, double xb, double yb, double zb, double wb, double xc, double yc, double zc, double wc, double xd, double yd, double zd, double wd, double xe, double ye, double ze, double we) {
        Two t = new Two();
        Geometry.twoDiff(xa, xe, t);
        double aex = t.x;
        double aextail = t.y;
        Geometry.twoDiff(ya, ye, t);
        double aey = t.x;
        double aeytail = t.y;
        Geometry.twoDiff(za, ze, t);
        double aez = t.x;
        double aeztail = t.y;
        Geometry.twoDiff(wa, we, t);
        Geometry.twoDiff(xb, xe, t);
        double bex = t.x;
        double bextail = t.y;
        Geometry.twoDiff(yb, ye, t);
        double bey = t.x;
        double beytail = t.y;
        Geometry.twoDiff(zb, ze, t);
        double bez = t.x;
        double beztail = t.y;
        Geometry.twoDiff(wb, we, t);
        double bew = t.x;
        double bewtail = t.y;
        Geometry.twoDiff(xc, xe, t);
        double cex = t.x;
        double cextail = t.y;
        Geometry.twoDiff(yc, ye, t);
        double cey = t.x;
        double ceytail = t.y;
        Geometry.twoDiff(zc, ze, t);
        double cez = t.x;
        double ceztail = t.y;
        Geometry.twoDiff(wc, we, t);
        double cew = t.x;
        double cewtail = t.y;
        Geometry.twoDiff(xd, xe, t);
        double dex = t.x;
        double dextail = t.y;
        Geometry.twoDiff(yd, ye, t);
        double dey = t.x;
        double deytail = t.y;
        Geometry.twoDiff(zd, ze, t);
        double dez = t.x;
        double deztail = t.y;
        Geometry.twoDiff(wd, we, t);
        double dew = t.x;
        double dewtail = t.y;
        double[] axby = new double[8];
        double[] bxay = new double[8];
        double[] ab = new double[16];
        Geometry.twoTwoProduct(aex, aextail, bey, beytail, axby);
        double negate = -aey;
        double negatetail = -aeytail;
        Geometry.twoTwoProduct(bex, bextail, negate, negatetail, bxay);
        int ablen = Geometry.expansionSumZeroElimFast(8, axby, 8, bxay, ab);
        double[] bxcy = new double[8];
        double[] cxby = new double[8];
        double[] bc = new double[16];
        Geometry.twoTwoProduct(bex, bextail, cey, ceytail, bxcy);
        negate = -bey;
        negatetail = -beytail;
        Geometry.twoTwoProduct(cex, cextail, negate, negatetail, cxby);
        int bclen = Geometry.expansionSumZeroElimFast(8, bxcy, 8, cxby, bc);
        double[] cxdy = new double[8];
        double[] dxcy = new double[8];
        double[] cd = new double[16];
        Geometry.twoTwoProduct(cex, cextail, dey, deytail, cxdy);
        negate = -cey;
        negatetail = -ceytail;
        Geometry.twoTwoProduct(dex, dextail, negate, negatetail, dxcy);
        int cdlen = Geometry.expansionSumZeroElimFast(8, cxdy, 8, dxcy, cd);
        double[] dxay = new double[8];
        double[] axdy = new double[8];
        double[] da = new double[16];
        Geometry.twoTwoProduct(dex, dextail, aey, aeytail, dxay);
        negate = -dey;
        negatetail = -deytail;
        Geometry.twoTwoProduct(aex, aextail, negate, negatetail, axdy);
        int dalen = Geometry.expansionSumZeroElimFast(8, dxay, 8, axdy, da);
        double[] axcy = new double[8];
        double[] cxay = new double[8];
        double[] ac = new double[16];
        Geometry.twoTwoProduct(aex, aextail, cey, ceytail, axcy);
        negate = -aey;
        negatetail = -aeytail;
        Geometry.twoTwoProduct(cex, cextail, negate, negatetail, cxay);
        int aclen = Geometry.expansionSumZeroElimFast(8, axcy, 8, cxay, ac);
        double[] bxdy = new double[8];
        double[] dxby = new double[8];
        double[] bd = new double[16];
        Geometry.twoTwoProduct(bex, bextail, dey, deytail, bxdy);
        negate = -bey;
        negatetail = -beytail;
        Geometry.twoTwoProduct(dex, dextail, negate, negatetail, dxby);
        int bdlen = Geometry.expansionSumZeroElimFast(8, bxdy, 8, dxby, bd);
        double[] t32a = new double[32];
        double[] t32b = new double[32];
        double[] t64a = new double[64];
        double[] t64b = new double[64];
        double[] t64c = new double[64];
        double[] t128 = new double[128];
        double[] t192 = new double[192];
        int t32alen = Geometry.scaleExpansionZeroElim(cdlen, cd, -bez, t32a);
        int t32blen = Geometry.scaleExpansionZeroElim(cdlen, cd, -beztail, t32b);
        int t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(bdlen, bd, cez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bdlen, bd, ceztail, t32b);
        int t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(bclen, bc, -dez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bclen, bc, -deztail, t32b);
        int t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        int t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        int t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        double[] detx = new double[384];
        double[] detxx = new double[768];
        double[] detxt = new double[384];
        double[] detxxt = new double[768];
        double[] detxtxt = new double[768];
        double[] x1 = new double[1536];
        double[] x2 = new double[2304];
        int xlen = Geometry.scaleExpansionZeroElim(t192len, t192, aex, detx);
        int xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, aex, detxx);
        int xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, aextail, detxt);
        int xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, aex, detxxt);
        int i = 0;
        while (i < xxtlen) {
            int n = i++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        int xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, aextail, detxtxt);
        int x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        int x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        double[] dety = new double[384];
        double[] detyy = new double[768];
        double[] detyt = new double[384];
        double[] detyyt = new double[768];
        double[] detytyt = new double[768];
        double[] y1 = new double[1536];
        double[] y2 = new double[2304];
        int ylen = Geometry.scaleExpansionZeroElim(t192len, t192, aey, dety);
        int yylen = Geometry.scaleExpansionZeroElim(ylen, dety, aey, detyy);
        int ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, aeytail, detyt);
        int yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, aey, detyyt);
        int i2 = 0;
        while (i2 < yytlen) {
            int n = i2++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        int ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, aeytail, detytyt);
        int y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        int y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        double[] detz = new double[384];
        double[] detzz = new double[768];
        double[] detzt = new double[384];
        double[] detzzt = new double[768];
        double[] detztzt = new double[768];
        double[] z1 = new double[1536];
        double[] z2 = new double[2304];
        int zlen = Geometry.scaleExpansionZeroElim(t192len, t192, aez, detz);
        int zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, aez, detzz);
        int ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, aeztail, detzt);
        int zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, aez, detzzt);
        int i3 = 0;
        while (i3 < zztlen) {
            int n = i3++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        int ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, aeztail, detztzt);
        int z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        int z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        double[] detw = new double[384];
        double[] detwt = new double[384];
        double[] w2 = new double[768];
        int wlen = Geometry.scaleExpansionZeroElim(t192len, t192, -bew, detw);
        int wtlen = Geometry.scaleExpansionZeroElim(t192len, t192, -bewtail, detwt);
        int w2len = Geometry.expansionSumZeroElimFast(wlen, detw, wtlen, detwt, w2);
        double[] detxy = new double[4608];
        double[] detxyz = new double[6912];
        double[] adet = new double[7680];
        int xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        int xyzlen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, detxyz);
        int alen = Geometry.expansionSumZeroElimFast(w2len, w2, xyzlen, detxyz, adet);
        t32alen = Geometry.scaleExpansionZeroElim(dalen, da, cez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(dalen, da, ceztail, t32b);
        t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(aclen, ac, dez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(aclen, ac, deztail, t32b);
        t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(cdlen, cd, aez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(cdlen, cd, aeztail, t32b);
        t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        xlen = Geometry.scaleExpansionZeroElim(t192len, t192, bex, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, bex, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, bextail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, bex, detxxt);
        int i4 = 0;
        while (i4 < xxtlen) {
            int n = i4++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, bextail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t192len, t192, bey, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, bey, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, beytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, bey, detyyt);
        i4 = 0;
        while (i4 < yytlen) {
            int n = i4++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, beytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        zlen = Geometry.scaleExpansionZeroElim(t192len, t192, bez, detz);
        zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, bez, detzz);
        ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, beztail, detzt);
        zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, bez, detzzt);
        i4 = 0;
        while (i4 < zztlen) {
            int n = i4++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, beztail, detztzt);
        z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        wlen = Geometry.scaleExpansionZeroElim(t192len, t192, -bew, detw);
        wtlen = Geometry.scaleExpansionZeroElim(t192len, t192, -bewtail, detwt);
        w2len = Geometry.expansionSumZeroElimFast(wlen, detw, wtlen, detwt, w2);
        xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        xyzlen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, detxyz);
        double[] bdet = new double[7680];
        int blen = Geometry.expansionSumZeroElimFast(w2len, w2, xyzlen, detxyz, bdet);
        t32alen = Geometry.scaleExpansionZeroElim(ablen, ab, -dez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(ablen, ab, -deztail, t32b);
        t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(bdlen, bd, -aez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bdlen, bd, -aeztail, t32b);
        t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(dalen, da, -bez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(dalen, da, -beztail, t32b);
        t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        xlen = Geometry.scaleExpansionZeroElim(t192len, t192, cex, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, cex, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, cextail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, cex, detxxt);
        int i5 = 0;
        while (i5 < xxtlen) {
            int n = i5++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, cextail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t192len, t192, cey, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, cey, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, ceytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, cey, detyyt);
        i5 = 0;
        while (i5 < yytlen) {
            int n = i5++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, ceytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        zlen = Geometry.scaleExpansionZeroElim(t192len, t192, cez, detz);
        zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, cez, detzz);
        ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, ceztail, detzt);
        zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, cez, detzzt);
        i5 = 0;
        while (i5 < zztlen) {
            int n = i5++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, ceztail, detztzt);
        z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        wlen = Geometry.scaleExpansionZeroElim(t192len, t192, -cew, detw);
        wtlen = Geometry.scaleExpansionZeroElim(t192len, t192, -cewtail, detwt);
        w2len = Geometry.expansionSumZeroElimFast(wlen, detw, wtlen, detwt, w2);
        xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        xyzlen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, detxyz);
        double[] cdet = new double[7680];
        int clen = Geometry.expansionSumZeroElimFast(w2len, w2, xyzlen, detxyz, cdet);
        t32alen = Geometry.scaleExpansionZeroElim(bclen, bc, aez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(bclen, bc, aeztail, t32b);
        t64alen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64a);
        t32alen = Geometry.scaleExpansionZeroElim(aclen, ac, -bez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(aclen, ac, -beztail, t32b);
        t64blen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64b);
        t32alen = Geometry.scaleExpansionZeroElim(ablen, ab, cez, t32a);
        t32blen = Geometry.scaleExpansionZeroElim(ablen, ab, ceztail, t32b);
        t64clen = Geometry.expansionSumZeroElimFast(t32alen, t32a, t32blen, t32b, t64c);
        t128len = Geometry.expansionSumZeroElimFast(t64alen, t64a, t64blen, t64b, t128);
        t192len = Geometry.expansionSumZeroElimFast(t64clen, t64c, t128len, t128, t192);
        xlen = Geometry.scaleExpansionZeroElim(t192len, t192, dex, detx);
        xxlen = Geometry.scaleExpansionZeroElim(xlen, detx, dex, detxx);
        xtlen = Geometry.scaleExpansionZeroElim(t192len, t192, dextail, detxt);
        xxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, dex, detxxt);
        int i6 = 0;
        while (i6 < xxtlen) {
            int n = i6++;
            detxxt[n] = detxxt[n] * 2.0;
        }
        xtxtlen = Geometry.scaleExpansionZeroElim(xtlen, detxt, dextail, detxtxt);
        x1len = Geometry.expansionSumZeroElimFast(xxlen, detxx, xxtlen, detxxt, x1);
        x2len = Geometry.expansionSumZeroElimFast(x1len, x1, xtxtlen, detxtxt, x2);
        ylen = Geometry.scaleExpansionZeroElim(t192len, t192, dey, dety);
        yylen = Geometry.scaleExpansionZeroElim(ylen, dety, dey, detyy);
        ytlen = Geometry.scaleExpansionZeroElim(t192len, t192, deytail, detyt);
        yytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, dey, detyyt);
        i6 = 0;
        while (i6 < yytlen) {
            int n = i6++;
            detyyt[n] = detyyt[n] * 2.0;
        }
        ytytlen = Geometry.scaleExpansionZeroElim(ytlen, detyt, deytail, detytyt);
        y1len = Geometry.expansionSumZeroElimFast(yylen, detyy, yytlen, detyyt, y1);
        y2len = Geometry.expansionSumZeroElimFast(y1len, y1, ytytlen, detytyt, y2);
        zlen = Geometry.scaleExpansionZeroElim(t192len, t192, dez, detz);
        zzlen = Geometry.scaleExpansionZeroElim(zlen, detz, dez, detzz);
        ztlen = Geometry.scaleExpansionZeroElim(t192len, t192, deztail, detzt);
        zztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, dez, detzzt);
        i6 = 0;
        while (i6 < zztlen) {
            int n = i6++;
            detzzt[n] = detzzt[n] * 2.0;
        }
        ztztlen = Geometry.scaleExpansionZeroElim(ztlen, detzt, deztail, detztzt);
        z1len = Geometry.expansionSumZeroElimFast(zzlen, detzz, zztlen, detzzt, z1);
        z2len = Geometry.expansionSumZeroElimFast(z1len, z1, ztztlen, detztzt, z2);
        wlen = Geometry.scaleExpansionZeroElim(t192len, t192, -dew, detw);
        wtlen = Geometry.scaleExpansionZeroElim(t192len, t192, -dewtail, detwt);
        w2len = Geometry.expansionSumZeroElimFast(wlen, detw, wtlen, detwt, w2);
        xylen = Geometry.expansionSumZeroElimFast(x2len, x2, y2len, y2, detxy);
        xyzlen = Geometry.expansionSumZeroElimFast(z2len, z2, xylen, detxy, detxyz);
        double[] ddet = new double[7680];
        int dlen = Geometry.expansionSumZeroElimFast(w2len, w2, xyzlen, detxyz, ddet);
        double[] abdet = new double[15360];
        double[] cddet = new double[15360];
        double[] det = new double[30720];
        ablen = Geometry.expansionSumZeroElimFast(alen, adet, blen, bdet, abdet);
        cdlen = Geometry.expansionSumZeroElimFast(clen, cdet, dlen, ddet, cddet);
        int detlen = Geometry.expansionSumZeroElimFast(ablen, abdet, cdlen, cddet, det);
        return det[detlen - 1];
    }

    static {
        double epsilon = 1.0;
        double splitter = 1.0;
        boolean everyOther = true;
        do {
            epsilon *= 0.5;
            if (everyOther) {
                splitter *= 2.0;
            }
            boolean bl = everyOther = !everyOther;
        } while (1.0 + epsilon != 1.0);
        EPSILON = epsilon;
        SPLITTER = splitter += 1.0;
        O2DERRBOUND = 4.0 * EPSILON;
        O3DERRBOUND = 8.0 * EPSILON;
        INCERRBOUND = 11.0 * EPSILON;
        INSERRBOUND = 17.0 * EPSILON;
        IOSERRBOUND = 19.0 * EPSILON;
    }

    private static class Two {
        double x;
        double y;

        private Two() {
        }
    }
}

