/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mesh;

import edu.mines.jtk.mesh.TriMesh;
import edu.mines.jtk.mosaic.Projector;
import edu.mines.jtk.mosaic.TiledView;
import edu.mines.jtk.mosaic.Transcaler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Map;

public class TriMeshView
extends TiledView {
    private TriMesh _mesh;
    private float _xmin;
    private float _xmax;
    private float _ymin;
    private float _ymax;
    private Color _markColor = Color.red;
    private double _markWidth = 6.0;
    private Color _triLineColor = Color.yellow;
    private Color _polyLineColor = Color.yellow;
    private double _lineWidth = 0.0;
    private boolean _drawNodes = true;
    private boolean _drawTris = true;
    private boolean _drawPolys = false;
    private boolean _drawSubTris = false;
    private boolean _drawTriBounds = false;
    private boolean _drawPolyBounds = false;
    private TriPainter _triPainter = null;
    private Map<TriMesh.Edge, Float> _triEdgeWeights = null;
    private Map<TriMesh.Edge, Color> _triEdgeColors = null;
    private Orientation _orientation = Orientation.XRIGHT_YUP;

    public TriMeshView(TriMesh mesh) {
        this.setMesh(mesh);
    }

    public void setMesh(TriMesh mesh) {
        this._mesh = mesh;
        this.updateMinMax();
        this.updateBestProjectors();
        this.repaint();
    }

    public void setOrientation(Orientation orientation) {
        if (this._orientation != orientation) {
            this._orientation = orientation;
            this.updateBestProjectors();
            this.repaint();
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setNodesVisible(boolean drawNodes) {
        if (this._drawNodes != drawNodes) {
            this._drawNodes = drawNodes;
            this.repaint();
        }
    }

    public void setTrisVisible(boolean drawTris) {
        if (this._drawTris != drawTris) {
            this._drawTris = drawTris;
            this.repaint();
        }
    }

    public void setSubTrisVisible(boolean drawSubTris) {
        if (this._drawSubTris != drawSubTris) {
            this._drawSubTris = drawSubTris;
            this.repaint();
        }
    }

    public void setPolysVisible(boolean drawPolys) {
        if (this._drawPolys != drawPolys) {
            this._drawPolys = drawPolys;
            this.repaint();
        }
    }

    public void setTriBoundsVisible(boolean drawTriBounds) {
        if (this._drawTriBounds != drawTriBounds) {
            this._drawTriBounds = drawTriBounds;
            this.repaint();
        }
    }

    public void setPolyBoundsVisible(boolean drawPolyBounds) {
        if (this._drawPolyBounds != drawPolyBounds) {
            this._drawPolyBounds = drawPolyBounds;
            this.repaint();
        }
    }

    public void showNodes() {
        this.setNodesVisible(true);
    }

    public void hideNodes() {
        this.setNodesVisible(false);
    }

    public void showTris() {
        this.setTrisVisible(true);
    }

    public void hideTris() {
        this.setTrisVisible(false);
    }

    public void showPolys() {
        this.setPolysVisible(true);
    }

    public void hidePolys() {
        this.setPolysVisible(false);
    }

    public void showTriBounds() {
        this.setTriBoundsVisible(true);
    }

    public void hideTriBounds() {
        this.setTriBoundsVisible(false);
    }

    public void showPolyBounds() {
        this.setPolyBoundsVisible(true);
    }

    public void hidePolyBounds() {
        this.setPolyBoundsVisible(false);
    }

    public void setLineColor(Color lineColor) {
        this._triLineColor = lineColor;
        this._polyLineColor = lineColor;
        this.repaint();
    }

    public void setTriColor(Color lineColor) {
        this._triLineColor = lineColor;
        this.repaint();
    }

    public void setTriEdgeWeights(Map<TriMesh.Edge, Float> triEdgeWeights) {
        this._triEdgeWeights = triEdgeWeights;
        this._triEdgeColors = null;
        this.repaint();
    }

    public void setPolyColor(Color lineColor) {
        this._polyLineColor = lineColor;
        this.repaint();
    }

    public void setLineWidth(int lineWidth) {
        this._lineWidth = lineWidth;
        this.updateBestProjectors();
        this.repaint();
    }

    public void setMarkColor(Color markColor) {
        this._markColor = markColor;
        this.repaint();
    }

    public void setMarkWidth(int markWidth) {
        this._markWidth = markWidth;
        this.updateBestProjectors();
        this.repaint();
    }

    public void setTriPainter(TriPainter triPainter) {
        this._triPainter = triPainter;
    }

    @Override
    public void paint(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Transcaler ts = this.getTranscaler();
        Projector px = this.getHorizontalProjector();
        double xv0 = px.v0();
        double xv1 = px.v1();
        double xu0 = px.u(xv0);
        double xu1 = px.u(xv1);
        double xd0 = ts.x(xu0);
        double xd1 = ts.x(xu1);
        double xscale = (xd1 - xd0) / (xv1 - xv0);
        double xshift = 0.5 + xd0 - xv0 * xscale;
        Projector py = this.getVerticalProjector();
        double yv0 = py.v0();
        double yv1 = py.v1();
        double yu0 = py.u(yv0);
        double yu1 = py.u(yv1);
        double yd0 = ts.y(yu0);
        double yd1 = ts.y(yu1);
        double yscale = (yd1 - yd0) / (yv1 - yv0);
        double yshift = 0.5 + yd0 - yv0 * yscale;
        if (this._drawTris || this._drawPolys || this._drawTriBounds || this._drawPolyBounds) {
            Stroke defaultStroke = g2d.getStroke();
            BasicStroke stroke = null;
            GeneralPath path = null;
            if (this._lineWidth > 1.0) {
                stroke = new BasicStroke((float)this._lineWidth);
                path = new GeneralPath();
            }
            if (stroke != null) {
                g2d.setStroke(stroke);
            }
            if (this._drawTris || this._drawTriBounds) {
                if (this._triEdgeWeights != null && this._triEdgeColors == null) {
                    this._triEdgeColors = TriMeshView.convertEdgeWeightsToColors(this._triEdgeWeights);
                }
                boolean haveEdgeColors = this._triEdgeColors != null;
                TriMesh.NodePropertyMap colorMap = null;
                if (this._mesh.hasNodePropertyMap("Color")) {
                    colorMap = this._mesh.getNodePropertyMap("Color");
                }
                g2d.setColor(this._triLineColor);
                TriMesh.TriIterator ti = this._mesh.getTris();
                while (ti.hasNext()) {
                    TriMesh.Tri tri = ti.next();
                    if (this._mesh.isOuter(tri)) continue;
                    TriMesh.Node na = tri.nodeA();
                    TriMesh.Node nb = tri.nodeB();
                    TriMesh.Node nc = tri.nodeC();
                    Color ca = Color.WHITE;
                    Color cb = Color.WHITE;
                    Color cc = Color.WHITE;
                    if (colorMap != null) {
                        ca = (Color)colorMap.get(na);
                        cb = (Color)colorMap.get(nb);
                        cc = (Color)colorMap.get(nc);
                    }
                    Color cab = null;
                    Color cbc = null;
                    Color cca = null;
                    if (this._drawTris && haveEdgeColors) {
                        cab = this._triEdgeColors.get(this._mesh.findEdge(na, nb));
                        cbc = this._triEdgeColors.get(this._mesh.findEdge(nb, nc));
                        cca = this._triEdgeColors.get(this._mesh.findEdge(nc, na));
                        if (cab == null) {
                            cab = this._triLineColor;
                        }
                        if (cbc == null) {
                            cbc = this._triLineColor;
                        }
                        if (cca == null) {
                            cca = this._triLineColor;
                        }
                    }
                    double xaa = xshift + (double)this.x(na) * xscale;
                    double yaa = yshift + (double)this.y(na) * yscale;
                    double xbb = xshift + (double)this.x(nb) * xscale;
                    double ybb = yshift + (double)this.y(nb) * yscale;
                    double xcc = xshift + (double)this.x(nc) * xscale;
                    double ycc = yshift + (double)this.y(nc) * yscale;
                    int xa = (int)xaa;
                    int ya = (int)yaa;
                    int xb = (int)xbb;
                    int yb = (int)ybb;
                    int xc = (int)xcc;
                    int yc = (int)ycc;
                    int xd = 0;
                    int yd = 0;
                    int xe = 0;
                    int ye = 0;
                    int xf = 0;
                    int yf = 0;
                    int xg = 0;
                    int yg = 0;
                    if (this._drawSubTris || this._drawTriBounds) {
                        double xab = 0.5 * (xaa + xbb);
                        double yab = 0.5 * (yaa + ybb);
                        double xbc = 0.5 * (xbb + xcc);
                        double ybc = 0.5 * (ybb + ycc);
                        double xca = 0.5 * (xcc + xaa);
                        double yca = 0.5 * (ycc + yaa);
                        double xabc = 0.333 * (xaa + xbb + xcc);
                        double yabc = 0.333 * (yaa + ybb + ycc);
                        xd = (int)xab;
                        yd = (int)yab;
                        xe = (int)xbc;
                        ye = (int)ybc;
                        xf = (int)xca;
                        yf = (int)yca;
                        xg = (int)xabc;
                        yg = (int)yabc;
                    }
                    if (this._drawTris) {
                        if (this._triPainter != null) {
                            this._triPainter.paint(g2d, tri, na, xa, ya, nb, xb, yb, nc, xc, yc);
                        }
                        if (path == null) {
                            if (haveEdgeColors) {
                                if (cab != null) {
                                    g2d.setColor(cab);
                                }
                                g2d.drawLine(xa, ya, xb, yb);
                                if (cbc != null) {
                                    g2d.setColor(cbc);
                                }
                                g2d.drawLine(xb, yb, xc, yc);
                                if (cca != null) {
                                    g2d.setColor(cca);
                                }
                                g2d.drawLine(xc, yc, xa, ya);
                                g2d.setColor(this._triLineColor);
                            } else {
                                g2d.drawLine(xa, ya, xb, yb);
                                g2d.drawLine(xb, yb, xc, yc);
                                g2d.drawLine(xc, yc, xa, ya);
                            }
                            if (this._drawSubTris) {
                                g2d.drawLine(xd, yd, xe, ye);
                                g2d.drawLine(xe, ye, xf, yf);
                                g2d.drawLine(xf, yf, xd, yd);
                            }
                        } else {
                            if (haveEdgeColors) {
                                GeneralPath gp = new GeneralPath();
                                g2d.setColor(cab);
                                gp.moveTo(xa, ya);
                                gp.lineTo(xb, yb);
                                g2d.draw(gp);
                                gp.reset();
                                g2d.setColor(cbc);
                                gp.moveTo(xb, yb);
                                gp.lineTo(xc, yc);
                                g2d.draw(gp);
                                gp.reset();
                                g2d.setColor(cbc);
                                gp.moveTo(xc, yc);
                                gp.lineTo(xa, ya);
                                g2d.draw(gp);
                                gp.reset();
                            } else {
                                path.moveTo(xa, ya);
                                path.lineTo(xb, yb);
                                path.lineTo(xc, yc);
                                path.lineTo(xa, ya);
                            }
                            if (this._drawSubTris) {
                                path.moveTo(xd, yd);
                                path.lineTo(xe, ye);
                                path.lineTo(xf, yf);
                                path.lineTo(xd, yd);
                            }
                        }
                    }
                    if (!this._drawTriBounds) continue;
                    if (!(ca.equals(cb) || cb.equals(cc) || cc.equals(ca))) {
                        TriMeshView.drawLine(g2d, path, xd, yd, xg, yg);
                        TriMeshView.drawLine(g2d, path, xe, ye, xg, yg);
                        TriMeshView.drawLine(g2d, path, xf, yf, xg, yg);
                        continue;
                    }
                    if (ca.equals(cb) && !cb.equals(cc)) {
                        TriMeshView.drawLine(g2d, path, xe, ye, xf, yf);
                        continue;
                    }
                    if (cb.equals(cc) && !cc.equals(ca)) {
                        TriMeshView.drawLine(g2d, path, xd, yd, xf, yf);
                        continue;
                    }
                    if (!cc.equals(ca) || ca.equals(cb)) continue;
                    TriMeshView.drawLine(g2d, path, xd, yd, xe, ye);
                }
            }
            if (this._drawPolys || this._drawPolyBounds) {
                TriMesh.NodePropertyMap colorMap = null;
                if (this._mesh.hasNodePropertyMap("Color")) {
                    colorMap = this._mesh.getNodePropertyMap("Color");
                }
                g2d.setColor(this._polyLineColor);
                float[] pa = new float[2];
                float[] pb = new float[2];
                float[] pc = new float[2];
                float[] pn = new float[2];
                float[] qc = new float[2];
                TriMesh.TriIterator ti = this._mesh.getTris();
                while (ti.hasNext()) {
                    int y2;
                    int x2;
                    float yc;
                    int x22;
                    TriMesh.Tri tri = ti.next();
                    if (this._mesh.isOuter(tri)) continue;
                    TriMesh.Node na = tri.nodeA();
                    TriMesh.Node nb = tri.nodeB();
                    TriMesh.Node nc = tri.nodeC();
                    Color ca = Color.WHITE;
                    Color cb = Color.WHITE;
                    Color cc = Color.WHITE;
                    if (colorMap != null) {
                        ca = (Color)colorMap.get(na);
                        cb = (Color)colorMap.get(nb);
                        cc = (Color)colorMap.get(nc);
                    }
                    pa[0] = this.x(na);
                    pa[1] = this.y(na);
                    pb[0] = this.x(nb);
                    pb[1] = this.y(nb);
                    pc[0] = this.x(nc);
                    pc[1] = this.y(nc);
                    this.circumcenter(pa, pb, pc, qc);
                    int x1 = (int)(xshift + (double)qc[0] * xscale);
                    int y1 = (int)(yshift + (double)qc[1] * yscale);
                    if (this._drawPolys || !cb.equals(cc)) {
                        TriMesh.Tri ta = tri.triNabor(na);
                        if (ta != null && this._mesh.isInner(ta)) {
                            TriMesh.Node nn = tri.nodeNabor(ta);
                            pn[0] = this.x(nn);
                            pn[1] = this.y(nn);
                            this.circumcenter(pn, pc, pb, qc);
                            x22 = (int)(xshift + (double)qc[0] * xscale);
                            int y22 = (int)(yshift + (double)qc[1] * yscale);
                            TriMeshView.drawLine(g2d, path, x1, y1, x22, y22);
                        } else {
                            float xb = pb[0];
                            float yb = pb[1];
                            float xc = pc[0];
                            yc = pc[1];
                            x2 = (int)(xshift + (double)(0.5f * (xb + xc)) * xscale);
                            y2 = (int)(yshift + (double)(0.5f * (yb + yc)) * yscale);
                            TriMeshView.drawLine(g2d, path, x1, y1, x2, y2);
                        }
                    }
                    if (this._drawPolys || !ca.equals(cc)) {
                        TriMesh.Tri tb = tri.triNabor(nb);
                        if (tb != null && this._mesh.isInner(tb)) {
                            TriMesh.Node nn = tri.nodeNabor(tb);
                            pn[0] = this.x(nn);
                            pn[1] = this.y(nn);
                            this.circumcenter(pn, pa, pc, qc);
                            x22 = (int)(xshift + (double)qc[0] * xscale);
                            int y23 = (int)(yshift + (double)qc[1] * yscale);
                            TriMeshView.drawLine(g2d, path, x1, y1, x22, y23);
                        } else {
                            float xa = pa[0];
                            float ya = pa[1];
                            float xc = pc[0];
                            yc = pc[1];
                            x2 = (int)(xshift + (double)(0.5f * (xa + xc)) * xscale);
                            y2 = (int)(yshift + (double)(0.5f * (ya + yc)) * yscale);
                            TriMeshView.drawLine(g2d, path, x1, y1, x2, y2);
                        }
                    }
                    if (!this._drawPolys && ca.equals(cb)) continue;
                    TriMesh.Tri tc = tri.triNabor(nc);
                    if (tc != null && this._mesh.isInner(tc)) {
                        TriMesh.Node nn = tri.nodeNabor(tc);
                        pn[0] = this.x(nn);
                        pn[1] = this.y(nn);
                        this.circumcenter(pn, pb, pa, qc);
                        int x23 = (int)(xshift + (double)qc[0] * xscale);
                        int y24 = (int)(yshift + (double)qc[1] * yscale);
                        TriMeshView.drawLine(g2d, path, x1, y1, x23, y24);
                        continue;
                    }
                    float xa = pa[0];
                    float ya = pa[1];
                    float xb = pb[0];
                    float yb = pb[1];
                    x2 = (int)(xshift + (double)(0.5f * (xa + xb)) * xscale);
                    y2 = (int)(yshift + (double)(0.5f * (ya + yb)) * yscale);
                    TriMeshView.drawLine(g2d, path, x1, y1, x2, y2);
                }
            }
            if (path != null) {
                g2d.draw(path);
            }
            if (stroke != null) {
                g2d.setStroke(defaultStroke);
            }
        }
        if (this._drawNodes) {
            g2d.setColor(this._markColor);
            int halfWidth = (int)(this._markWidth / 2.0 + 0.51);
            int markWidth = 1 + 2 * halfWidth;
            TriMesh.NodePropertyMap colorMap = null;
            if (this._mesh.hasNodePropertyMap("Color")) {
                colorMap = this._mesh.getNodePropertyMap("Color");
            }
            TriMesh.NodeIterator ni = this._mesh.getNodes();
            while (ni.hasNext()) {
                float yn;
                float xn;
                TriMesh.Node node = ni.next();
                if (this._orientation == Orientation.XRIGHT_YUP) {
                    xn = node.x();
                    yn = node.y();
                } else {
                    xn = node.y();
                    yn = node.x();
                }
                int x = (int)(xshift + (double)xn * xscale);
                int y = (int)(yshift + (double)yn * yscale);
                if (colorMap != null) {
                    Color color = (Color)colorMap.get(node);
                    if (color != null) {
                        g2d.setColor((Color)colorMap.get(node));
                        g2d.fillOval(x - halfWidth, y - halfWidth, markWidth, markWidth);
                        continue;
                    }
                    g2d.setColor(Color.white);
                    g2d.drawOval(x - halfWidth, y - halfWidth, markWidth, markWidth);
                    continue;
                }
                g2d.fillOval(x - halfWidth, y - halfWidth, markWidth, markWidth);
            }
        }
    }

    private static void drawLine(Graphics2D g2d, GeneralPath path, int x1, int y1, int x2, int y2) {
        if (path == null) {
            g2d.drawLine(x1, y1, x2, y2);
        } else {
            path.moveTo(x1, y1);
            path.lineTo(x2, y2);
        }
    }

    private float x(TriMesh.Node node) {
        if (this._orientation == Orientation.XRIGHT_YUP) {
            return node.x();
        }
        return node.y();
    }

    private float y(TriMesh.Node node) {
        if (this._orientation == Orientation.XRIGHT_YUP) {
            return node.y();
        }
        return node.x();
    }

    private void updateMinMax() {
        if (this._mesh == null) {
            return;
        }
        this._xmin = Float.MAX_VALUE;
        this._ymin = Float.MAX_VALUE;
        this._xmax = -3.4028235E38f;
        this._ymax = -3.4028235E38f;
        TriMesh.NodeIterator ni = this._mesh.getNodes();
        while (ni.hasNext()) {
            TriMesh.Node node = ni.next();
            float x = node.x();
            float y = node.y();
            if (x < this._xmin) {
                this._xmin = x;
            }
            if (y < this._ymin) {
                this._ymin = y;
            }
            if (x > this._xmax) {
                this._xmax = x;
            }
            if (!(y > this._ymax)) continue;
            this._ymax = y;
        }
    }

    private void updateBestProjectors() {
        double u0 = 0.0;
        double u1 = 1.0;
        if (this._drawNodes && this._markWidth > 1.0 || this._lineWidth > 1.0) {
            u0 = 0.01;
            u1 = 0.99;
        }
        Projector bhp = null;
        Projector bvp = null;
        if (this._orientation == Orientation.XRIGHT_YUP) {
            bhp = this._xmin < this._xmax ? new Projector(this._xmin, this._xmax, u0, u1) : null;
            bvp = this._ymin < this._ymax ? new Projector(this._ymax, this._ymin, u0, u1) : null;
        } else if (this._orientation == Orientation.XDOWN_YRIGHT) {
            bhp = this._ymin < this._ymax ? new Projector(this._ymin, this._ymax, u0, u1) : null;
            bvp = this._xmin < this._xmax ? new Projector(this._xmin, this._xmax, u0, u1) : null;
        }
        this.setBestProjectors(bhp, bvp);
    }

    private void circumcenter(float[] pa, float[] pb, float[] pc, float[] cc) {
        double xa = pa[0];
        double ya = pa[1];
        double xb = pb[0];
        double yb = pb[1];
        double xc = pc[0];
        double yc = pc[1];
        double xba = xb - xa;
        double yba = yb - ya;
        double xca = xc - xa;
        double yca = yc - ya;
        double dba = xba * xba + yba * yba;
        double dca = xca * xca + yca * yca;
        double scl = 0.5 / (xba * yca - yba * xca);
        double xcc = xa + scl * (yca * dba - yba * dca);
        double ycc = ya + scl * (xba * dca - xca * dba);
        cc[0] = (float)xcc;
        cc[1] = (float)ycc;
    }

    private static Map<TriMesh.Edge, Color> convertEdgeWeightsToColors(Map<TriMesh.Edge, Float> edgeWeights) {
        float wmin = Float.MAX_VALUE;
        float wmax = -wmin;
        for (Map.Entry<TriMesh.Edge, Float> entry : edgeWeights.entrySet()) {
            float w = entry.getValue().floatValue();
            if (w < wmin) {
                wmin = w;
            }
            if (!(w > wmax)) continue;
            wmax = w;
        }
        HashMap<TriMesh.Edge, Color> edgeColors = new HashMap<TriMesh.Edge, Color>();
        float hueMin = 0.0f;
        float hueMax = 0.5f;
        for (Map.Entry<TriMesh.Edge, Float> entry : edgeWeights.entrySet()) {
            TriMesh.Edge e = entry.getKey();
            float w = entry.getValue().floatValue();
            float hue = hueMin + (w - wmin) * (hueMax - hueMin) / (wmax - wmin);
            Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
            edgeColors.put(e, color);
        }
        return edgeColors;
    }

    public static interface TriPainter {
        public void paint(Graphics2D var1, TriMesh.Tri var2, TriMesh.Node var3, int var4, int var5, TriMesh.Node var6, int var7, int var8, TriMesh.Node var9, int var10, int var11);
    }

    public static enum Orientation {
        XRIGHT_YUP,
        XDOWN_YRIGHT;

    }
}

