/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.Mosaic;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.mosaic.Tile;
import edu.mines.jtk.mosaic.TileAxis;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Clips;
import edu.mines.jtk.util.Float3;
import edu.mines.jtk.util.SimpleFloat3;
import java.awt.Color;
import java.awt.image.IndexColorModel;

public class PlotPanelPixels3
extends PlotPanel {
    private static final long serialVersionUID = 1L;
    private int _n1;
    private int _n2;
    private int _n3;
    private int _k1;
    private int _k2;
    private int _k3;
    private Sampling _s1;
    private Sampling _s2;
    private Sampling _s3;
    private PixelsView _p12;
    private PixelsView _p13;
    private PixelsView _p23;
    private PointsView _l12;
    private PointsView _l13;
    private PointsView _l23;
    private boolean _transpose23;
    private int _nc;
    private Clips[] _clips;
    private Float3[] _f3;
    private ColorMap _colorMap = new ColorMap(ColorMap.GRAY);
    private Orientation _orientation;
    private AxesPlacement _axesPlacement;

    public PlotPanelPixels3(Orientation orientation, AxesPlacement axesPlacement, Sampling s1, Sampling s2, Sampling s3, float[][][] f) {
        this(orientation, axesPlacement, s1, s2, s3, new SimpleFloat3(f));
    }

    public PlotPanelPixels3(Orientation orientation, AxesPlacement axesPlacement, Sampling s1, Sampling s2, Sampling s3, float[][][][] f) {
        this(orientation, axesPlacement, s1, s2, s3, PlotPanelPixels3.toFloat3(f));
    }

    private static Float3[] toFloat3(float[][][][] f) {
        Float3[] f3 = new Float3[f.length];
        for (int i = 0; i < f.length; ++i) {
            f3[i] = new SimpleFloat3(f[i]);
        }
        return f3;
    }

    public PlotPanelPixels3(Orientation orientation, AxesPlacement axesPlacement, Sampling s1, Sampling s2, Sampling s3, Float3 f3) {
        this(orientation, axesPlacement, s1, s2, s3, new Float3[]{f3});
    }

    public PlotPanelPixels3(Orientation orientation, AxesPlacement axesPlacement, Sampling s1, Sampling s2, Sampling s3, Float3[] f3) {
        super(2, 2, PlotPanelPixels3.plotPanelOrientation(orientation), PlotPanelPixels3.plotPanelAxesPlacement(axesPlacement));
        this._nc = f3.length;
        this._f3 = f3;
        this._clips = new Clips[this._nc];
        for (int ic = 0; ic < this._nc; ++ic) {
            this._clips[ic] = new Clips(this._f3[ic]);
        }
        this.init(orientation, axesPlacement, s1, s2, s3);
        this.setPercentiles(0.0f, 100.0f);
    }

    public PixelsView getPixelsView12() {
        return this._p12;
    }

    public PixelsView getPixelsView13() {
        return this._p13;
    }

    public PixelsView getPixelsView23() {
        return this._p23;
    }

    public void setSlice23(int k1) {
        this.setSlices(k1, this._k2, this._k3);
    }

    public void setSlice13(int k2) {
        this.setSlices(this._k1, k2, this._k3);
    }

    public void setSlice12(int k3) {
        this.setSlices(this._k1, this._k2, k3);
    }

    public void setSlices(int k1, int k2, int k3) {
        if (this._k1 != k1) {
            this._k1 = k1;
            if (this._transpose23) {
                this._p23.set(this._s3, this._s2, this.slice23());
            } else {
                this._p23.set(this._s2, this._s3, this.slice23());
            }
            this._l12.set(this.lines12a(), this.lines12b());
            this._l13.set(this.lines13a(), this.lines13b());
        }
        if (this._k2 != k2) {
            this._k2 = k2;
            this._p13.set(this._s1, this._s3, this.slice13());
            this._l12.set(this.lines12a(), this.lines12b());
            this._l23.set(this.lines23a(), this.lines23b());
        }
        if (this._k3 != k3) {
            this._k3 = k3;
            this._p12.set(this._s1, this._s2, this.slice12());
            this._l13.set(this.lines13a(), this.lines13b());
            this._l23.set(this.lines23a(), this.lines23b());
        }
    }

    public void setInterpolation(PixelsView.Interpolation interpolation) {
        this._p12.setInterpolation(interpolation);
        this._p13.setInterpolation(interpolation);
        this._p23.setInterpolation(interpolation);
    }

    public void setLineColor(Color color) {
        if (color == null) {
            this.hideLines();
        } else {
            this.showLines();
            this._l12.setLineColor(color);
            this._l13.setLineColor(color);
            this._l23.setLineColor(color);
        }
    }

    public void setLabel1(String label) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setVLabel(1, label);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setVLabel(1, label);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setHLabel(0, label);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setHLabel(0, label);
        }
    }

    public void setLabel2(String label) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setHLabel(0, label);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setHLabel(1, label);
            this.setVLabel(0, label);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setVLabel(1, label);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setHLabel(1, label);
            this.setVLabel(0, label);
        }
    }

    public void setLabel3(String label) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setHLabel(1, label);
            this.setVLabel(0, label);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setHLabel(0, label);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setHLabel(1, label);
            this.setVLabel(0, label);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setVLabel(1, label);
        }
    }

    public void setFormat1(String format) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setVFormat(1, format);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setVFormat(1, format);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setHFormat(0, format);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setHFormat(0, format);
        }
    }

    public void setFormat2(String format) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setHFormat(0, format);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setHFormat(1, format);
            this.setVFormat(0, format);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setVFormat(1, format);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setHFormat(1, format);
            this.setVFormat(0, format);
        }
    }

    public void setFormat3(String format) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setHFormat(1, format);
            this.setVFormat(0, format);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setHFormat(0, format);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setHFormat(1, format);
            this.setVFormat(0, format);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setVFormat(1, format);
        }
    }

    public void setInterval1(double interval) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setVInterval(1, interval);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setVInterval(1, interval);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setHInterval(0, interval);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setHInterval(0, interval);
        }
    }

    public void setInterval2(double interval) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setHInterval(0, interval);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setHInterval(1, interval);
            this.setVInterval(0, interval);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setVInterval(1, interval);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setHInterval(1, interval);
            this.setVInterval(0, interval);
        }
    }

    public void setInterval3(double interval) {
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            this.setHInterval(1, interval);
            this.setVInterval(0, interval);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            this.setHInterval(0, interval);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            this.setHInterval(1, interval);
            this.setVInterval(0, interval);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            this.setVInterval(1, interval);
        }
    }

    public void setColorModel(IndexColorModel colorModel) {
        if (this._nc == 1) {
            this._colorMap.setColorModel(colorModel);
            this._p12.setColorModel(colorModel);
            this._p13.setColorModel(colorModel);
            this._p23.setColorModel(colorModel);
        }
    }

    @Override
    public IndexColorModel getColorModel() {
        return this._nc == 1 ? this._colorMap.getColorModel() : null;
    }

    public void setClips(float clipMin, float clipMax) {
        for (int ic = 0; ic < this._nc; ++ic) {
            this._clips[ic].setClips(clipMin, clipMax);
        }
        this._p12.setClips(clipMin, clipMax);
        this._p13.setClips(clipMin, clipMax);
        this._p23.setClips(clipMin, clipMax);
    }

    public float getClipMin() {
        return this._clips[0].getClipMin();
    }

    public float getClipMax() {
        return this._clips[0].getClipMax();
    }

    public void setPercentiles(float percMin, float percMax) {
        for (int ic = 0; ic < this._nc; ++ic) {
            this._clips[ic].setPercentiles(percMin, percMax);
            float clipMin = this._clips[ic].getClipMin();
            float clipMax = this._clips[ic].getClipMax();
            this._p12.setClips(clipMin, clipMax);
            this._p13.setClips(clipMin, clipMax);
            this._p23.setClips(clipMin, clipMax);
        }
    }

    public float getPercentileMin() {
        return this._clips[0].getPercentileMin();
    }

    public float getPercentileMax() {
        return this._clips[0].getPercentileMax();
    }

    public void setClips(int ic, float clipMin, float clipMax) {
        this._clips[ic].setClips(clipMin, clipMax);
        clipMin = this._clips[ic].getClipMin();
        clipMax = this._clips[ic].getClipMax();
        this._p12.setClips(ic, clipMin, clipMax);
        this._p13.setClips(ic, clipMin, clipMax);
        this._p23.setClips(ic, clipMin, clipMax);
    }

    public float getClipMin(int ic) {
        return this._clips[ic].getClipMin();
    }

    public float getClipMax(int ic) {
        return this._clips[ic].getClipMax();
    }

    public void setPercentiles(int ic, float percMin, float percMax) {
        this._clips[ic].setPercentiles(percMin, percMax);
        float clipMin = this._clips[ic].getClipMin();
        float clipMax = this._clips[ic].getClipMax();
        this._p12.setClips(ic, clipMin, clipMax);
        this._p13.setClips(ic, clipMin, clipMax);
        this._p23.setClips(ic, clipMin, clipMax);
    }

    public float getPercentileMin(int ic) {
        return this._clips[ic].getPercentileMin();
    }

    public float getPercentileMax(int ic) {
        return this._clips[ic].getPercentileMax();
    }

    private static PlotPanel.AxesPlacement plotPanelAxesPlacement(AxesPlacement axesPlacement) {
        if (axesPlacement == AxesPlacement.LEFT_BOTTOM) {
            return PlotPanel.AxesPlacement.LEFT_BOTTOM;
        }
        return PlotPanel.AxesPlacement.NONE;
    }

    private static PlotPanel.Orientation plotPanelOrientation(Orientation orientation) {
        if (orientation == Orientation.X1DOWN || orientation == Orientation.X1DOWN_X2RIGHT || orientation == Orientation.X1DOWN_X3RIGHT) {
            return PlotPanel.Orientation.X1DOWN_X2RIGHT;
        }
        return PlotPanel.Orientation.X1RIGHT_X2UP;
    }

    private void init(Orientation orientation, AxesPlacement axesPlacement, Sampling s1, Sampling s2, Sampling s3) {
        this._s1 = s1;
        this._s2 = s2;
        this._s3 = s3;
        this._n1 = s1.getCount();
        this._n2 = s2.getCount();
        this._n3 = s3.getCount();
        this._k1 = this._n1 / 2;
        this._k2 = this._n2 / 2;
        this._k3 = this._n3 / 2;
        if (orientation == Orientation.X1DOWN) {
            orientation = this._n2 > this._n3 ? Orientation.X1DOWN_X2RIGHT : Orientation.X1DOWN_X3RIGHT;
        } else if (orientation == Orientation.X1RIGHT) {
            orientation = this._n2 > this._n3 ? Orientation.X1RIGHT_X2UP : Orientation.X1RIGHT_X3UP;
        }
        this._orientation = orientation;
        this._axesPlacement = axesPlacement;
        if (orientation == Orientation.X1DOWN_X2RIGHT) {
            this._transpose23 = false;
            this._p12 = this.addPixels(1, 0, s1, s2, this.slice12());
            this._p13 = this.addPixels(1, 1, s1, s3, this.slice13());
            this._p23 = this.addPixels(0, 0, s2, s3, this.slice23());
            this._p12.setOrientation(PixelsView.Orientation.X1DOWN_X2RIGHT);
            this._p13.setOrientation(PixelsView.Orientation.X1DOWN_X2RIGHT);
            this._p23.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._l12 = this.addPoints(1, 0, this.lines12a(), this.lines12b());
            this._l13 = this.addPoints(1, 1, this.lines13a(), this.lines13b());
            this._l23 = this.addPoints(0, 0, this.lines23a(), this.lines23b());
            this._l12.setOrientation(PointsView.Orientation.X1DOWN_X2RIGHT);
            this._l13.setOrientation(PointsView.Orientation.X1DOWN_X2RIGHT);
            this._l23.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this.getMosaic().setWidthElastic(0, 100 * this._n2 / this._n3);
            this.getMosaic().setHeightElastic(0, 100 * this._n3 / this._n1);
        } else if (orientation == Orientation.X1DOWN_X3RIGHT) {
            this._transpose23 = true;
            this._p12 = this.addPixels(1, 1, s1, s2, this.slice12());
            this._p13 = this.addPixels(1, 0, s1, s3, this.slice13());
            this._p23 = this.addPixels(0, 0, s3, s2, this.slice23());
            this._p12.setOrientation(PixelsView.Orientation.X1DOWN_X2RIGHT);
            this._p13.setOrientation(PixelsView.Orientation.X1DOWN_X2RIGHT);
            this._p23.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._l12 = this.addPoints(1, 1, this.lines12a(), this.lines12b());
            this._l13 = this.addPoints(1, 0, this.lines13a(), this.lines13b());
            this._l23 = this.addPoints(0, 0, this.lines23a(), this.lines23b());
            this._l12.setOrientation(PointsView.Orientation.X1DOWN_X2RIGHT);
            this._l13.setOrientation(PointsView.Orientation.X1DOWN_X2RIGHT);
            this._l23.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this.getMosaic().setWidthElastic(0, 100 * this._n3 / this._n2);
            this.getMosaic().setHeightElastic(0, 100 * this._n2 / this._n1);
        } else if (orientation == Orientation.X1RIGHT_X2UP) {
            this._transpose23 = true;
            this._p12 = this.addPixels(1, 0, s1, s2, this.slice12());
            this._p13 = this.addPixels(0, 0, s1, s3, this.slice13());
            this._p23 = this.addPixels(1, 1, s3, s2, this.slice23());
            this._p12.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._p13.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._p23.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._l12 = this.addPoints(1, 0, this.lines12a(), this.lines12b());
            this._l13 = this.addPoints(0, 0, this.lines13a(), this.lines13b());
            this._l23 = this.addPoints(1, 1, this.lines23a(), this.lines23b());
            this._l12.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this._l13.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this._l23.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this.getMosaic().setWidthElastic(0, 100 * this._n1 / this._n3);
            this.getMosaic().setHeightElastic(0, 100 * this._n3 / this._n2);
        } else if (orientation == Orientation.X1RIGHT_X3UP) {
            this._transpose23 = false;
            this._p12 = this.addPixels(0, 0, s1, s2, this.slice12());
            this._p13 = this.addPixels(1, 0, s1, s3, this.slice13());
            this._p23 = this.addPixels(1, 1, s2, s3, this.slice23());
            this._p12.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._p13.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._p23.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._l12 = this.addPoints(0, 0, this.lines12a(), this.lines12b());
            this._l13 = this.addPoints(1, 0, this.lines13a(), this.lines13b());
            this._l23 = this.addPoints(1, 1, this.lines23a(), this.lines23b());
            this._l12.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this._l13.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this._l23.setOrientation(PointsView.Orientation.X1RIGHT_X2UP);
            this.getMosaic().setWidthElastic(0, 100 * this._n1 / this._n2);
            this.getMosaic().setHeightElastic(0, 100 * this._n2 / this._n3);
        }
    }

    private float[][][] slice12() {
        float[][][] x = new float[this._nc][this._n2][this._n1];
        for (int ic = 0; ic < this._nc; ++ic) {
            this._f3[ic].get12(this._n1, this._n2, 0, 0, this._k3, x[ic]);
        }
        return x;
    }

    private float[][][] slice13() {
        float[][][] x = new float[this._nc][this._n3][this._n1];
        for (int ic = 0; ic < this._nc; ++ic) {
            this._f3[ic].get13(this._n1, this._n3, 0, this._k2, 0, x[ic]);
        }
        return x;
    }

    private float[][][] slice23() {
        float[][][] x = new float[this._nc][][];
        float[][] xic = new float[this._n3][this._n2];
        for (int ic = 0; ic < this._nc; ++ic) {
            this._f3[ic].get23(this._n2, this._n3, this._k1, 0, 0, xic);
            x[ic] = this._transpose23 ? ArrayMath.transpose(xic) : ArrayMath.copy(xic);
        }
        return x;
    }

    private float[][] lines12a() {
        float xa1 = (float)this._s1.getValue(0);
        float xk1 = (float)this._s1.getValue(this._k1);
        float xb1 = (float)this._s1.getValue(this._n1 - 1);
        return new float[][]{{xk1, xk1}, {xa1, xb1}};
    }

    private float[][] lines12b() {
        float xa2 = (float)this._s2.getValue(0);
        float xk2 = (float)this._s2.getValue(this._k2);
        float xb2 = (float)this._s2.getValue(this._n2 - 1);
        return new float[][]{{xa2, xb2}, {xk2, xk2}};
    }

    private float[][] lines13a() {
        float xa1 = (float)this._s1.getValue(0);
        float xk1 = (float)this._s1.getValue(this._k1);
        float xb1 = (float)this._s1.getValue(this._n1 - 1);
        return new float[][]{{xk1, xk1}, {xa1, xb1}};
    }

    private float[][] lines13b() {
        float xa3 = (float)this._s3.getValue(0);
        float xk3 = (float)this._s3.getValue(this._k3);
        float xb3 = (float)this._s3.getValue(this._n3 - 1);
        return new float[][]{{xa3, xb3}, {xk3, xk3}};
    }

    private float[][] lines23a() {
        if (this._transpose23) {
            float xa3 = (float)this._s3.getValue(0);
            float xk3 = (float)this._s3.getValue(this._k3);
            float xb3 = (float)this._s3.getValue(this._n3 - 1);
            return new float[][]{{xk3, xk3}, {xa3, xb3}};
        }
        float xa2 = (float)this._s2.getValue(0);
        float xk2 = (float)this._s2.getValue(this._k2);
        float xb2 = (float)this._s2.getValue(this._n2 - 1);
        return new float[][]{{xk2, xk2}, {xa2, xb2}};
    }

    private float[][] lines23b() {
        if (this._transpose23) {
            float xa2 = (float)this._s2.getValue(0);
            float xk2 = (float)this._s2.getValue(this._k2);
            float xb2 = (float)this._s2.getValue(this._n2 - 1);
            return new float[][]{{xa2, xb2}, {xk2, xk2}};
        }
        float xa3 = (float)this._s3.getValue(0);
        float xk3 = (float)this._s3.getValue(this._k3);
        float xb3 = (float)this._s3.getValue(this._n3 - 1);
        return new float[][]{{xa3, xb3}, {xk3, xk3}};
    }

    private void showLines() {
        Mosaic mosaic = this.getMosaic();
        Tile t00 = mosaic.getTile(0, 0);
        Tile t10 = mosaic.getTile(1, 0);
        Tile t11 = mosaic.getTile(1, 1);
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            t00.addTiledView(this._l23);
            t10.addTiledView(this._l12);
            t11.addTiledView(this._l13);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            t00.addTiledView(this._l23);
            t10.addTiledView(this._l13);
            t11.addTiledView(this._l12);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            t00.addTiledView(this._l13);
            t10.addTiledView(this._l12);
            t11.addTiledView(this._l23);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            t00.addTiledView(this._l12);
            t10.addTiledView(this._l13);
            t11.addTiledView(this._l23);
        }
    }

    private void hideLines() {
        Mosaic mosaic = this.getMosaic();
        Tile t00 = mosaic.getTile(0, 0);
        Tile t10 = mosaic.getTile(1, 0);
        Tile t11 = mosaic.getTile(1, 1);
        if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            t00.removeTiledView(this._l23);
            t10.removeTiledView(this._l12);
            t11.removeTiledView(this._l13);
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            t00.removeTiledView(this._l23);
            t10.removeTiledView(this._l13);
            t11.removeTiledView(this._l12);
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            t00.removeTiledView(this._l13);
            t10.removeTiledView(this._l12);
            t11.removeTiledView(this._l23);
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            t00.removeTiledView(this._l12);
            t10.removeTiledView(this._l13);
            t11.removeTiledView(this._l23);
        }
    }

    TileAxis[] getAxes(int i) {
        Mosaic mosaic = this.getMosaic();
        TileAxis al0 = mosaic.getTileAxisLeft(0);
        TileAxis al1 = mosaic.getTileAxisLeft(1);
        TileAxis ab0 = mosaic.getTileAxisBottom(0);
        TileAxis ab1 = mosaic.getTileAxisBottom(1);
        TileAxis[] a = null;
        if (this._axesPlacement == AxesPlacement.NONE) {
            a = new TileAxis[]{};
        } else if (this._orientation == Orientation.X1DOWN_X2RIGHT) {
            if (i == 1) {
                a = new TileAxis[]{al1};
            }
            if (i == 2) {
                a = new TileAxis[]{ab0};
            }
            if (i == 3) {
                a = new TileAxis[]{al0, ab1};
            }
        } else if (this._orientation == Orientation.X1DOWN_X3RIGHT) {
            if (i == 1) {
                a = new TileAxis[]{al1};
            }
            if (i == 2) {
                a = new TileAxis[]{al0, ab1};
            }
            if (i == 3) {
                a = new TileAxis[]{ab0};
            }
        } else if (this._orientation == Orientation.X1RIGHT_X2UP) {
            if (i == 1) {
                a = new TileAxis[]{ab0};
            }
            if (i == 2) {
                a = new TileAxis[]{al1};
            }
            if (i == 3) {
                a = new TileAxis[]{al0, ab1};
            }
        } else if (this._orientation == Orientation.X1RIGHT_X3UP) {
            if (i == 1) {
                a = new TileAxis[]{ab0};
            }
            if (i == 2) {
                a = new TileAxis[]{al0, ab1};
            }
            if (i == 3) {
                a = new TileAxis[]{al1};
            }
        }
        return a;
    }

    public static enum AxesPlacement {
        LEFT_BOTTOM,
        NONE;

    }

    public static enum Orientation {
        X1DOWN,
        X1DOWN_X2RIGHT,
        X1DOWN_X3RIGHT,
        X1RIGHT,
        X1RIGHT_X2UP,
        X1RIGHT_X3UP;

    }
}

