/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingBoxTree;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.util.Direct;
import java.nio.FloatBuffer;

public class PointGroup
extends Group {
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    private static final int MIN_POINT_PER_NODE = 2048;
    private float _size;

    public PointGroup(float[] xyz) {
        this(xyz, null);
    }

    public PointGroup(float[] xyz, float[] rgb) {
        this.buildTree(xyz, rgb);
    }

    public PointGroup(float size, float[] xyz) {
        this(size, xyz, null);
    }

    public PointGroup(float size, float[] xyz, float[] rgb) {
        this._size = size;
        this.buildTree(xyz, rgb);
    }

    private void buildTree(float[] xyz, float[] rgb) {
        BoundingBoxTree bbt = new BoundingBoxTree(2048, xyz);
        this.buildTree(this, bbt.getRoot(), xyz, rgb);
    }

    private void buildTree(Group parent, BoundingBoxTree.Node bbtNode, float[] xyz, float[] rgb) {
        if (bbtNode.isLeaf()) {
            PointNode pn = this._size > 0.0f ? new PointNode(bbtNode, this._size, xyz, rgb) : new PointNode(bbtNode, xyz, rgb);
            parent.addChild(pn);
        } else {
            Group group = new Group();
            parent.addChild(group);
            this.buildTree(group, bbtNode.getLeft(), xyz, rgb);
            this.buildTree(group, bbtNode.getRight(), xyz, rgb);
        }
    }

    private class PointNode
    extends Node {
        private BoundingSphere _bs;
        private int _np;
        private FloatBuffer _vb;
        private FloatBuffer _nb;
        private FloatBuffer _cb;

        public PointNode(BoundingBoxTree.Node bbtNode, float[] xyz, float[] rgb) {
            int np;
            BoundingBox bb = bbtNode.getBoundingBox();
            this._bs = new BoundingSphere(bb);
            int nv = np = (this._np = bbtNode.getSize());
            int nc = np;
            int[] index = bbtNode.getIndices();
            this._vb = Direct.newFloatBuffer(3 * nv);
            this._cb = rgb != null ? Direct.newFloatBuffer(3 * nc) : null;
            int iv = 0;
            int ic = 0;
            for (int ip = 0; ip < np; ++ip) {
                int i = 3 * index[ip];
                this._vb.put(iv++, xyz[i + 0]);
                this._vb.put(iv++, xyz[i + 1]);
                this._vb.put(iv++, xyz[i + 2]);
                if (this._cb == null) continue;
                this._cb.put(ic++, rgb[i + 0]);
                this._cb.put(ic++, rgb[i + 1]);
                this._cb.put(ic++, rgb[i + 2]);
            }
        }

        public PointNode(BoundingBoxTree.Node bbtNode, float size, float[] xyz, float[] rgb) {
            int np;
            BoundingBox bb = bbtNode.getBoundingBox();
            this._bs = new BoundingSphere(bb);
            int nv = np = (this._np = bbtNode.getSize());
            int nn = np;
            int nc = np;
            int[] index = bbtNode.getIndices();
            this._vb = Direct.newFloatBuffer(72 * nv);
            this._nb = Direct.newFloatBuffer(72 * nn);
            this._cb = rgb != null ? Direct.newFloatBuffer(72 * nc) : null;
            float d = 0.5f * size;
            int iv = 0;
            int in = 0;
            int ic = 0;
            for (int ip = 0; ip < np; ++ip) {
                int i = 3 * index[ip];
                float xi = xyz[i + 0];
                float yi = xyz[i + 1];
                float zi = xyz[i + 2];
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi - d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi - d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi + d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi + d);
                this._vb.put(iv++, xi - d);
                this._vb.put(iv++, yi + d);
                this._vb.put(iv++, zi + d);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, -1.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 0.0f);
                this._nb.put(in++, 1.0f);
                if (this._cb == null) continue;
                float ri = rgb[i + 0];
                float gi = rgb[i + 1];
                float bi = rgb[i + 2];
                for (int j = 0; j < 24; ++j) {
                    this._cb.put(ic++, ri);
                    this._cb.put(ic++, gi);
                    this._cb.put(ic++, bi);
                }
            }
        }

        @Override
        protected BoundingSphere computeBoundingSphere(boolean finite) {
            return this._bs;
        }

        @Override
        protected void draw(DrawContext dc) {
            Gl.glEnableClientState(32884);
            Gl.glVertexPointer(3, 5126, 0, this._vb);
            if (this._nb != null) {
                Gl.glEnableClientState(32885);
                Gl.glNormalPointer(5126, 0, this._nb);
            }
            if (this._cb != null) {
                Gl.glEnableClientState(32886);
                Gl.glColorPointer(3, 5126, 0, this._cb);
            }
            if (PointGroup.this._size > 0.0f) {
                Gl.glDrawArrays(7, 0, 24 * this._np);
            } else {
                Gl.glDrawArrays(0, 0, this._np);
            }
            if (this._cb != null) {
                Gl.glDisableClientState(32886);
            }
            if (this._nb != null) {
                Gl.glDisableClientState(32885);
            }
            Gl.glDisableClientState(32884);
        }
    }
}

