/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Localize {
    private static final Logger LOG = Logger.getLogger(Localize.class.getName());
    private static final Pattern s_tokens = Pattern.compile("[$][{](.+?)[}]");
    private static final Map<String, ResourceBundle> s_rb = new HashMap<String, ResourceBundle>();
    private final ResourceBundle resourceBundle;
    private final Locale locale;
    private final Class<?> clazz;
    private final String resourceBundleName;

    public Localize(Class<?> clazz) {
        this(clazz, null);
    }

    public Localize(Class<?> clazz, String resourceBundleName) {
        this(clazz, resourceBundleName, null);
    }

    public Localize(Class<?> clazz, String resourceBundleName, Locale locale) {
        this.clazz = clazz;
        this.resourceBundleName = resourceBundleName;
        this.resourceBundle = Localize.getResourceBundle(clazz, resourceBundleName, locale);
        this.locale = locale;
    }

    public String format(String key, Object ... args) {
        String format;
        if (key == null) {
            return null;
        }
        try {
            format = this.resourceBundle != null ? this.resourceBundle.getString(key) : key;
        }
        catch (MissingResourceException mre) {
            format = key;
        }
        Formatter formatter = new Formatter(this.locale);
        String s = formatter.format(format, args).out().toString().trim();
        formatter.close();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getResourceBundle(Class<?> clazz, String resourceBundleName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String key = clazz.getName() + ";" + resourceBundleName + ";" + locale.toString();
        Map<String, ResourceBundle> map = s_rb;
        synchronized (map) {
            ResourceBundle resourceBundle = s_rb.get(key);
            if (resourceBundle == null) {
                if (resourceBundleName == null) {
                    Class<?> c2;
                    String cn = clazz.getName();
                    if (cn == null && (c2 = clazz.getEnclosingClass()) != null) {
                        cn = c2.getName();
                    }
                    if (cn == null) {
                        throw new IllegalArgumentException("Specify top-level class.  This class does not have a canonical name: " + clazz.getName());
                    }
                    resourceBundleName = cn;
                } else {
                    resourceBundleName = clazz.getPackage().getName() + "." + resourceBundleName;
                }
                try {
                    resourceBundle = ResourceBundle.getBundle(resourceBundleName, locale, clazz.getClassLoader());
                    s_rb.put(key, resourceBundle);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return s_rb.get(key);
        }
    }

    public static String getMessage(Throwable throwable) {
        if (throwable.getCause() == null) {
            String localizedMessage = throwable.getLocalizedMessage();
            if (localizedMessage != null) {
                return localizedMessage;
            }
            String message = throwable.getMessage();
            if (message != null) {
                return message;
            }
            return throwable.toString();
        }
        String causeToString = throwable.getCause().toString();
        String localized = throwable.getLocalizedMessage();
        if (localized == null || localized.equals(causeToString)) {
            return Localize.getMessage(throwable.getCause());
        }
        return localized;
    }

    public String toString() {
        return "Localize{, locale=" + this.locale + ", clazz=" + this.clazz + ", resourceBundleName='" + this.resourceBundleName + '\'' + '}';
    }

    public static String filter(String message, ResourceBundle catalog) {
        if (catalog == null) {
            return message;
        }
        try {
            message = catalog.getString(message);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        Matcher matcher = s_tokens.matcher(message);
        int numberMatches = 0;
        while (matcher.find()) {
            ++numberMatches;
        }
        for (int match = numberMatches; match > 0; --match) {
            matcher.reset();
            for (int i = 0; i < match; ++i) {
                matcher.find();
            }
            MatchResult mr = matcher.toMatchResult();
            try {
                String key = mr.group(1);
                String replacement = catalog.getString(key);
                int start = mr.start();
                int end = mr.end();
                message = message.substring(0, start) + replacement + message.substring(end);
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return message;
    }

    @Deprecated
    public static String filter(String message, Class<?> resourceClass) {
        ClassLoader cl = resourceClass.getClassLoader();
        if (cl == null) {
            LOG.warning("Could not get ClassLoader from " + resourceClass.getName());
            cl = ClassLoader.getSystemClassLoader();
        }
        Locale currentLocale = Locale.getDefault();
        String name = resourceClass.getName();
        ResourceBundle catalog = ResourceBundle.getBundle(name, currentLocale, cl);
        if (catalog == null) {
            LOG.warning("Could not get ResourceBundle " + name + " for " + currentLocale + " from " + cl);
        }
        return Localize.filter(message, catalog);
    }

    public static String timeWords(long seconds) {
        if (seconds == 0L) {
            return Localize.filter("0 ${seconds}", Localize.class);
        }
        String result = "";
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        if (days >= 10L) {
            if (hours >= 12L) {
                ++days;
            }
            seconds = 0L;
            minutes = 0L;
            hours = 0L;
        } else if (hours >= 10L || days > 0L) {
            if (minutes >= 30L) {
                days += ++hours / 24L;
                hours %= 24L;
            }
            seconds = 0L;
            minutes = 0L;
        } else if (minutes >= 10L || hours > 0L) {
            if (seconds >= 30L) {
                hours += ++minutes / 60L;
                minutes %= 60L;
            }
            seconds = 0L;
        }
        if (seconds != 0L) {
            result = " " + seconds + " ${second" + (seconds > 1L ? "s}" : "}") + result;
        }
        if (minutes != 0L) {
            result = " " + minutes + " ${minute" + (minutes > 1L ? "s}" : "}") + result;
        }
        if (hours != 0L) {
            result = " " + hours + " ${hour" + (hours > 1L ? "s}" : "}") + result;
        }
        if (days != 0L) {
            result = " " + days + " ${day" + (days > 1L ? "s}" : "}") + result;
        }
        return Localize.filter(result.trim(), Localize.class);
    }
}

