/*
 * Decompiled with CFR 0.152.
 */
package process;

import fiji.util.KDTree;
import fiji.util.NNearestNeighborSearch;
import fiji.util.node.Leaf;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.util.Util;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussianPeak;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AbstractModel;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.InterpolatedAffineModel2D;
import mpicbg.models.InterpolatedAffineModel3D;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;
import mpicbg.models.TranslationModel2D;
import mpicbg.pointdescriptor.AbstractPointDescriptor;
import mpicbg.pointdescriptor.ModelPointDescriptor;
import mpicbg.pointdescriptor.SimplePointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.pointdescriptor.matcher.Matcher;
import mpicbg.pointdescriptor.matcher.SubsetMatcher;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;
import mpicbg.pointdescriptor.model.TranslationInvariantRigidModel2D;
import mpicbg.pointdescriptor.model.TranslationInvariantRigidModel3D;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;
import mpicbg.pointdescriptor.similarity.SquareDistance;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.bead.BeadRegistration;
import plugin.DescriptorParameters;
import plugin.Descriptor_based_registration;
import plugin.Descriptor_based_series_registration;
import process.ComparePair;
import process.DetectionSegmentation;
import process.OverlayFusion;
import process.Particle;

public class Matching {
    public static boolean applyScaling = false;
    public static float factor = 1.0f;
    protected static PrintWriter outAll = null;

    public static int descriptorBasedRegistration(ImagePlus imp1, ImagePlus imp2, DescriptorParameters params) {
        Model model2;
        AffineModel2D model1;
        float zStretching2;
        int numInliers = 0;
        float zStretching1 = params.dimensionality == 3 ? (float)imp1.getCalibration().pixelDepth / (float)imp1.getCalibration().pixelWidth : 1.0f;
        float f = zStretching2 = params.dimensionality == 3 ? (float)imp2.getCalibration().pixelDepth / (float)imp2.getCalibration().pixelWidth : 1.0f;
        if (!params.reApply) {
            ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks1 = Matching.extractCandidates(imp1, params.channel1, 0, params, null);
            ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks2 = Matching.extractCandidates(imp2, params.channel2, 0, params, null);
            int size1 = peaks1.size();
            int size2 = peaks2.size();
            peaks1 = Matching.filterForROI(params.roi1, peaks1);
            peaks2 = Matching.filterForROI(params.roi2, peaks2);
            if (size1 != peaks1.size() && !params.silent) {
                IJ.log((String)(peaks1.size() + " candidates remaining for " + imp1.getTitle() + " after filtering by ROI."));
            }
            if (size2 != peaks2.size() && !params.silent) {
                IJ.log((String)(peaks2.size() + " candidates remaining for " + imp2.getTitle() + " after filtering by ROI."));
            }
            int minNumPeaks = params.numNeighbors + params.redundancy + 1;
            if (peaks1.size() < minNumPeaks || peaks2.size() < minNumPeaks) {
                if (!params.silent) {
                    IJ.log((String)("Not enough peaks in one of the images, should be at least " + minNumPeaks + ", " + imp1.getTitle() + " has " + peaks1.size() + "peaks, " + imp2.getTitle() + " has " + peaks2.size() + " peaks."));
                }
                return 0;
            }
            ArrayList<PointMatch> finalInliers = new ArrayList<PointMatch>();
            model1 = Matching.pairwiseMatching(finalInliers, peaks1, peaks2, zStretching1, zStretching2, params, "");
            model2 = params.model.copy();
            numInliers = finalInliers.size();
            if (model1 == null || model2 == null) {
                return 0;
            }
            if (params.regularize) {
                if (params.dimensionality == 2) {
                    model1 = ((InterpolatedAffineModel2D)model1).createAffineModel2D();
                    model2 = ((InterpolatedAffineModel2D)model2).createAffineModel2D();
                } else {
                    model1 = ((InterpolatedAffineModel3D)model1).createAffineModel3D();
                    model2 = ((InterpolatedAffineModel3D)model2).createAffineModel3D();
                }
            }
            if (params.storePoints) {
                params.inliers = finalInliers;
            }
            if (params.storeModels) {
                params.model1 = (InvertibleBoundable)model1.copy();
                params.model2 = (InvertibleBoundable)model2.copy();
            }
            try {
                Descriptor_based_registration.lastModel1 = (InvertibleBoundable)model1.copy();
                Descriptor_based_registration.lastModel2 = (InvertibleBoundable)model2.copy();
                Descriptor_based_registration.lastDimensionality = params.dimensionality;
            }
            catch (Exception e) {
                IJ.log((String)"Could not save model as static variable.");
            }
            if (!params.silent) {
                IJ.log((String)("" + model1));
            }
            if (params.setPointsRois) {
                Matching.setPointRois(imp1, imp2, finalInliers);
            }
        } else {
            model1 = ((Model)Descriptor_based_registration.lastModel1).copy();
            model2 = ((Model)Descriptor_based_registration.lastModel2).copy();
        }
        if (params.fuse < 2) {
            block20: {
                if (params.dimensionality == 3) {
                    try {
                        BeadRegistration.concatenateAxialScaling((AbstractAffineModel3D)((AbstractAffineModel3D)model1), (double)(imp1.getCalibration().pixelDepth / imp1.getCalibration().pixelWidth));
                        BeadRegistration.concatenateAxialScaling((AbstractAffineModel3D)((AbstractAffineModel3D)model2), (double)(imp2.getCalibration().pixelDepth / imp2.getCalibration().pixelWidth));
                    }
                    catch (Exception e) {
                        if (params.silent) break block20;
                        IJ.log((String)("WARNING: Cannot cast " + model1.getClass().getSimpleName() + " to AbstractAffineModel3d, cannot concatenate axial scaling."));
                    }
                }
            }
            CompositeImage composite = imp1.getType() == 2 || imp2.getType() == 2 ? OverlayFusion.createOverlay(new FloatType(), imp1, imp2, (InvertibleBoundable)model1, (InvertibleBoundable)model2, params.dimensionality, params.interpolation) : (imp1.getType() == 1 || imp2.getType() == 1 ? OverlayFusion.createOverlay(new UnsignedShortType(), imp1, imp2, (InvertibleBoundable)model1, (InvertibleBoundable)model2, params.dimensionality, params.interpolation) : OverlayFusion.createOverlay(new UnsignedByteType(), imp1, imp2, (InvertibleBoundable)model1, (InvertibleBoundable)model2, params.dimensionality, params.interpolation));
            composite.show();
        }
        return numInliers;
    }

    public static ArrayList<InvertibleBoundable> descriptorBasedStackRegistration(ImagePlus imp, DescriptorParameters params) {
        ArrayList<InvertibleBoundable> models;
        float zStretching;
        int numImages = imp.getNFrames();
        float f = zStretching = params.dimensionality == 3 ? (float)imp.getCalibration().pixelDepth / (float)imp.getCalibration().pixelWidth : 1.0f;
        if (!params.reApply) {
            Vector<ComparePair> pairs;
            int d;
            float[] subpixel;
            int[] position;
            Iterator<InvertibleBoundable> peaksComplete = new ArrayList();
            float[] minmax = DescriptorParameters.minMaxType == 0 ? null : (DescriptorParameters.minMaxType == 1 ? Matching.computeMinMax(imp, params.channel1) : new float[]{(float)DescriptorParameters.min, (float)DescriptorParameters.max});
            if (minmax != null) {
                IJ.log((String)("min=" + minmax[0]));
                IJ.log((String)("max=" + minmax[1]));
            }
            for (int t = 0; t < numImages; ++t) {
                ((ArrayList)((Object)peaksComplete)).add((InvertibleBoundable)Matching.extractCandidates(imp, params.channel1, t, params, minmax));
            }
            ArrayList<ArrayList<DifferenceOfGaussianPeak<FloatType>>> peaks = new ArrayList<ArrayList<DifferenceOfGaussianPeak<FloatType>>>();
            for (int t = 0; t < numImages; ++t) {
                peaks.add(Matching.filterForROI(params.roi1, (ArrayList)((ArrayList)((Object)peaksComplete)).get(t)));
            }
            if (applyScaling) {
                IJ.log((String)("WARNING: MULTIPLYING TO ALL COORDINATES: " + factor + "!!!"));
                for (ArrayList<DifferenceOfGaussianPeak<FloatType>> list : peaks) {
                    for (DifferenceOfGaussianPeak<FloatType> peak : list) {
                        position = peak.getPosition();
                        subpixel = peak.getSubPixelPositionOffset();
                        d = 0;
                        while (d < position.length) {
                            int n = d;
                            position[n] = (int)((float)position[n] * factor);
                            int n2 = d++;
                            subpixel[n2] = subpixel[n2] * factor;
                        }
                        peak.setPixelLocation(position);
                        peak.setSubPixelLocationOffset(subpixel);
                    }
                }
            }
            if (Descriptor_based_series_registration.offset != null) {
                IJ.log((String)("WARNING: ADDING FOLLWOING OFFSET TO ALL COORDINATES: (" + net.imglib2.util.Util.printCoordinates((float[])Descriptor_based_series_registration.offset) + ")!!!"));
                for (ArrayList<DifferenceOfGaussianPeak<FloatType>> list : peaks) {
                    for (DifferenceOfGaussianPeak<FloatType> peak : list) {
                        position = peak.getPosition();
                        subpixel = peak.getSubPixelPositionOffset();
                        for (d = 0; d < position.length; ++d) {
                            int n = d;
                            position[n] = (int)((double)position[n] + Math.floor(Descriptor_based_series_registration.offset[d]));
                            int n3 = d;
                            subpixel[n3] = (float)((double)subpixel[n3] + ((double)Descriptor_based_series_registration.offset[d] - Math.floor(Descriptor_based_series_registration.offset[d])));
                        }
                        peak.setPixelLocation(position);
                        peak.setSubPixelLocationOffset(subpixel);
                        System.out.println(net.imglib2.util.Util.printCoordinates((float[])peak.getSubPixelPosition()));
                    }
                }
            }
            if ((models = Matching.globalOptimization(pairs = Matching.descriptorMatching(peaks, numImages, params, zStretching), numImages, params)) == null) {
                return null;
            }
            if (params.roi1 != null) {
                int numMatches = Matching.countMatches(pairs);
                if (!params.silent) {
                    IJ.log((String)("\nNumber of matches " + numMatches));
                }
                for (int iteration = 0; iteration < DescriptorParameters.maxIterations; ++iteration) {
                    if (!params.silent) {
                        IJ.log((String)("\nIteration " + (iteration + 1) + " of maximally " + DescriptorParameters.maxIterations + " iterations."));
                    }
                    int numMatches2 = Matching.performIteration(models, peaksComplete, numImages, params, zStretching);
                    if (!params.silent) {
                        IJ.log((String)("\nNumber of matches " + numMatches2));
                    }
                    if (numMatches == numMatches2) break;
                    numMatches = numMatches2;
                }
            }
            Descriptor_based_series_registration.lastModels = new ArrayList();
            for (InvertibleBoundable m : models) {
                Descriptor_based_series_registration.lastModels.add((InvertibleBoundable)((Model)m).copy());
            }
            Descriptor_based_series_registration.lastDimensionality = params.dimensionality;
        } else {
            models = new ArrayList<InvertibleBoundable>();
            for (InvertibleBoundable m : Descriptor_based_series_registration.lastModels) {
                models.add((InvertibleBoundable)((Model)m).copy());
            }
        }
        if (params.fuse < 2) {
            ImagePlus result;
            block29: {
                if (params.dimensionality == 3) {
                    try {
                        for (InvertibleBoundable model : models) {
                            BeadRegistration.concatenateAxialScaling((AbstractAffineModel3D)((AbstractAffineModel3D)model), (double)(imp.getCalibration().pixelDepth / imp.getCalibration().pixelWidth));
                        }
                    }
                    catch (Exception e) {
                        if (params.silent) break block29;
                        IJ.log((String)("WARNING: Cannot cast " + models.get(0).getClass().getSimpleName() + " to AbstractAffineModel3d, cannot concatenate axial scaling."));
                    }
                }
            }
            String directory = null;
            if (params.fuse == 1) {
                directory = params.directory;
            }
            if ((result = imp.getType() == 2 ? OverlayFusion.createReRegisteredSeries(new FloatType(), imp, models, params.dimensionality, directory, params.interpolation) : (imp.getType() == 1 ? OverlayFusion.createReRegisteredSeries(new UnsignedShortType(), imp, models, params.dimensionality, directory, params.interpolation) : OverlayFusion.createReRegisteredSeries(new UnsignedByteType(), imp, models, params.dimensionality, directory, params.interpolation))) != null) {
                result.show();
            }
            if (!params.silent) {
                IJ.log((String)"Finished");
            }
        }
        return models;
    }

    protected static int performIteration(ArrayList<InvertibleBoundable> lastModels, ArrayList<ArrayList<DifferenceOfGaussianPeak<FloatType>>> peaksComplete, int numImages, DescriptorParameters params, float zStretching) {
        ArrayList<ArrayList<DifferenceOfGaussianPeak<FloatType>>> peaks = new ArrayList<ArrayList<DifferenceOfGaussianPeak<FloatType>>>();
        for (int t = 0; t < numImages; ++t) {
            peaks.add(Matching.filterForROI(params.roi1, peaksComplete.get(t), (Model)lastModels.get(t)));
        }
        Vector<ComparePair> pairs = Matching.descriptorMatching(peaks, numImages, params, zStretching);
        ArrayList<InvertibleBoundable> models = Matching.globalOptimization(pairs, numImages, params);
        lastModels.clear();
        for (InvertibleBoundable model : models) {
            lastModels.add(model);
        }
        return Matching.countMatches(pairs);
    }

    protected static int countMatches(List<ComparePair> pairs) {
        int numMatches = 0;
        for (ComparePair pair : pairs) {
            numMatches += pair.inliers.size();
        }
        return numMatches;
    }

    public static Vector<ComparePair> descriptorMatching(final ArrayList<ArrayList<DifferenceOfGaussianPeak<FloatType>>> peaks, int numImages, final DescriptorParameters params, final float zStretching) {
        final Vector<ComparePair> pairs = Matching.getComparePairs(params, numImages);
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        if (DescriptorParameters.correspondenceDirectory != null) {
            File dir = new File(DescriptorParameters.correspondenceDirectory);
            if (dir.exists() && dir.isDirectory()) {
                outAll = Matching.openFileWrite(new File(DescriptorParameters.correspondenceDirectory, "_all.txt"));
            }
            if (outAll == null) {
                IJ.log((String)("Could not open file to write all correspondences: " + new File(DescriptorParameters.correspondenceDirectory, "_all.txt")));
            }
        }
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    for (int i = 0; i < pairs.size(); ++i) {
                        if (i % numThreads != myNumber) continue;
                        ComparePair pair = (ComparePair)pairs.get(i);
                        pair.model = Matching.pairwiseMatching(pair.inliers, (ArrayList)peaks.get(pair.indexA), (ArrayList)peaks.get(pair.indexB), zStretching, zStretching, params, pair.indexA + "<->" + pair.indexB);
                        if (pair.model != null) continue;
                        pair.inliers.clear();
                        pair.model = params.model.copy();
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        if (outAll != null) {
            outAll.close();
        }
        return pairs;
    }

    public static ArrayList<InvertibleBoundable> globalOptimization(Vector<ComparePair> pairs, int numImages, DescriptorParameters params) {
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (int t = 0; t < numImages; ++t) {
            tiles.add(new Tile(params.model.copy()));
        }
        for (ComparePair pair : pairs) {
            if (pair.inliers.size() <= 0) continue;
            for (PointMatch pm : pair.inliers) {
                ((Particle)pm.getP1()).restoreCoordinates();
                ((Particle)pm.getP2()).restoreCoordinates();
            }
        }
        for (ComparePair pair : pairs) {
            Matching.addPointMatches(pair.inliers, (Tile)tiles.get(pair.indexA), (Tile)tiles.get(pair.indexB));
        }
        TileConfiguration tc = new TileConfiguration();
        if (!params.silent) {
            if (params.fixFirstTile) {
                IJ.log((String)"Fixing first tile.");
            } else {
                IJ.log((String)"Not fixing any tile.");
            }
        }
        boolean fixed = false;
        for (int t = 0; t < numImages; ++t) {
            Tile tile = (Tile)tiles.get(t);
            if (tile.getConnectedTiles().size() > 0) {
                tc.addTile(tile);
                if (!params.fixFirstTile || fixed) continue;
                tc.fixTile(tile);
                fixed = true;
                continue;
            }
            if (params.silent) continue;
            IJ.log((String)("Tile " + t + " is not connected to any other tile, cannot compute a model"));
        }
        try {
            tc.preAlign();
            tc.optimize(10.0, 10000, 200);
        }
        catch (Exception e) {
            IJ.log((String)("Global optimization failed: " + e));
            return null;
        }
        ArrayList<InvertibleBoundable> models = new ArrayList<InvertibleBoundable>();
        for (int t = 0; t < numImages; ++t) {
            Tile tile = (Tile)tiles.get(t);
            if (tile.getConnectedTiles().size() > 0) {
                if (params.regularize) {
                    if (params.dimensionality == 2) {
                        models.add((InvertibleBoundable)((InterpolatedAffineModel2D)tile.getModel()).createAffineModel2D());
                    } else {
                        models.add((InvertibleBoundable)((InterpolatedAffineModel3D)tile.getModel()).createAffineModel3D());
                    }
                } else {
                    models.add((InvertibleBoundable)tile.getModel());
                }
                if (params.silent) continue;
                IJ.log((String)("Tile " + t + " (connected): " + models.get(models.size() - 1)));
                continue;
            }
            if (params.regularize) {
                if (params.dimensionality == 2) {
                    models.add((InvertibleBoundable)((InterpolatedAffineModel2D)params.model.copy()).createAffineModel2D());
                } else {
                    models.add((InvertibleBoundable)((InterpolatedAffineModel3D)params.model.copy()).createAffineModel3D());
                }
            } else {
                models.add((InvertibleBoundable)params.model.copy());
            }
            if (params.silent) continue;
            IJ.log((String)("Tile " + t + " (NOT connected): " + models.get(models.size() - 1)));
        }
        if (!params.silent) {
            IJ.log((String)("average displacement: " + tc.getError() + " px"));
            IJ.log((String)("minimal displacement: " + tc.getMinError() + " px"));
            IJ.log((String)("maximal displacement: " + tc.getMaxError() + " px"));
            int numCorrespondences = 0;
            for (ComparePair pair : pairs) {
                numCorrespondences += pair.inliers.size();
            }
            IJ.log((String)("Total number of correspondending detection: " + numCorrespondences));
        }
        return models;
    }

    public static synchronized void addPointMatches(ArrayList<PointMatch> correspondences, Tile<?> tileA, Tile<?> tileB) {
        if (correspondences.size() > 0) {
            tileA.addMatches(correspondences);
            tileB.addMatches(PointMatch.flip(correspondences));
            tileA.addConnectedTile(tileB);
            tileB.addConnectedTile(tileA);
        }
    }

    protected static Vector<ComparePair> getComparePairs(DescriptorParameters params, int numImages) {
        Vector<ComparePair> pairs = new Vector<ComparePair>();
        if (params.globalOpt == 0) {
            for (int indexA = 0; indexA < numImages - 1; ++indexA) {
                for (int indexB = indexA + 1; indexB < numImages; ++indexB) {
                    pairs.add(new ComparePair(indexA, indexB, (Model<?>)params.model));
                }
            }
        } else if (params.globalOpt == 1) {
            for (int indexA = 0; indexA < numImages - 1; ++indexA) {
                for (int indexB = indexA + 1; indexB < numImages; ++indexB) {
                    if (Math.abs(indexB - indexA) > params.range) continue;
                    pairs.add(new ComparePair(indexA, indexB, (Model<?>)params.model));
                }
            }
        } else if (params.globalOpt == 2) {
            for (int indexA = 1; indexA < numImages; ++indexA) {
                pairs.add(new ComparePair(indexA, 0, (Model<?>)params.model));
            }
        } else {
            for (int indexA = 1; indexA < numImages; ++indexA) {
                pairs.add(new ComparePair(indexA, indexA - 1, (Model<?>)params.model));
            }
        }
        return pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Model<?> pairwiseMatching(ArrayList<PointMatch> finalInliers, ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks1, ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks2, float zStretching1, float zStretching2, DescriptorParameters params, String explanation) {
        Object particleB;
        String statement;
        ArrayList<PointMatch> candidates;
        SubsetMatcher matcher = new SubsetMatcher(params.numNeighbors, params.numNeighbors + params.redundancy);
        if (params.similarOrientation) {
            AbstractModel<?> identityTransform = params.getInitialModel();
            candidates = Matching.getCorrespondenceCandidates(params.significance, (Matcher)matcher, peaks1, peaks2, identityTransform, params.dimensionality, zStretching1, zStretching2, explanation);
            for (PointMatch pm : candidates) {
                ((Particle)pm.getP1()).restoreCoordinates();
                ((Particle)pm.getP2()).restoreCoordinates();
            }
        } else {
            candidates = Matching.getCorrespondenceCandidates(params.significance, (Matcher)matcher, peaks1, peaks2, null, params.dimensionality, zStretching1, zStretching2, explanation);
        }
        Model finalModel = params.model.copy();
        if (candidates.size() >= finalModel.getMinNumMatches()) {
            statement = Matching.computeRANSAC(candidates, finalInliers, finalModel, (float)params.ransacThreshold);
        } else {
            statement = "Not enough candidates " + candidates.size();
            finalInliers.clear();
        }
        if ((float)finalInliers.size() > (float)finalModel.getMinNumMatches() * DescriptorParameters.minInlierFactor) {
            boolean i = true;
            int previousNumInliers = 0;
            int numInliers = 0;
            do {
                candidates = Matching.getCorrespondenceCandidates(params.significance, (Matcher)matcher, peaks1, peaks2, finalModel, params.dimensionality, zStretching1, zStretching2, explanation);
                for (PointMatch pm : candidates) {
                    ((Particle)pm.getP1()).restoreCoordinates();
                    ((Particle)pm.getP2()).restoreCoordinates();
                }
                previousNumInliers = finalInliers.size();
                ArrayList<PointMatch> inliers = new ArrayList<PointMatch>();
                Model model2 = params.model.copy();
                String tmpStatement = Matching.computeRANSAC(candidates, inliers, model2, (float)params.ransacThreshold);
                numInliers = inliers.size();
                if (numInliers <= previousNumInliers) continue;
                finalModel = model2;
                finalInliers.clear();
                finalInliers.addAll(inliers);
                statement = tmpStatement;
            } while (numInliers > previousNumInliers);
        } else {
            if (!params.silent) {
                IJ.log((String)(explanation + ": " + statement + " - No inliers foundTipp: You could increase the number of neighbors, redundancy or use a model that has more degrees of freedom."));
            }
            finalInliers.clear();
            return null;
        }
        if (!params.silent) {
            IJ.log((String)(explanation + ": " + statement));
        }
        if (DescriptorParameters.printAllSimilarities) {
            for (PointMatch pm : finalInliers) {
                Particle particleA = (Particle)pm.getP1();
                particleB = (Particle)pm.getP2();
                IJ.log((String)(particleA.id + " <-> " + particleB.id));
            }
        }
        if (DescriptorParameters.correspondenceDirectory != null) {
            File dir = new File(DescriptorParameters.correspondenceDirectory);
            if (dir.exists()) {
                if (dir.isDirectory()) {
                    String ex2 = explanation.replaceAll("<->", "-");
                    File file = new File(DescriptorParameters.correspondenceDirectory, ex2 + ".txt");
                    particleB = outAll;
                    synchronized (particleB) {
                        Matching.writePoints(finalInliers, params, finalModel, outAll);
                    }
                    PrintWriter out = Matching.openFileWrite(file);
                    if (out == null) {
                        IJ.log((String)("Could not create file: " + file));
                    } else {
                        Matching.writePoints(finalInliers, params, finalModel, out);
                        out.close();
                    }
                } else {
                    IJ.log((String)("Directory(?) " + dir + " is NO directory, cannot write out correspondences."));
                }
            } else {
                IJ.log((String)("Directory " + dir + " does not exist, cannot write out correspondences."));
            }
        }
        return finalModel;
    }

    protected static void writePoints(ArrayList<PointMatch> finalInliers, DescriptorParameters params, Model<?> finalModel, PrintWriter out) {
        for (PointMatch pm : finalInliers) {
            Particle particleA = (Particle)pm.getP1();
            Particle particleB = (Particle)pm.getP2();
            particleA.apply((CoordinateTransform)finalModel);
            if (params.dimensionality == 3) {
                out.println(particleA.getW()[0] + "\t" + particleA.getW()[1] + "\t" + particleA.getW()[2] / (double)particleA.zStretching + "\t" + particleB.getW()[0] + "\t" + particleB.getW()[1] + "\t" + particleB.getW()[2] / (double)particleB.zStretching);
                continue;
            }
            out.println(particleA.getW()[0] + "\t" + particleA.getW()[1] + "\t" + particleB.getW()[0] + "\t" + particleB.getW()[1]);
        }
    }

    public static float[] computeMinMax(ImagePlus imp, int channel) {
        int size = imp.getWidth() * imp.getHeight();
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        IJ.log((String)("Computing min/max over " + imp.getNSlices() + " slices and " + imp.getNFrames() + " frames for channel " + channel));
        for (int z = 0; z < imp.getNSlices(); ++z) {
            for (int t = 0; t < imp.getNFrames(); ++t) {
                ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel, z + 1, t + 1));
                for (int i = 0; i < size; ++i) {
                    float f = ip.getf(i);
                    min = Math.min(min, f);
                    max = Math.max(max, f);
                }
            }
        }
        return new float[]{min, max};
    }

    public static ArrayList<DifferenceOfGaussianPeak<FloatType>> extractCandidates(ImagePlus imp, int channel, int timepoint, DescriptorParameters params, float[] minmax) {
        Image<FloatType> img = Matching.convertToFloat(imp, channel, timepoint, minmax);
        Calibration cal = imp.getCalibration();
        if (params.dimensionality == 2) {
            img.setCalibration(new float[]{(float)cal.pixelWidth, (float)cal.pixelHeight});
        } else {
            img.setCalibration(new float[]{(float)cal.pixelWidth, (float)cal.pixelHeight, (float)cal.pixelDepth});
        }
        ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks = Matching.computeDoG(img, (float)params.sigma1, (float)params.sigma2, params.lookForMaxima, params.lookForMinima, (float)params.threshold, params.localization, params.iterations, params.sigma, params.region);
        int[] stats1 = Matching.removeInvalidAndCollectStatistics(peaks);
        String statement = "Found " + peaks.size() + " candidates for " + imp.getTitle() + " [" + timepoint + "] (" + stats1[1] + " maxima, " + stats1[0] + " minima)";
        if (DescriptorParameters.brightestNPoints > 0) {
            ArrayList<PeakSort> sortList = new ArrayList<PeakSort>();
            for (DifferenceOfGaussianPeak<FloatType> peak : peaks) {
                sortList.add(new PeakSort(peak));
            }
            Collections.sort(sortList);
            peaks.clear();
            for (int i = sortList.size() - 1; i >= sortList.size() - DescriptorParameters.brightestNPoints && i >= 0; --i) {
                peaks.add(((PeakSort)sortList.get((int)i)).peak);
            }
            statement = statement + ", kept brightest " + peaks.size() + " peaks for matching.";
        }
        if (!params.silent) {
            IJ.log((String)statement);
        }
        return peaks;
    }

    public static Image<FloatType> convertToFloat(ImagePlus imp, int channel, int timepoint, float[] minmax) {
        Image img = imp.getNSlices() > 1 ? new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory()).createImage(new int[]{imp.getWidth(), imp.getHeight(), imp.getNSlices()}) : new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory()).createImage(new int[]{imp.getWidth(), imp.getHeight()});
        int sliceSize = imp.getWidth() * imp.getHeight();
        int z = 0;
        ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(++channel, z + 1, ++timepoint));
        if (ip instanceof FloatProcessor) {
            ArrayCursor cursor = (ArrayCursor)img.createCursor();
            float[] pixels = (float[])ip.getPixels();
            int i = 0;
            while (cursor.hasNext()) {
                if (i == sliceSize) {
                    pixels = (float[])imp.getStack().getProcessor(imp.getStackIndex(channel, ++z + 1, timepoint)).getPixels();
                    i = 0;
                }
                ((FloatType)cursor.next()).set(pixels[i++]);
            }
        } else if (ip instanceof ByteProcessor) {
            ArrayCursor cursor = (ArrayCursor)img.createCursor();
            byte[] pixels = (byte[])ip.getPixels();
            int i = 0;
            while (cursor.hasNext()) {
                if (i == sliceSize) {
                    pixels = (byte[])imp.getStack().getProcessor(imp.getStackIndex(channel, ++z + 1, timepoint)).getPixels();
                    i = 0;
                }
                ((FloatType)cursor.next()).set((float)(pixels[i++] & 0xFF));
            }
        } else if (ip instanceof ShortProcessor) {
            ArrayCursor cursor = (ArrayCursor)img.createCursor();
            short[] pixels = (short[])ip.getPixels();
            int i = 0;
            while (cursor.hasNext()) {
                if (i == sliceSize) {
                    pixels = (short[])imp.getStack().getProcessor(imp.getStackIndex(channel, ++z + 1, timepoint)).getPixels();
                    i = 0;
                }
                ((FloatType)cursor.next()).set((float)(pixels[i++] & 0xFFFF));
            }
        } else {
            LocalizableCursor cursor = img.createLocalizableCursor();
            int[] location = new int[img.getNumDimensions()];
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.getPosition(location);
                if (location[2] != z) {
                    z = location[2];
                    ip = imp.getStack().getProcessor(imp.getStackIndex(channel, z + 1, timepoint));
                }
                ((FloatType)cursor.getType()).set(ip.getPixelValue(location[0], location[1]));
            }
        }
        ViewDataBeads.normalizeImage((Image)img, (float[])minmax);
        return img;
    }

    protected static ArrayList<DifferenceOfGaussianPeak<FloatType>> filterForROI(Roi roi, ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks) {
        if (roi == null) {
            return peaks;
        }
        ArrayList<DifferenceOfGaussianPeak<FloatType>> peaksNew = new ArrayList<DifferenceOfGaussianPeak<FloatType>>();
        for (DifferenceOfGaussianPeak<FloatType> peak : peaks) {
            if (!roi.contains(Math.round(peak.getSubPixelPosition(0)), Math.round(peak.getSubPixelPosition(1)))) continue;
            peaksNew.add(peak);
        }
        return peaksNew;
    }

    protected static ArrayList<DifferenceOfGaussianPeak<FloatType>> filterForROI(Roi roi, ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks, Model<?> model) {
        if (roi == null) {
            return peaks;
        }
        ArrayList<DifferenceOfGaussianPeak<FloatType>> peaksNew = new ArrayList<DifferenceOfGaussianPeak<FloatType>>();
        int numDimensions = peaks.get(0).getSubPixelPosition().length;
        double[] tmp = new double[numDimensions];
        for (DifferenceOfGaussianPeak<FloatType> peak : peaks) {
            for (int d = 0; d < numDimensions; ++d) {
                tmp[d] = peak.getSubPixelPosition(d);
            }
            model.applyInPlace(tmp);
            if (!roi.contains((int)Math.round(tmp[0]), (int)Math.round(tmp[1]))) continue;
            peaksNew.add(peak);
        }
        return peaksNew;
    }

    protected static void setPointRois(ImagePlus imp1, ImagePlus imp2, ArrayList<PointMatch> inliers) {
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        PointMatch.sourcePoints(inliers, list1);
        PointMatch.targetPoints(inliers, list2);
        PointRoi sourcePoints = Util.pointsToPointRoi(list1);
        PointRoi targetPoints = Util.pointsToPointRoi(list2);
        imp1.setRoi((Roi)sourcePoints);
        imp2.setRoi((Roi)targetPoints);
    }

    protected static String computeRANSAC(ArrayList<PointMatch> candidates, ArrayList<PointMatch> inliers, Model<?> model, float maxEpsilon) {
        boolean modelFound = false;
        float minInlierRatio = DescriptorParameters.minInlierRatio;
        int numIterations = DescriptorParameters.ransacIterations;
        float maxTrust = DescriptorParameters.maxTrust;
        float minInlierFactor = DescriptorParameters.minInlierFactor;
        try {
            modelFound = DescriptorParameters.filterRANSAC ? model.filterRansac(candidates, inliers, numIterations, (double)maxEpsilon, (double)minInlierRatio, (double)maxTrust) : model.ransac(candidates, inliers, numIterations, (double)maxEpsilon, (double)minInlierRatio);
            if (modelFound && (float)inliers.size() > (float)model.getMinNumMatches() * minInlierFactor) {
                model.fit(inliers);
                return "Remaining inliers after RANSAC (" + model.getClass().getSimpleName() + "): " + inliers.size() + " of " + candidates.size() + " with average error " + model.getCost();
            }
            inliers.clear();
            return "NO Model found after RANSAC (" + model.getClass().getSimpleName() + ") of " + candidates.size();
        }
        catch (Exception e) {
            inliers.clear();
            return "Exception - NO Model found after RANSAC (" + model.getClass().getSimpleName() + ") of " + candidates.size();
        }
    }

    protected static ArrayList<PointMatch> getCorrespondenceCandidates(double nTimesBetter, Matcher matcher, ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks1, ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks2, Model<?> model, int dimensionality, float zStretching1, float zStretching2, String explanation) {
        ArrayList<AbstractPointDescriptor> descriptorsB;
        ArrayList<AbstractPointDescriptor> descriptorsA;
        if (peaks1.size() <= matcher.getRequiredNumNeighbors() || peaks2.size() <= matcher.getRequiredNumNeighbors()) {
            IJ.log((String)(explanation + ": Not enough peaks to perform a matching (at least " + matcher.getRequiredNumNeighbors() + " are required to build a descriptor)."));
            return new ArrayList<PointMatch>();
        }
        ArrayList<Particle> listA = new ArrayList<Particle>();
        ArrayList<Particle> listB = new ArrayList<Particle>();
        int id = 0;
        if (model == null) {
            for (DifferenceOfGaussianPeak<FloatType> peak : peaks1) {
                listA.add(new Particle(id++, peak, zStretching1));
            }
            for (DifferenceOfGaussianPeak<FloatType> peak : peaks2) {
                listB.add(new Particle(id++, peak, zStretching2));
            }
        } else {
            Particle particle;
            for (DifferenceOfGaussianPeak<FloatType> peak : peaks1) {
                particle = new Particle(id++, peak, zStretching1);
                particle.apply((CoordinateTransform)model);
                for (int d = 0; d < particle.getL().length; ++d) {
                    particle.getL()[d] = particle.getW()[d];
                }
                listA.add(particle);
            }
            for (DifferenceOfGaussianPeak<FloatType> peak : peaks2) {
                particle = new Particle(id++, peak, zStretching2);
                listB.add(particle);
            }
        }
        KDTree treeA = new KDTree(listA);
        KDTree treeB = new KDTree(listB);
        int numNeighbors = matcher.getRequiredNumNeighbors();
        SquareDistance similarityMeasure = new SquareDistance();
        if (model == null) {
            descriptorsA = Matching.createModelPointDescriptors((KDTree<Particle>)treeA, listA, numNeighbors, matcher, (SimilarityMeasure)similarityMeasure, dimensionality);
            descriptorsB = Matching.createModelPointDescriptors((KDTree<Particle>)treeB, listB, numNeighbors, matcher, (SimilarityMeasure)similarityMeasure, dimensionality);
        } else {
            descriptorsA = Matching.createSimplePointDescriptors((KDTree<Particle>)treeA, listA, numNeighbors, matcher, (SimilarityMeasure)similarityMeasure);
            descriptorsB = Matching.createSimplePointDescriptors((KDTree<Particle>)treeB, listB, numNeighbors, matcher, (SimilarityMeasure)similarityMeasure);
        }
        ArrayList<PointMatch> correspondenceCandidates = Matching.findCorrespondingDescriptors(descriptorsA, descriptorsB, (float)nTimesBetter);
        return correspondenceCandidates;
    }

    protected static final ArrayList<PointMatch> findCorrespondingDescriptors(ArrayList<AbstractPointDescriptor> descriptorsA, ArrayList<AbstractPointDescriptor> descriptorsB, float nTimesBetter) {
        ArrayList<PointMatch> correspondenceCandidates = new ArrayList<PointMatch>();
        for (AbstractPointDescriptor descriptorA : descriptorsA) {
            double bestDifference = Double.MAX_VALUE;
            double secondBestDifference = Double.MAX_VALUE;
            AbstractPointDescriptor bestMatch = null;
            AbstractPointDescriptor secondBestMatch = null;
            for (AbstractPointDescriptor descriptorB : descriptorsB) {
                double difference = descriptorA.descriptorDistance(descriptorB);
                if (!(difference < secondBestDifference)) continue;
                secondBestDifference = difference;
                secondBestMatch = descriptorB;
                if (!(secondBestDifference < bestDifference)) continue;
                double tmpDiff = secondBestDifference;
                AbstractPointDescriptor tmpMatch = secondBestMatch;
                secondBestDifference = bestDifference;
                secondBestMatch = bestMatch;
                bestDifference = tmpDiff;
                bestMatch = tmpMatch;
            }
            if (!(bestDifference < DescriptorParameters.minSimilarity) || !(bestDifference * (double)nTimesBetter < secondBestDifference)) continue;
            Particle particleA = (Particle)descriptorA.getBasisPoint();
            Particle particleB = (Particle)bestMatch.getBasisPoint();
            correspondenceCandidates.add(new PointMatch((Point)particleA, (Point)particleB));
            if (!DescriptorParameters.printAllSimilarities) continue;
            IJ.log((String)(particleA.id + " <-> " + particleB.id + " = " + bestDifference));
        }
        return correspondenceCandidates;
    }

    protected static ArrayList<AbstractPointDescriptor> createSimplePointDescriptors(KDTree<Particle> tree, ArrayList<Particle> basisPoints, int numNeighbors, Matcher matcher, SimilarityMeasure similarityMeasure) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<AbstractPointDescriptor> descriptors = new ArrayList<AbstractPointDescriptor>();
        for (Particle p : basisPoints) {
            ArrayList<Particle> neighbors = new ArrayList<Particle>();
            Particle[] neighborList = (Particle[])nnsearch.findNNearestNeighbors((Leaf)p, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n]);
            }
            try {
                descriptors.add((AbstractPointDescriptor)new SimplePointDescriptor((Point)p, neighbors, similarityMeasure, matcher));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }

    protected static ArrayList<AbstractPointDescriptor> createModelPointDescriptors(KDTree<Particle> tree, ArrayList<Particle> basisPoints, int numNeighbors, Matcher matcher, SimilarityMeasure similarityMeasure, int dimensionality) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<AbstractPointDescriptor> descriptors = new ArrayList<AbstractPointDescriptor>();
        for (Particle p : basisPoints) {
            TranslationInvariantRigidModel2D model;
            ArrayList<Particle> neighbors = new ArrayList<Particle>();
            Particle[] neighborList = (Particle[])nnsearch.findNNearestNeighbors((Leaf)p, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n]);
            }
            if (dimensionality == 2) {
                model = new TranslationInvariantRigidModel2D();
            } else if (dimensionality == 3) {
                model = new TranslationInvariantRigidModel3D();
            } else {
                IJ.log((String)("dimensionality " + dimensionality + " not supported."));
                return descriptors;
            }
            try {
                descriptors.add((AbstractPointDescriptor)new ModelPointDescriptor((Point)p, neighbors, (TranslationInvariantModel)model, similarityMeasure, matcher));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }

    protected static ArrayList<DifferenceOfGaussianPeak<FloatType>> computeDoG(Image<FloatType> image, float sigma1, float sigma2, boolean lookForMaxima, boolean lookForMinima, float threshold, int localization, int iterations, double[] sigmaGuess, int[] region) {
        return DetectionSegmentation.extractBeadsLaPlaceImgLib(image, (OutOfBoundsStrategyFactory<FloatType>)new OutOfBoundsStrategyMirrorFactory(), 0.5f, sigma1, sigma2, threshold, threshold / 4.0f, lookForMaxima, lookForMinima, localization, iterations, sigmaGuess, region, 1);
    }

    private static PrintWriter openFileWrite(File file) {
        PrintWriter outputFile;
        try {
            outputFile = new PrintWriter(new FileWriter(file));
        }
        catch (IOException e) {
            System.out.println("TextFileAccess.openFileWrite(): " + e);
            outputFile = null;
        }
        return outputFile;
    }

    protected static int[] removeInvalidAndCollectStatistics(ArrayList<DifferenceOfGaussianPeak<FloatType>> peaks) {
        int min = 0;
        int max = 0;
        for (int i = peaks.size() - 1; i >= 0; --i) {
            DifferenceOfGaussianPeak<FloatType> peak = peaks.get(i);
            if (!peak.isValid()) {
                peaks.remove(i);
                continue;
            }
            if (peak.getPeakType() == DifferenceOfGaussian.SpecialPoint.MIN) {
                ++min;
                continue;
            }
            if (peak.getPeakType() != DifferenceOfGaussian.SpecialPoint.MAX) continue;
            ++max;
        }
        return new int[]{min, max};
    }

    public static void main(String[] args) throws NotEnoughDataPointsException {
        Point p1 = new Point(new double[]{10.0, 20.0});
        Point p2 = new Point(new double[]{100.0, 200.0});
        TranslationModel2D m = new TranslationModel2D();
        ArrayList<PointMatch> list = new ArrayList<PointMatch>();
        list.add(new PointMatch(p1, p2));
        m.fit(list);
        System.out.println(m);
        p1.apply((CoordinateTransform)m);
        System.out.println(net.imglib2.util.Util.printCoordinates((double[])p1.getL()));
        System.out.println(net.imglib2.util.Util.printCoordinates((double[])p1.getW()));
        System.out.println(net.imglib2.util.Util.printCoordinates((double[])p2.getL()));
        System.out.println(net.imglib2.util.Util.printCoordinates((double[])p2.getW()));
    }

    public static class PeakSort
    implements Comparable<PeakSort> {
        final DifferenceOfGaussianPeak<FloatType> peak;

        public PeakSort(DifferenceOfGaussianPeak<FloatType> peak) {
            this.peak = peak;
        }

        @Override
        public int compareTo(PeakSort o) {
            float diff = Math.abs(((FloatType)this.peak.getValue()).get()) - Math.abs(((FloatType)o.peak.getValue()).get());
            if (diff < 0.0f) {
                return -1;
            }
            if (diff > 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

