/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math;

import java.util.List;
import net.imglib2.Interval;
import net.imglib2.KDTree;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.math.Add;
import net.imglib2.algorithm.math.AndLogical;
import net.imglib2.algorithm.math.BlockReadSource;
import net.imglib2.algorithm.math.Compute;
import net.imglib2.algorithm.math.Div;
import net.imglib2.algorithm.math.Else;
import net.imglib2.algorithm.math.Equal;
import net.imglib2.algorithm.math.Exp;
import net.imglib2.algorithm.math.GreaterThan;
import net.imglib2.algorithm.math.If;
import net.imglib2.algorithm.math.ImgSource;
import net.imglib2.algorithm.math.KDTreeSource;
import net.imglib2.algorithm.math.LessThan;
import net.imglib2.algorithm.math.Let;
import net.imglib2.algorithm.math.Log;
import net.imglib2.algorithm.math.Max;
import net.imglib2.algorithm.math.Min;
import net.imglib2.algorithm.math.Minus;
import net.imglib2.algorithm.math.Mul;
import net.imglib2.algorithm.math.NotEqual;
import net.imglib2.algorithm.math.NotLogical;
import net.imglib2.algorithm.math.NumberSource;
import net.imglib2.algorithm.math.OffsetSource;
import net.imglib2.algorithm.math.OrLogical;
import net.imglib2.algorithm.math.Pow;
import net.imglib2.algorithm.math.RandomAccessibleSource;
import net.imglib2.algorithm.math.Sub;
import net.imglib2.algorithm.math.Then;
import net.imglib2.algorithm.math.Var;
import net.imglib2.algorithm.math.XorLogical;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.Util;
import net.imglib2.algorithm.math.abstractions.ViewableFunction;
import net.imglib2.converter.Converter;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class ImgMath {
    public static final Compute compute(IFunction operation) {
        return new Compute(operation);
    }

    public static final <I extends RealType<I>> Compute compute(RandomAccessibleInterval<I> src) {
        return ImgMath.compute(ImgMath.img(src));
    }

    public static final RandomAccessibleInterval<FloatType> computeIntoFloats(IFunction operation) {
        return new Compute(operation).into(new ArrayImgFactory<FloatType>(new FloatType()).create(Util.findImg(operation).iterator().next()));
    }

    public static final <O extends RealType<O>> RandomAccessibleInterval<O> computeInto(IFunction operation, RandomAccessibleInterval<O> target) {
        return new Compute(operation).into(target);
    }

    public static final <O extends RealType<O>> RandomAccessibleInterval<O> computeInto(IFunction operation, RandomAccessibleInterval<O> target, Converter<RealType<?>, O> converter) {
        return new Compute(operation).into(target, converter);
    }

    public static final <O extends NativeType<O> & RealType<O>> RandomAccessibleInterval<O> computeIntoImg(IFunction operation) {
        return ImgMath.compute(operation).intoImg();
    }

    public static final <O extends NativeType<O> & RealType<O>> RandomAccessibleInterval<O> computeIntoArrayImg(IFunction operation) {
        return ImgMath.compute(operation).intoArrayImg();
    }

    public static final <O extends RealType<O>> RandomAccessibleInterval<O> view(ViewableFunction operation) {
        return operation.view();
    }

    public static final RandomAccessibleInterval<FloatType> viewFloats(ViewableFunction operation) {
        return operation.view(new FloatType());
    }

    public static final Add add(Object o1, Object o2) {
        return new Add(o1, o2);
    }

    public static final Add add(Object ... obs) {
        return new Add(obs);
    }

    public static final Sub sub(Object o1, Object o2) {
        return new Sub(o1, o2);
    }

    public static final Sub sub(Object ... obs) {
        return new Sub(obs);
    }

    public static final Minus minus(Object o1) {
        return new Minus(o1);
    }

    public static final Mul mul(Object o1, Object o2) {
        return new Mul(o1, o2);
    }

    public static final Mul mul(Object ... obs) {
        return new Mul(obs);
    }

    public static final Div div(Object o1, Object o2) {
        return new Div(o1, o2);
    }

    public static final Div div(Object ... obs) {
        return new Div(obs);
    }

    public static final Pow pow(Object o1, Object o2) {
        return new Pow(o1, o2);
    }

    public static final Pow power(Object o1, Object o2) {
        return new Pow(o1, o2);
    }

    public static final Max max(Object o1, Object o2) {
        return new Max(o1, o2);
    }

    public static final Max max(Object ... obs) {
        return new Max(obs);
    }

    public static final Max maximum(Object o1, Object o2) {
        return new Max(o1, o2);
    }

    public static final Max maximum(Object ... obs) {
        return new Max(obs);
    }

    public static final Min min(Object o1, Object o2) {
        return new Min(o1, o2);
    }

    public static final Min min(Object ... obs) {
        return new Min(obs);
    }

    public static final Min minimum(Object o1, Object o2) {
        return new Min(o1, o2);
    }

    public static final Min minimum(Object ... obs) {
        return new Min(obs);
    }

    public static final Log log(Object o1) {
        return new Log(o1);
    }

    public static final Log logarithm(Object o1) {
        return new Log(o1);
    }

    public static final Exp exp(Object o1) {
        return new Exp(o1);
    }

    public static final Let let(String varName, Object varValue, Object body) {
        return new Let(varName, varValue, body);
    }

    public static final Let let(Object[] pairs, Object body) {
        return new Let(pairs, body);
    }

    public static final Let let(Object ... obs) {
        return new Let(obs);
    }

    public static final Var var(String name) {
        return new Var(name);
    }

    public static final Equal EQ(Object o1, Object o2) {
        return new Equal(o1, o2);
    }

    public static final Equal equal(Object o1, Object o2) {
        return new Equal(o1, o2);
    }

    public static final NotEqual NEQ(Object o1, Object o2) {
        return new NotEqual(o1, o2);
    }

    public static final NotEqual notEqual(Object o1, Object o2) {
        return new NotEqual(o1, o2);
    }

    public static final LessThan LT(Object o1, Object o2) {
        return new LessThan(o1, o2);
    }

    public static final LessThan lessThan(Object o1, Object o2) {
        return new LessThan(o1, o2);
    }

    public static final GreaterThan GT(Object o1, Object o2) {
        return new GreaterThan(o1, o2);
    }

    public static final GreaterThan greaterThan(Object o1, Object o2) {
        return new GreaterThan(o1, o2);
    }

    public static final If IF(Object o1, Object o2, Object o3) {
        return new If(o1, o2, o3);
    }

    public static final Then THEN(Object o) {
        return new Then(o);
    }

    public static final Else ELSE(Object o) {
        return new Else(o);
    }

    public static final AndLogical AND(Object o1, Object o2) {
        return new AndLogical(o1, o2);
    }

    public static final AndLogical AND(Object ... o) {
        return new AndLogical(o);
    }

    public static final OrLogical OR(Object o1, Object o2) {
        return new OrLogical(o1, o2);
    }

    public static final OrLogical OR(Object ... o) {
        return new OrLogical(o);
    }

    public static final XorLogical XOR(Object o1, Object o2) {
        return new XorLogical(o1, o2);
    }

    public static final XorLogical XOR(Object ... o) {
        return new XorLogical(o);
    }

    public static final NotLogical NOT(Object o) {
        return new NotLogical(o);
    }

    public static final <T extends RealType<T>> ImgSource<T> img(RandomAccessibleInterval<T> rai) {
        return new ImgSource<T>(rai);
    }

    public static final <T extends RealType<T>> ImgSource<T> intervalSource(RandomAccessibleInterval<T> rai) {
        return new ImgSource<T>(rai);
    }

    public static final NumberSource number(Number number) {
        return new NumberSource(number);
    }

    public static final <T extends RealType<T>> BlockReadSource<T> block(RandomAccessible<T> src, long[] radius) {
        return new BlockReadSource<T>(src, radius);
    }

    public static final <T extends RealType<T>> BlockReadSource<T> block(RandomAccessible<T> src, long radius) {
        return new BlockReadSource<T>(src, radius);
    }

    public static final <T extends RealType<T>> BlockReadSource<T> block(RandomAccessible<T> src, long[][] corners) {
        return new BlockReadSource<T>(src, corners);
    }

    public static final <T extends RealType<T>> RandomAccessibleSource<T> offset(RandomAccessible<T> src, long[] offset) {
        return new RandomAccessibleSource<T>(src, offset);
    }

    public static final <T extends RealType<T>> OffsetSource<T> offset(IFunction f, long[] offset) {
        return new OffsetSource(f, offset);
    }

    public static final <T extends RealType<T>> IFunction source(RandomAccessible<T> src) {
        if (src instanceof RandomAccessibleInterval) {
            return ImgMath.intervalSource((RandomAccessibleInterval)src);
        }
        return new RandomAccessibleSource<T>(src);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(List<Point> positions, T value, double radius) {
        return new KDTreeSource<T>(positions, value, radius);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(List<Point> positions, T value, double radius, Object outside) {
        return new KDTreeSource<T>(positions, value, radius, outside);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(List<Point> positions, T value, double radius, Object outside, Interval interval) {
        return new KDTreeSource<T>(positions, value, radius, outside, interval);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(List<Point> positions, List<T> values, double radius) {
        return new KDTreeSource<T>(positions, values, radius);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(List<Point> positions, List<T> values, double radius, Object outside) {
        return new KDTreeSource<T>(positions, values, radius, outside);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(List<Point> positions, List<T> values, double radius, Object outside, Interval interval) {
        return new KDTreeSource<T>(positions, values, radius, outside, interval);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(KDTree<T> kdtree, double radius) {
        return new KDTreeSource<T>(kdtree, radius);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(KDTree<T> kdtree, double radius, Object outside) {
        return new KDTreeSource<T>(kdtree, radius, outside);
    }

    public static final <T extends RealType<T>> KDTreeSource<T> gen(KDTree<T> kdtree, double radius, Object outside, Interval interval) {
        return new KDTreeSource<T>(kdtree, radius, outside, interval);
    }
}

