/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.File;
import marchingcubes.ExportMesh_;
import util.BatchOpener;

public class Meshes_From_Label_File
implements PlugIn {
    public void run(String ignore) {
        String macroOptions = Macro.getOptions();
        String sourceFilename = null;
        String outputDirectory = null;
        if (macroOptions == null) {
            IJ.error((String)"Currently this can only be called as macro with options.");
            return;
        }
        sourceFilename = Macro.getValue((String)macroOptions, (String)"source", null);
        if (sourceFilename == null) {
            IJ.error((String)"No source filename specified. (Macro option 'source'.)");
            return;
        }
        outputDirectory = Macro.getValue((String)macroOptions, (String)"output", null);
        if (outputDirectory == null) {
            IJ.error((String)"No output directory specified. (Macro option 'output'.)");
            return;
        }
        File outputDirectoryAsFile = new File(outputDirectory);
        if (!outputDirectoryAsFile.exists() || !outputDirectoryAsFile.isDirectory()) {
            IJ.error((String)("The output (" + outputDirectory + ") must both exist and be a directory. "));
            return;
        }
        ImagePlus imagePlus = BatchOpener.openFirstChannel((String)sourceFilename);
        if (imagePlus == null) {
            IJ.error((String)("File not found: " + sourceFilename));
            return;
        }
        int type = imagePlus.getType();
        if (type != 0 && type != 3) {
            IJ.error((String)("Something's wrong: '" + sourceFilename + "' doesn't seem to be an 8 bit file."));
            return;
        }
        String[] materialList = null;
        AmiraParameters parameters = null;
        if (!AmiraParameters.isAmiraLabelfield((ImagePlus)imagePlus)) {
            IJ.error((String)("The file '" + sourceFilename + "' isn't an Amira labelfield!"));
            return;
        }
        parameters = new AmiraParameters(imagePlus);
        materialList = parameters.getMaterialList();
        int width = imagePlus.getWidth();
        int height = imagePlus.getHeight();
        int depth = imagePlus.getStackSize();
        for (int m = 1; m < materialList.length; ++m) {
            double[] c = parameters.getMaterialColor(m);
            String materialName = materialList[m];
            ImageStack newStack = new ImageStack(width, height);
            ImageStack stack = imagePlus.getStack();
            for (int z = 0; z < depth; ++z) {
                byte[] newPixels = new byte[width * height];
                byte[] pixels = (byte[])stack.getPixels(z + 1);
                for (int p = 0; p < width * height; ++p) {
                    int value = pixels[p] & 0xFF;
                    if (value != m) continue;
                    newPixels[p] = -1;
                }
                ByteProcessor bp = new ByteProcessor(width, height);
                bp.setPixels((Object)newPixels);
                newStack.addSlice("", (ImageProcessor)bp);
            }
            ImagePlus newImagePlus = new ImagePlus("", newStack);
            ExportMesh_ exporter = new ExportMesh_();
            boolean[] channels = new boolean[]{true, true, true};
            String outputFilename = outputDirectory + File.separator + c[0] + "_" + c[1] + "_" + c[2] + "_" + materialName + ".obj";
            exporter.exportToMesh(newImagePlus, 128, 2, channels, outputFilename);
            newImagePlus.close();
        }
    }
}

