/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Panel;
import java.io.File;
import util.BatchOpener;
import vib.app.FileGroup;
import vib.app.gui.FileGroupDialog;

public class Average_Images
implements PlugIn {
    float[][] cumulativeImage;
    int width;
    int height;
    int depth;
    int numberOfImages;
    float maxValue;

    public Average_Images() {
        this.reset();
    }

    public void reset() {
        this.cumulativeImage = null;
        this.width = -1;
        this.height = -1;
        this.depth = -1;
        this.numberOfImages = 0;
        this.maxValue = Float.MIN_VALUE;
    }

    public boolean add(ImagePlus imagePlus) {
        if (imagePlus.getBitDepth() != 8) {
            IJ.error((String)("All images must be 8 bit " + imagePlus + " doesn't."));
            return false;
        }
        int newWidth = imagePlus.getWidth();
        int newHeight = imagePlus.getHeight();
        int newDepth = imagePlus.getStackSize();
        if (this.width < 0) {
            this.width = newWidth;
            this.height = newHeight;
            this.depth = newDepth;
            this.cumulativeImage = new float[this.depth][];
            for (int z = 0; z < this.depth; ++z) {
                this.cumulativeImage[z] = new float[this.width * this.height];
            }
        } else if (this.width != newWidth || this.height != newHeight || this.depth != newDepth) {
            IJ.error((String)("Dimensions of " + imagePlus + " didn't match."));
            return false;
        }
        ImageStack stack = imagePlus.getStack();
        for (int z = 0; z < this.depth; ++z) {
            byte[] pixels = (byte[])stack.getPixels(z + 1);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    float[] fArray = this.cumulativeImage[z];
                    int n = y * this.width + x;
                    fArray[n] = fArray[n] + (float)(pixels[y * this.width + x] & 0xFF);
                    float newValue = this.cumulativeImage[z][y * this.width + x];
                    if (!(newValue > this.maxValue)) continue;
                    this.maxValue = newValue;
                }
            }
        }
        ++this.numberOfImages;
        return true;
    }

    public ImagePlus getAverageImage(boolean rescale) {
        IJ.showStatus((String)"Creating averaged image...");
        IJ.showProgress((double)0.0);
        ImageStack newStack = new ImageStack(this.width, this.height);
        for (int z = 0; z < this.depth; ++z) {
            ByteProcessor bp = new ByteProcessor(this.width, this.height);
            byte[] slice = new byte[this.width * this.height];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    float value = this.cumulativeImage[z][y * this.width + x];
                    int averageValue = rescale ? (int)(255.0f * value / (this.maxValue * (float)this.numberOfImages)) : (int)(value / (float)this.numberOfImages);
                    if (averageValue < 0) {
                        averageValue = 0;
                    }
                    if (averageValue > 255) {
                        averageValue = 255;
                    }
                    slice[y * this.width + x] = (byte)averageValue;
                }
            }
            IJ.showProgress((double)(((double)z + 1.0) / (double)this.depth));
            bp.setPixels((Object)slice);
            newStack.addSlice(null, (ImageProcessor)bp);
        }
        IJ.showProgress((double)1.0);
        return new ImagePlus("average of " + this.numberOfImages + " images", newStack);
    }

    public void run(String ignored) {
        File firstFile;
        String path;
        ImagePlus[] firstChannels;
        GenericDialog gd = new GenericDialog("Average Images");
        FileGroup fg = new FileGroup("foo");
        FileGroupDialog fgd = new FileGroupDialog(fg, false);
        gd.addPanel((Panel)fgd);
        gd.addNumericField("Index of channels to use (starting at 1): ", 1.0, 0);
        gd.addCheckbox("Rescale maximum to 255?", true);
        int channelToUse = (int)gd.getNextNumber();
        --channelToUse;
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean rescale = gd.getNextBoolean();
        int n = fg.size();
        if (n < 1) {
            IJ.error((String)"No image files selected");
        }
        if ((firstChannels = BatchOpener.open((String)(path = (firstFile = (File)fg.get(0)).getAbsolutePath()))) == null) {
            IJ.error((String)("Couldn't open " + firstFile));
            return;
        }
        if (channelToUse < 0 || channelToUse >= firstChannels.length) {
            IJ.error((String)("The image " + path + " doesn't have a channel " + channelToUse));
            return;
        }
        ImagePlus sourceImage = firstChannels[channelToUse];
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                File f = (File)fg.get(i);
                path = f.getAbsolutePath();
                ImagePlus[] channels = BatchOpener.open((String)path);
                if (channels == null) {
                    IJ.error((String)("Couldn't open the file " + path));
                    return;
                }
                if (channelToUse < 0 || channelToUse >= channels.length) {
                    IJ.error((String)("The image " + path + " doesn't have a channel " + channelToUse));
                    return;
                }
                sourceImage = channels[channelToUse];
            }
            if (this.add(sourceImage)) continue;
            return;
        }
        ImagePlus newImagePlus = this.getAverageImage(rescale);
        newImagePlus.show();
    }
}

