/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import vib.NaiveResampler;
import vib.app.module.Label;
import vib.app.module.Module;
import vib.app.module.State;

public class ResampleLabels
extends Module {
    @Override
    public String getName() {
        return "ResampleLabels";
    }

    @Override
    protected String getMessage() {
        return "Resampling label";
    }

    @Override
    protected void run(State state, int index) {
        if (index < 0) {
            new Label().runOnAllImagesAndTemplate(state);
        }
        this.prereqsDone(state, index);
        if (state.options.resamplingFactor == 1) {
            return;
        }
        String labelPath = state.getImagePath(-1, index);
        String resampledPath = state.getResampledPath(-1, index);
        if (State.upToDate(labelPath, resampledPath)) {
            return;
        }
        ImagePlus image = state.getImage(labelPath);
        ImagePlus resampled = NaiveResampler.resample(image, state.options.resamplingFactor);
        if (!state.save(resampled, resampledPath)) {
            throw new RuntimeException("Could not save " + resampledPath);
        }
    }
}

