/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.node;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.network.node.NodeParametersFactory;
import edu.utexas.clm.archipelago.network.shell.DummyNodeShell;
import edu.utexas.clm.archipelago.network.shell.NodeShell;
import edu.utexas.clm.archipelago.network.shell.NodeShellParameters;

public class NodeParameters {
    private String host;
    private String user;
    private String fileRoot;
    private String execRoot;
    private final long id;
    private int numThreads;
    private NodeShell shell;
    private NodeShellParameters shellParams;
    private final NodeParametersFactory factory;

    public NodeParameters(NodeParameters np) {
        this.id = FijiArchipelago.getUniqueID();
        this.user = np.getUser();
        this.host = np.getHost();
        this.shell = np.getShell();
        this.execRoot = np.getExecRoot();
        this.fileRoot = np.getFileRoot();
        this.numThreads = np.getThreadLimit();
        this.shellParams = new NodeShellParameters(np.shellParams);
        this.factory = np.getFactory();
    }

    public NodeParameters(String userIn, String hostIn, NodeShell shellIn, String execPath, String filePath, NodeParametersFactory factory) {
        this(userIn, hostIn, shellIn, execPath, filePath, factory, FijiArchipelago.getUniqueID());
    }

    public NodeParameters(String userIn, String hostIn, NodeShell shellIn, String execPath, String filePath, NodeParametersFactory factory, long id) {
        this.user = userIn;
        this.host = hostIn;
        this.shell = shellIn;
        this.execRoot = execPath;
        this.fileRoot = filePath;
        this.id = id;
        this.factory = factory;
        this.shellParams = shellIn.defaultParameters();
        this.numThreads = 0;
    }

    public synchronized void setUser(String user) {
        this.user = user;
    }

    public synchronized void setHost(String host) {
        this.host = host;
    }

    public synchronized void setShell(NodeShell shell, NodeShellParameters params) {
        this.shell = shell;
        this.setShellParams(params);
    }

    public synchronized void setShell(String className) {
        this.shell = Cluster.getNodeShell(className);
    }

    public synchronized void setExecRoot(String execRoot) {
        this.execRoot = execRoot;
    }

    public synchronized void setFileRoot(String fileRoot) {
        this.fileRoot = fileRoot;
    }

    public synchronized void setShellParams(NodeShellParameters shellParams) {
        this.shellParams = shellParams;
    }

    public synchronized void setThreadLimit(int numThreads) {
        this.numThreads = numThreads;
    }

    public synchronized void merge(NodeParameters params) {
        if (!params.getHost().equals(this.host)) {
            this.host = "";
        }
        if (!params.getUser().equals(this.user)) {
            this.user = "";
        }
        if (!params.getFileRoot().equals(this.fileRoot)) {
            this.fileRoot = "";
        }
        if (!params.getExecRoot().equals(this.execRoot)) {
            this.execRoot = "";
        }
        if (params.getThreadLimit() != this.numThreads) {
            this.numThreads = 0;
        }
        if (!params.getShell().name().equals(this.shell.name())) {
            this.shell = new DummyNodeShell();
        } else {
            this.shellParams.merge(params.getShellParams());
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public NodeShell getShell() {
        return this.shell;
    }

    public NodeShellParameters getShellParams() {
        return this.shellParams;
    }

    public String getExecRoot() {
        return this.execRoot;
    }

    public String getFileRoot() {
        return this.fileRoot;
    }

    public long getID() {
        return this.id;
    }

    public int getThreadLimit() {
        return this.numThreads;
    }

    public NodeParametersFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return this.user + "@" + this.host + " id: " + this.id + " " + this.shell.paramToString(this.shellParams);
    }
}

