/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.ControlWindow;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Mode;
import ini.trakem2.display.Paintable;
import ini.trakem2.display.TransformationStep;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.display.graphics.GraphicsSource;
import ini.trakem2.utils.History;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;

public class AffineTransformMode
implements Mode {
    private final Display display;
    private final History history;
    private final ATGS atgs = new ATGS();
    private final int iNW = 0;
    private final int iN = 1;
    private final int iNE = 2;
    private final int iE = 3;
    private final int iSE = 4;
    private final int iS = 5;
    private final int iSW = 6;
    private final int iW = 7;
    private final int ROTATION = 12;
    private final int FLOATER = 13;
    private final Handle NW = new BoxHandle(0, 0, 0);
    private final Handle N = new BoxHandle(0, 0, 1);
    private final Handle NE = new BoxHandle(0, 0, 2);
    private final Handle E = new BoxHandle(0, 0, 3);
    private final Handle SE = new BoxHandle(0, 0, 4);
    private final Handle S = new BoxHandle(0, 0, 5);
    private final Handle SW = new BoxHandle(0, 0, 6);
    private final Handle W = new BoxHandle(0, 0, 7);
    private final Handle RO = new RotationHandle(0, 0, 12);
    private final Floater floater = new Floater(0, 0, 13);
    private final Handle[] handles;
    private Handle grabbed = null;
    private boolean dragging = false;
    private boolean rotating = false;
    private boolean mouse_dragged = false;
    private Rectangle box;
    private int x_d_old;
    private int y_d_old;
    private int x_d;
    private int y_d;
    private AffineTransform accum_affine = null;
    private ArrayList<AffinePoint> affine_handles = null;
    private ArrayList<PointMatch> matches = null;
    private Point[] p = null;
    private Point[] q = null;
    private AbstractAffineModel2D<?> model = null;
    private AffineTransform free_affine = null;
    private HashMap<Displayable, AffineTransform> initial_affines = null;
    private AffinePoint affp = null;

    public AffineTransformMode(Display display) {
        this.display = display;
        ProjectToolbar.setTool(10);
        this.resetBox();
        this.floater.center();
        this.handles = new Handle[]{this.NW, this.N, this.NE, this.E, this.SE, this.S, this.SW, this.W, this.RO, this.floater};
        this.accum_affine = new AffineTransform();
        this.history = new History();
        this.history.add(new TransformationStep(this.getTransformationsCopy()));
        display.getCanvas().repaint(false);
    }

    private HashMap<Displayable, AffineTransform> getTransformationsCopy() {
        HashMap<Displayable, AffineTransform> ht_copy = new HashMap<Displayable, AffineTransform>();
        for (Displayable d : this.display.getSelection().getAffected()) {
            ht_copy.put(d, d.getAffineTransformCopy());
        }
        return ht_copy;
    }

    private void addUndoStep() {
        if (this.mouse_dragged || this.display.getSelection().isEmpty()) {
            return;
        }
        if (null == this.history) {
            return;
        }
        if (this.history.indexAtStart() || this.history.indexAtEnd() && -1 != this.history.index()) {
            this.history.add(new TransformationStep(this.getTransformationsCopy()));
        } else {
            this.history.clip();
        }
    }

    @Override
    public synchronized void undoOneStep() {
        if (null == this.history) {
            return;
        }
        Utils.log2("index at end: " + this.history.indexAtEnd());
        Map.Entry<Displayable, AffineTransform> Be = ((TransformationStep)this.history.getCurrent()).ht.entrySet().iterator().next();
        if (this.history.indexAtEnd()) {
            HashMap<Displayable, AffineTransform> m = this.getTransformationsCopy();
            this.history.append(new TransformationStep(m));
            Be = m.entrySet().iterator().next();
        }
        this.accum_affine = null;
        TransformationStep step = (TransformationStep)this.history.undoOneStep();
        if (null == step) {
            return;
        }
        LayerSet.applyTransforms(step.ht);
        this.resetBox();
        try {
            AffineTransform A = step.ht.get(Be.getKey());
            AffineTransform C = new AffineTransform(Be.getValue());
            C.concatenate(A.createInverse());
            this.fixAffinePoints(C);
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    @Override
    public synchronized void redoOneStep() {
        if (null == this.history) {
            return;
        }
        Map.Entry<Displayable, AffineTransform> Ae = ((TransformationStep)this.history.getCurrent()).ht.entrySet().iterator().next();
        TransformationStep step = (TransformationStep)this.history.redoOneStep();
        if (null == step) {
            return;
        }
        LayerSet.applyTransforms(step.ht);
        this.resetBox();
        AffineTransform B = step.ht.get(Ae.getKey());
        AffineTransform C = new AffineTransform(Ae.getValue());
        try {
            C.concatenate(B.createInverse());
            this.fixAffinePoints(C);
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public GraphicsSource getGraphicsSource() {
        return this.atgs;
    }

    @Override
    public boolean canChangeLayer() {
        return false;
    }

    @Override
    public boolean canZoom() {
        return true;
    }

    @Override
    public boolean canPan() {
        return true;
    }

    private final double rotate(MouseEvent me) {
        double cos = Utils.getCos(this.x_d_old - this.floater.x, this.y_d_old - this.floater.y, this.x_d - this.floater.x, this.y_d - this.floater.y);
        double delta = Math.acos(cos);
        if (Utils.isControlDown(me)) {
            delta = Math.toDegrees(delta);
            delta = me.isShiftDown() ? (double)((int)(delta + 0.5)) : (double)((int)((delta + 5.5 * (double)(delta < 0.0 ? -1 : 1)) / 10.0) * 10);
            Utils.showStatus("Angle: " + delta + " degrees");
            delta = Math.toRadians(delta);
        }
        if (Double.isNaN(delta)) {
            Utils.log2("Selection rotation handle: ignoring NaN angle");
            return Double.NaN;
        }
        double zc = (this.x_d_old - this.floater.x) * (this.y_d - this.floater.y) - (this.x_d - this.floater.x) * (this.y_d_old - this.floater.y);
        if (zc < 0.0) {
            delta = -delta;
        }
        this.rotate(Math.toDegrees(delta), this.floater.x, this.floater.y);
        return delta;
    }

    public void centerFloater() {
        this.floater.center();
    }

    public void setFloater(int x, int y) {
        this.floater.x = x;
        this.floater.y = y;
    }

    public int getFloaterX() {
        return this.floater.x;
    }

    public int getFloaterY() {
        return this.floater.y;
    }

    private void setHandles(Rectangle b) {
        int tx = b.x;
        int ty = b.y;
        int tw = b.width;
        int th = b.height;
        this.NW.set(tx, ty);
        this.N.set(tx + tw / 2, ty);
        this.NE.set(tx + tw, ty);
        this.E.set(tx + tw, ty + th / 2);
        this.SE.set(tx + tw, ty + th);
        this.S.set(tx + tw / 2, ty + th);
        this.SW.set(tx, ty + th);
        this.W.set(tx, ty + th / 2);
    }

    protected synchronized void applyAndPropagate(Set<Layer> sublist) {
        if (null == this.accum_affine) {
            Utils.log2("Cannot apply to other layers: undo/redo was used.");
            return;
        }
        if (0 == sublist.size()) {
            Utils.logAll("No layers to apply to!");
            return;
        }
        if (Displayable.areThereLayerCrossLinks(sublist, false)) {
            if (ControlWindow.isGUIEnabled()) {
                YesNoDialog yn = ControlWindow.makeYesNoDialog("Warning!", "Some objects are linked!\nThe transformation would alter interrelationships.\nProceed anyway?");
                if (!yn.yesPressed()) {
                    return;
                }
            } else {
                Utils.log("Can't apply: some images may be linked across layers.\n  Unlink them by removing segmentation objects like arealists, pipes, profiles, etc. that cross these layers.");
                return;
            }
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Layer l : sublist) {
            al.addAll(l.getDisplayables());
        }
        this.display.getLayer().getParent().addTransformStep((Collection<? extends Displayable>)al);
        if (null != this.free_affine && null != this.model) {
            this.accum_affine.preConcatenate(this.free_affine);
            this.accum_affine.preConcatenate(this.model.createAffine());
        }
        for (Layer l : sublist) {
            if (this.display.getLayer() == l) continue;
            l.apply(Displayable.class, this.accum_affine);
        }
        this.display.getLayer().getParent().addTransformStep((Collection<? extends Displayable>)al);
    }

    @Override
    public boolean apply() {
        for (Displayable d : this.display.getSelection().getAffected()) {
            d.setAffineTransform(d.getAffineTransform());
        }
        return true;
    }

    @Override
    public boolean cancel() {
        if (null != this.history) {
            LayerSet.applyTransforms(((TransformationStep)this.history.get((int)0)).ht);
        }
        return true;
    }

    private void initializeModel() {
        if (null != this.free_affine && null != this.model && null != this.accum_affine) {
            this.accum_affine.preConcatenate(this.free_affine);
            this.accum_affine.preConcatenate(this.model.createAffine());
        }
        this.free_affine = new AffineTransform();
        this.initial_affines = this.getTransformationsCopy();
        int size = this.affine_handles.size();
        switch (size) {
            case 0: {
                this.model = null;
                this.p = null;
                this.q = null;
                this.matches = null;
                return;
            }
            case 1: {
                this.model = new TranslationModel2D();
                break;
            }
            case 2: {
                this.model = new SimilarityModel2D();
                break;
            }
            case 3: {
                this.model = new AffineModel2D();
            }
        }
        this.p = new Point[size];
        this.q = new Point[size];
        this.matches = new ArrayList();
        int i = 0;
        for (AffinePoint ap : this.affine_handles) {
            this.p[i] = new Point(new double[]{ap.x, ap.y});
            this.q[i] = this.p[i].clone();
            this.matches.add(new PointMatch(this.p[i], this.q[i]));
            ++i;
        }
    }

    private void freeAffine(AffinePoint affp) {
        double[] w = this.q[this.affine_handles.indexOf(affp)].getW();
        w[0] = affp.x;
        w[1] = affp.y;
        try {
            this.model.fit(this.matches);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AffineTransform model_affine = this.model.createAffine();
        for (Map.Entry<Displayable, AffineTransform> e : this.initial_affines.entrySet()) {
            AffineTransform at = new AffineTransform(e.getValue());
            at.preConcatenate(this.free_affine);
            at.preConcatenate(model_affine);
            e.getKey().setAffineTransform(at);
        }
    }

    private void fixAffinePoints(AffineTransform at) {
        if (null != this.matches) {
            float[] po = new float[2];
            for (AffinePoint affp : this.affine_handles) {
                po[0] = affp.x;
                po[1] = affp.y;
                at.transform(po, 0, po, 0, 1);
                affp.x = (int)po[0];
                affp.y = (int)po[1];
            }
            this.free_affine.setToIdentity();
            this.model = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent me, int x_p, int y_p, double magnification) {
        int index;
        this.grabbed = null;
        if (me.isShiftDown()) {
            if (Utils.isControlDown(me) && null != this.affine_handles) {
                if (this.affine_handles.remove(new AffinePoint(x_p, y_p))) {
                    if (0 == this.affine_handles.size()) {
                        this.affine_handles = null;
                    } else {
                        this.initializeModel();
                    }
                }
                return;
            }
            if (null == this.affine_handles) {
                this.affine_handles = new ArrayList();
            }
            if (this.affine_handles.size() < 3) {
                this.affine_handles.add(new AffinePoint(x_p, y_p));
                if (1 == this.affine_handles.size()) {
                    this.free_affine = new AffineTransform();
                    this.initial_affines = this.getTransformationsCopy();
                }
                this.initializeModel();
            }
            return;
        }
        if (null != this.affine_handles && -1 != (index = this.affine_handles.indexOf(new AffinePoint(x_p, y_p)))) {
            this.affp = this.affine_handles.get(index);
            return;
        }
        double radius = 4.0 / magnification;
        if (radius < 1.0) {
            radius = 1.0;
        }
        for (int i = this.handles.length - 1; i > -1; --i) {
            if (!this.handles[i].contains(x_p, y_p, radius)) continue;
            this.grabbed = this.handles[i];
            if (this.grabbed.id > 7 && this.grabbed.id <= 12) {
                this.rotating = true;
            }
            return;
        }
        this.dragging = false;
        if (this.box.x <= x_p && this.box.y <= y_p && this.box.x + this.box.width >= x_p && this.box.y + this.box.height >= y_p) {
            this.dragging = true;
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        this.x_d = x_d;
        this.y_d = y_d;
        this.x_d_old = x_d_old;
        this.y_d_old = y_d_old;
        int dx = x_d - x_d_old;
        int dy = y_d - y_d_old;
        this.execDrag(me, dx, dy);
        this.display.getCanvas().repaint(true);
        this.mouse_dragged = true;
    }

    private void execDrag(MouseEvent me, int dx, int dy) {
        if (0 == dx && 0 == dy) {
            return;
        }
        if (null != this.affp) {
            this.affp.translate(dx, dy);
            if (null == this.model) {
                this.initializeModel();
            }
            this.freeAffine(this.affp);
            return;
        }
        if (null != this.grabbed) {
            this.grabbed.drag(me, dx, dy);
        } else if (this.dragging) {
            this.translate(dx, dy);
            this.box.x += dx;
            this.box.y += dy;
            this.setHandles(this.box);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        int dx = x_r - x_p;
        int dy = y_r - y_p;
        if (0 != dx || 0 != dy) {
            this.display.getLayerSet().addTransformStep(this.display.getSelection().getAffected());
        }
        if (null != me) {
            this.execDrag(me, x_r - x_d, y_r - y_d);
            this.display.getCanvas().repaint(true);
        }
        this.resetBox();
        if (null != this.grabbed && this.grabbed.id <= 7 || this.dragging) {
            this.floater.center();
        }
        this.grabbed = null;
        this.dragging = false;
        this.rotating = false;
        this.affp = null;
        this.mouse_dragged = false;
    }

    public void resetBox() {
        this.box = null;
        Rectangle b = new Rectangle();
        for (Displayable d : this.display.getSelection().getSelected()) {
            b = d.getBoundingBox(b);
            if (null == this.box) {
                this.box = (Rectangle)b.clone();
            }
            this.box.add(b);
        }
        if (null != this.box) {
            this.setHandles(this.box);
        }
    }

    public void rotate(double angle, int xo, int yo) {
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(angle), xo, yo);
        this.addUndoStep();
        if (null != this.accum_affine) {
            this.accum_affine.preConcatenate(at);
        }
        Displayable.preConcatenate(at, this.display.getSelection().getAffected());
        this.fixAffinePoints(at);
        this.resetBox();
    }

    public void translate(double dx, double dy) {
        AffineTransform at = new AffineTransform();
        at.translate(dx, dy);
        this.addUndoStep();
        if (null != this.accum_affine) {
            this.accum_affine.preConcatenate(at);
        }
        Displayable.preConcatenate(at, this.display.getSelection().getAffected());
        this.fixAffinePoints(at);
        this.resetBox();
    }

    public void scale(double sx, double sy) {
        if (0.0 == sx || 0.0 == sy) {
            Utils.showMessage("Cannot scale to 0.");
            return;
        }
        AffineTransform at = new AffineTransform();
        at.translate(this.floater.x, this.floater.y);
        at.scale(sx, sy);
        at.translate(-this.floater.x, -this.floater.y);
        this.addUndoStep();
        if (null != this.accum_affine) {
            this.accum_affine.preConcatenate(at);
        }
        Displayable.preConcatenate(at, this.display.getSelection().getAffected());
        this.fixAffinePoints(at);
        this.resetBox();
    }

    @Override
    public Rectangle getRepaintBounds() {
        Rectangle b = this.display.getSelection().getLinkedBox();
        b.add(this.floater.getBoundingBox(new Rectangle()));
        return b;
    }

    @Override
    public void srcRectUpdated(Rectangle srcRect, double magnification) {
    }

    @Override
    public void magnificationUpdated(Rectangle srcRect, double magnification) {
    }

    private class AffinePoint {
        int x;
        int y;

        AffinePoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object ob) {
            double dy;
            AffinePoint ap = (AffinePoint)ob;
            double mag = AffineTransformMode.this.display.getCanvas().getMagnification();
            double dx = mag * (double)(ap.x - this.x);
            double d = dx * dx + (dy = mag * (double)(ap.y - this.y)) * dy;
            return d < 64.0;
        }

        void translate(int dx, int dy) {
            this.x += dx;
            this.y += dy;
        }

        private void paint(Graphics2D g) {
            int x = AffineTransformMode.this.display.getCanvas().screenX(this.x);
            int y = AffineTransformMode.this.display.getCanvas().screenY(this.y);
            Utils.drawPoint(g, x, y);
        }
    }

    private class Floater
    extends Handle {
        Floater(int x, int y, int id) {
            super(x, y, id);
        }

        @Override
        public void paint(Graphics2D g, Rectangle srcRect, double mag) {
            int x = (int)((double)(this.x - srcRect.x) * mag);
            int y = (int)((double)(this.y - srcRect.y) * mag);
            Composite co = g.getComposite();
            g.setXORMode(Color.white);
            g.drawOval(x - 10, y - 10, 21, 21);
            g.drawRect(x - 1, y - 15, 3, 31);
            g.drawRect(x - 15, y - 1, 31, 3);
            g.setComposite(co);
        }

        public Rectangle getBoundingBox(Rectangle b) {
            b.x = this.x - 15;
            b.y = this.y - 15;
            b.width = this.x + 31;
            b.height = this.y + 31;
            return b;
        }

        @Override
        public void drag(MouseEvent me, int dx, int dy) {
            this.x += dx;
            this.y += dy;
            ((AffineTransformMode)AffineTransformMode.this).RO.x = this.x;
            ((AffineTransformMode)AffineTransformMode.this).RO.y = this.y;
        }

        public void center() {
            this.x = ((AffineTransformMode)AffineTransformMode.this).RO.x = ((AffineTransformMode)AffineTransformMode.this).box.x + ((AffineTransformMode)AffineTransformMode.this).box.width / 2;
            this.y = ((AffineTransformMode)AffineTransformMode.this).RO.y = ((AffineTransformMode)AffineTransformMode.this).box.y + ((AffineTransformMode)AffineTransformMode.this).box.height / 2;
        }

        @Override
        public boolean contains(int x_p, int y_p, double radius) {
            return super.contains(x_p, y_p, radius * 3.5);
        }
    }

    private class RotationHandle
    extends Handle {
        final int shift = 50;

        RotationHandle(int x, int y, int id) {
            super(x, y, id);
            this.shift = 50;
        }

        @Override
        public void paint(Graphics2D g, Rectangle srcRect, double mag) {
            int x = (int)((double)(this.x - srcRect.x) * mag) + 50;
            int y = (int)((double)(this.y - srcRect.y) * mag);
            int fx = (int)((double)(((AffineTransformMode)AffineTransformMode.this).floater.x - srcRect.x) * mag);
            int fy = (int)((double)(((AffineTransformMode)AffineTransformMode.this).floater.y - srcRect.y) * mag);
            this.draw(g, fx, fy, x, y);
        }

        private void draw(Graphics2D g, int fx, int fy, int x, int y) {
            g.setColor(Color.white);
            g.drawLine(fx, fy, x, y);
            g.fillOval(x - 4, y - 4, 9, 9);
            g.setColor(Color.black);
            g.drawOval(x - 2, y - 2, 5, 5);
        }

        public void paintMoving(Graphics2D g, Rectangle srcRect, double mag, java.awt.Point mouse) {
            int fx = (int)((double)(((AffineTransformMode)AffineTransformMode.this).floater.x - srcRect.x) * mag);
            int fy = (int)((double)(((AffineTransformMode)AffineTransformMode.this).floater.y - srcRect.y) * mag);
            double vx = (double)(mouse.x - srcRect.x) * mag - (double)fx;
            double vy = (double)(mouse.y - srcRect.y) * mag - (double)fy;
            this.draw(g, fx, fy, fx + (int)vx, fy + (int)vy);
        }

        @Override
        public boolean contains(int x_p, int y_p, double radius) {
            double mag = AffineTransformMode.this.display.getCanvas().getMagnification();
            double x = (double)this.x + 50.0 / mag;
            double y = this.y;
            return x - radius <= (double)x_p && x + radius >= (double)x_p && y - radius <= (double)y_p && y + radius >= (double)y_p;
        }

        @Override
        public void drag(MouseEvent me, int dx, int dy) {
            AffineTransformMode.this.rotate(me);
        }
    }

    private class BoxHandle
    extends Handle {
        BoxHandle(int x, int y, int id) {
            super(x, y, id);
        }

        @Override
        public void paint(Graphics2D g, Rectangle srcRect, double mag) {
            int x = (int)((double)(this.x - srcRect.x) * mag);
            int y = (int)((double)(this.y - srcRect.y) * mag);
            DisplayCanvas.drawHandle(g, x, y, 1.0);
        }

        @Override
        public void drag(MouseEvent me, int dx, int dy) {
            Rectangle box_old = (Rectangle)AffineTransformMode.this.box.clone();
            double res = (double)dx / 2.0;
            res -= Math.floor(res);
            res *= 2.0;
            int anchor_x = 0;
            int anchor_y = 0;
            switch (this.id) {
                case 0: {
                    if (this.x + dx >= ((AffineTransformMode)AffineTransformMode.this).E.x) {
                        return;
                    }
                    if (this.y + dy >= ((AffineTransformMode)AffineTransformMode.this).S.y) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.x += dx;
                    ((AffineTransformMode)AffineTransformMode.this).box.y += dy;
                    ((AffineTransformMode)AffineTransformMode.this).box.width -= dx;
                    ((AffineTransformMode)AffineTransformMode.this).box.height -= dy;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).SE.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).SE.y;
                    break;
                }
                case 1: {
                    if (this.y + dy >= ((AffineTransformMode)AffineTransformMode.this).S.y) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.y += dy;
                    ((AffineTransformMode)AffineTransformMode.this).box.height -= dy;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).S.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).S.y;
                    break;
                }
                case 2: {
                    if (this.x + dx <= ((AffineTransformMode)AffineTransformMode.this).W.x) {
                        return;
                    }
                    if (this.y + dy >= ((AffineTransformMode)AffineTransformMode.this).S.y) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.y += dy;
                    ((AffineTransformMode)AffineTransformMode.this).box.width += dx;
                    ((AffineTransformMode)AffineTransformMode.this).box.height -= dy;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).SW.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).SW.y;
                    break;
                }
                case 3: {
                    if (this.x + dx <= ((AffineTransformMode)AffineTransformMode.this).W.x) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.width += dx;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).W.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).W.y;
                    break;
                }
                case 4: {
                    if (this.x + dx <= ((AffineTransformMode)AffineTransformMode.this).W.x) {
                        return;
                    }
                    if (this.y + dy <= ((AffineTransformMode)AffineTransformMode.this).N.y) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.width += dx;
                    ((AffineTransformMode)AffineTransformMode.this).box.height += dy;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).NW.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).NW.y;
                    break;
                }
                case 5: {
                    if (this.y + dy <= ((AffineTransformMode)AffineTransformMode.this).N.y) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.height += dy;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).N.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).N.y;
                    break;
                }
                case 6: {
                    if (this.x + dx >= ((AffineTransformMode)AffineTransformMode.this).E.x) {
                        return;
                    }
                    if (this.y + dy <= ((AffineTransformMode)AffineTransformMode.this).N.y) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.x += dx;
                    ((AffineTransformMode)AffineTransformMode.this).box.width -= dx;
                    ((AffineTransformMode)AffineTransformMode.this).box.height += dy;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).NE.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).NE.y;
                    break;
                }
                case 7: {
                    if (this.x + dx >= ((AffineTransformMode)AffineTransformMode.this).E.x) {
                        return;
                    }
                    ((AffineTransformMode)AffineTransformMode.this).box.x += dx;
                    ((AffineTransformMode)AffineTransformMode.this).box.width -= dx;
                    anchor_x = ((AffineTransformMode)AffineTransformMode.this).E.x;
                    anchor_y = ((AffineTransformMode)AffineTransformMode.this).E.y;
                }
            }
            double px = (double)((AffineTransformMode)AffineTransformMode.this).box.width / (double)box_old.width;
            double py = (double)((AffineTransformMode)AffineTransformMode.this).box.height / (double)box_old.height;
            AffineTransform at = new AffineTransform();
            at.translate(anchor_x, anchor_y);
            at.scale(px, py);
            at.translate(-anchor_x, -anchor_y);
            AffineTransformMode.this.addUndoStep();
            if (null != AffineTransformMode.this.accum_affine) {
                AffineTransformMode.this.accum_affine.preConcatenate(at);
            }
            Displayable.preConcatenate(at, AffineTransformMode.this.display.getSelection().getAffected());
            AffineTransformMode.this.fixAffinePoints(at);
            AffineTransformMode.this.setHandles(AffineTransformMode.this.box);
        }
    }

    private abstract class Handle {
        public int x;
        public int y;
        public final int id;

        Handle(int x, int y, int id) {
            this.x = x;
            this.y = y;
            this.id = id;
        }

        public abstract void paint(Graphics2D var1, Rectangle var2, double var3);

        public boolean contains(int x_p, int y_p, double radius) {
            return (double)this.x - radius <= (double)x_p && (double)this.x + radius >= (double)x_p && (double)this.y - radius <= (double)y_p && (double)this.y + radius >= (double)y_p;
        }

        public void set(int x, int y) {
            this.x = x;
            this.y = y;
        }

        abstract void drag(MouseEvent var1, int var2, int var3);
    }

    private class ATGS
    implements GraphicsSource {
        private ATGS() {
        }

        @Override
        public List<? extends Paintable> asPaintable(List<? extends Paintable> ds) {
            return ds;
        }

        @Override
        public void paintOnTop(Graphics2D g, Display display, Rectangle srcRect, double magnification) {
            Stroke original_stroke = g.getStroke();
            AffineTransform original = g.getTransform();
            g.setTransform(new AffineTransform());
            if (!AffineTransformMode.this.rotating) {
                float[] dashPattern = new float[]{30.0f, 10.0f, 10.0f, 10.0f};
                g.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dashPattern, 0.0f));
                g.setColor(Color.yellow);
                g.draw(original.createTransformedShape(AffineTransformMode.this.box));
                g.setStroke(new BasicStroke(1.0f, 0, 0));
                for (int i = 0; i < AffineTransformMode.this.handles.length; ++i) {
                    AffineTransformMode.this.handles[i].paint(g, srcRect, magnification);
                }
            } else {
                g.setStroke(new BasicStroke(1.0f, 0, 0));
                AffineTransformMode.this.RO.paint(g, srcRect, magnification);
                ((RotationHandle)AffineTransformMode.this.RO).paintMoving(g, srcRect, magnification, display.getCanvas().getCursorLoc());
            }
            if (null != AffineTransformMode.this.affine_handles) {
                for (AffinePoint ap : AffineTransformMode.this.affine_handles) {
                    ap.paint(g);
                }
            }
            g.setTransform(original);
            g.setStroke(original_stroke);
        }
    }
}

