/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Mode;
import ini.trakem2.display.graphics.DefaultGraphicsSource;
import ini.trakem2.display.graphics.GraphicsSource;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Set;

public class DefaultMode
implements Mode {
    private final DefaultGraphicsSource gs = new DefaultGraphicsSource();
    private final Display display;
    private boolean dragging = false;

    public DefaultMode(Display display) {
        this.display = display;
    }

    @Override
    public GraphicsSource getGraphicsSource() {
        return this.gs;
    }

    @Override
    public boolean canChangeLayer() {
        return true;
    }

    @Override
    public boolean canZoom() {
        return true;
    }

    @Override
    public boolean canPan() {
        return true;
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void mousePressed(MouseEvent me, int x_p, int y_p, double magnification) {
        ArrayList<Displayable> sel = this.display.getSelection().getSelected();
        this.dragging = false;
        for (Displayable d : sel) {
            if (!d.contains(x_p, y_p)) continue;
            this.dragging = true;
            break;
        }
        Set<Displayable> affected = this.display.getSelection().getAffected();
        if (this.display.getLayerSet().prepareStep(affected)) {
            this.display.getLayerSet().addTransformStep(affected);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        int dx = x_d - x_d_old;
        int dy = y_d - y_d_old;
        if (this.dragging) {
            this.execDrag(me, dx, dy);
        }
    }

    private void execDrag(MouseEvent me, int dx, int dy) {
        if (0 == dx && 0 == dy) {
            return;
        }
        this.display.getSelection().translate(dx, dy);
    }

    @Override
    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        int dx = x_r - x_p;
        int dy = y_r - y_p;
        if (0 != dx || 0 != dy) {
            this.display.getLayerSet().addTransformStep(this.display.getSelection().getAffected());
        }
        this.dragging = false;
    }

    @Override
    public void undoOneStep() {
        this.display.getLayerSet().undoOneStep();
        Display.repaint(this.display.getLayerSet());
    }

    @Override
    public void redoOneStep() {
        this.display.getLayerSet().redoOneStep();
        Display.repaint(this.display.getLayerSet());
    }

    @Override
    public boolean apply() {
        return true;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.display.getSelection().getLinkedBox();
    }

    @Override
    public void srcRectUpdated(Rectangle srcRect, double magnification) {
    }

    @Override
    public void magnificationUpdated(Rectangle srcRect, double magnification) {
    }
}

