/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.Transform3D;

class ScreenViewCache {
    Screen3D screen;
    double physicalScreenWidth;
    double physicalScreenHeight;
    int screenWidth;
    int screenHeight;
    int[] scrvcDirtyMask = new int[2];
    Transform3D trackerBaseToImagePlate = new Transform3D();
    Transform3D headTrackerToLeftImagePlate = new Transform3D();
    Transform3D headTrackerToRightImagePlate = new Transform3D();
    double metersPerPixelX;
    double metersPerPixelY;

    synchronized void snapshot() {
        if (this.screen.offScreen) {
            this.scrvcDirtyMask[0] = this.scrvcDirtyMask[0] | this.screen.scrDirtyMask;
            this.scrvcDirtyMask[1] = this.scrvcDirtyMask[1] | this.screen.scrDirtyMask;
        } else {
            this.scrvcDirtyMask[0] = this.screen.scrDirtyMask;
            this.scrvcDirtyMask[1] = this.screen.scrDirtyMask;
        }
        this.screen.scrDirtyMask = 0;
        this.physicalScreenWidth = this.screen.physicalScreenWidth;
        this.physicalScreenHeight = this.screen.physicalScreenHeight;
        this.screenWidth = this.screen.screenSize.width;
        this.screenHeight = this.screen.screenSize.height;
        this.screen.trackerBaseToImagePlate.getWithLock(this.trackerBaseToImagePlate);
        this.screen.headTrackerToLeftImagePlate.getWithLock(this.headTrackerToLeftImagePlate);
        this.screen.headTrackerToRightImagePlate.getWithLock(this.headTrackerToRightImagePlate);
        this.metersPerPixelX = this.physicalScreenWidth / (double)this.screenWidth;
        this.metersPerPixelY = this.physicalScreenHeight / (double)this.screenHeight;
    }

    ScreenViewCache(Screen3D screen) {
        this.screen = screen;
    }
}

