/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.brightness.SliderPanelDouble;
import bdv.util.BoundedIntervalDouble;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;

public class RealBoxSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final BoundedIntervalDouble[] ranges;
    private final SliderPanelDouble[] minSliderPanels;
    private final SliderPanelDouble[] maxSliderPanels;
    private final RealBox selection;
    private int cols;
    private final int n;

    public RealBoxSelectionPanel(RealBox selection, RealInterval rangeInterval) {
        int d;
        this.n = selection.getInterval().numDimensions();
        this.selection = selection;
        this.ranges = new BoundedIntervalDouble[this.n];
        this.minSliderPanels = new SliderPanelDouble[this.n];
        this.maxSliderPanels = new SliderPanelDouble[this.n];
        this.cols = 2;
        for (d = 0; d < this.n; ++d) {
            this.cols = Math.max(this.cols, Double.toString(rangeInterval.realMin(d)).length());
            this.cols = Math.max(this.cols, Double.toString(rangeInterval.realMax(d)).length());
        }
        this.setLayout(new BoxLayout(this, 3));
        for (d = 0; d < this.n; ++d) {
            double rangeMin = rangeInterval.realMin(d);
            double rangeMax = rangeInterval.realMax(d);
            RealInterval interval = selection.getInterval();
            double initialMin = Math.max(interval.realMin(d), rangeMin);
            double initialMax = Math.min(interval.realMax(d), rangeMax);
            BoundedIntervalDouble range = new BoundedIntervalDouble(rangeMin, rangeMax, initialMin, initialMax, 0.0){

                @Override
                protected void updateInterval(double min, double max) {
                    RealBoxSelectionPanel.this.updateSelection();
                }
            };
            JPanel sliders = new JPanel();
            sliders.setLayout(new BoxLayout(sliders, 3));
            String axis = d == 0 ? "x" : (d == 1 ? "y" : "z");
            SliderPanelDouble minPanel = new SliderPanelDouble(axis + " min", range.getMinBoundedValue(), 1.0);
            minPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            minPanel.setNumColummns(this.cols);
            sliders.add(minPanel);
            SliderPanelDouble maxPanel = new SliderPanelDouble(axis + " max", range.getMaxBoundedValue(), 1.0);
            maxPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            maxPanel.setNumColummns(this.cols);
            sliders.add(maxPanel);
            this.add(sliders);
            this.minSliderPanels[d] = minPanel;
            this.maxSliderPanels[d] = maxPanel;
            this.ranges[d] = range;
        }
    }

    public void setBoundsInterval(RealInterval interval) {
        int d;
        int oldCols = this.cols;
        for (d = 0; d < this.n; ++d) {
            this.cols = Math.max(this.cols, Double.toString(interval.realMin(d)).length());
            this.cols = Math.max(this.cols, Double.toString(interval.realMax(d)).length());
        }
        for (d = 0; d < this.n; ++d) {
            this.ranges[d].setRange((int)interval.realMin(d), (int)interval.realMax(d));
        }
        if (oldCols != this.cols) {
            for (d = 0; d < this.n; ++d) {
                this.minSliderPanels[d].setNumColummns(this.cols);
                this.maxSliderPanels[d].setNumColummns(this.cols);
            }
            this.invalidate();
        }
    }

    public void updateSelection() {
        double[] min = new double[this.n];
        double[] max = new double[this.n];
        for (int d = 0; d < this.n; ++d) {
            min[d] = this.ranges[d].getMinBoundedValue().getCurrentValue();
            max[d] = this.ranges[d].getMaxBoundedValue().getCurrentValue();
        }
        this.selection.setInterval(new FinalRealInterval(min, max));
    }

    public void updateSliders(RealInterval interval) {
        if (interval.numDimensions() != this.n) {
            throw new IllegalArgumentException();
        }
        double[] min = new double[this.n];
        double[] max = new double[this.n];
        interval.realMin(min);
        interval.realMax(max);
        for (int d = 0; d < this.n; ++d) {
            this.ranges[d].getMinBoundedValue().setCurrentValue(min[d]);
            this.ranges[d].getMaxBoundedValue().setCurrentValue(max[d]);
        }
    }

    public static interface RealBox {
        public RealInterval getInterval();

        public void setInterval(RealInterval var1);
    }
}

