/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.settings;

import bdv.ui.settings.ModificationListener;
import bdv.ui.settings.SettingsPage;
import bdv.ui.settings.style.Style;
import bdv.ui.settings.style.StyleManager;
import bdv.ui.settings.style.StyleProfile;
import bdv.ui.settings.style.StyleProfileManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.scijava.listeners.Listeners;

public class SelectAndEditProfileSettingsPage<T extends Profile>
implements SettingsPage {
    private final String treePath;
    private final ProfileManager<T> profileManager;
    private final ProfileSelectionPanel<T> profileSelectionPanel;
    private final ProfileEditPanel<T> profileEditPanel;
    private final Listeners.List<ModificationListener> modificationListeners;
    private final JPanel contentPanel;

    public SelectAndEditProfileSettingsPage(String treePath, ProfileManager<T> profileManager, ProfileEditPanel<T> profileEditPanel) {
        this.treePath = treePath;
        this.profileManager = profileManager;
        this.profileEditPanel = profileEditPanel;
        this.profileSelectionPanel = new ProfileSelectionPanel<T>(profileManager, profileEditPanel);
        this.profileSelectionPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        profileEditPanel.loadProfile(profileManager.getSelectedProfile());
        profileEditPanel.modificationListeners().add(this.profileSelectionPanel);
        this.modificationListeners = new Listeners.SynchronizedList();
        profileEditPanel.modificationListeners().add(() -> this.modificationListeners.list.forEach(ModificationListener::setModified));
        this.profileSelectionPanel.selectionListeners().add(p -> this.modificationListeners.list.forEach(ModificationListener::setModified));
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.add(this.profileSelectionPanel, "North");
        this.contentPanel.add((Component)profileEditPanel.getJPanel(), "Center");
    }

    public static <M extends StyleManager<M, S>, S extends Style<S>> SelectAndEditProfileSettingsPage<StyleProfile<S>> forStyle(M manager, M editingManager, ProfileEditPanel<StyleProfile<S>> settingsPage, String treePath) {
        StyleProfileManager pm = new StyleProfileManager(manager, editingManager);
        return new SelectAndEditProfileSettingsPage<StyleProfile<S>>(treePath, pm, settingsPage);
    }

    @Override
    public String getTreePath() {
        return this.treePath;
    }

    @Override
    public JPanel getJPanel() {
        return this.contentPanel;
    }

    @Override
    public Listeners<ModificationListener> modificationListeners() {
        return this.modificationListeners;
    }

    @Override
    public void apply() {
        this.profileEditPanel.storeProfile(this.profileManager.getSelectedProfile());
        this.profileManager.apply();
    }

    @Override
    public void cancel() {
        this.profileManager.cancel();
        ((ProfileSelectionPanel)this.profileSelectionPanel).makeModel();
        this.profileEditPanel.loadProfile(this.profileManager.getSelectedProfile());
    }

    static class ProfileSelectionPanel<T extends Profile>
    extends JPanel
    implements ModificationListener {
        private static final long serialVersionUID = 1L;
        private final ProfileManager<T> manager;
        private final ProfileEditPanel<T> editor;
        private boolean blockComboBoxItemListener = false;
        private final JComboBox<Item> comboBox;
        private final Listeners.SynchronizedList<SelectionListener<T>> selectionListeners;
        private final JButton buttonDelete;
        private final JButton buttonDuplicate;
        private final JButton buttonRename;

        public ProfileSelectionPanel(ProfileManager<T> manager, ProfileEditPanel<T> editor) {
            this.manager = manager;
            this.editor = editor;
            this.selectionListeners = new Listeners.SynchronizedList();
            this.comboBox = new JComboBox();
            this.comboBox.setEditable(false);
            this.buttonDuplicate = new JButton("Duplicate");
            this.buttonRename = new JButton("Rename");
            this.buttonDelete = new JButton("Delete");
            this.comboBox.addItemListener(e -> {
                if (this.blockComboBoxItemListener) {
                    return;
                }
                Profile profile = ((Item)e.getItem()).profile;
                if (e.getStateChange() == 1) {
                    manager.select(profile);
                    this.buttonDelete.setEnabled(!profile.isBuiltin());
                    this.buttonRename.setEnabled(!profile.isBuiltin());
                    this.selectionListeners.list.forEach(l -> l.selected(profile));
                    editor.loadProfile(profile);
                } else {
                    this.selectionListeners.list.forEach(l -> l.deselected(profile));
                    editor.storeProfile(profile);
                }
            });
            this.buttonDuplicate.addActionListener(e -> this.duplicateSelected());
            this.buttonRename.addActionListener(e -> this.renameSelected());
            this.buttonDelete.addActionListener(e -> this.deleteSelected());
            this.setLayout(new BoxLayout(this, 2));
            this.add(Box.createHorizontalGlue());
            this.add(this.comboBox);
            this.add(this.buttonDuplicate);
            this.add(this.buttonRename);
            this.add(this.buttonDelete);
            this.add(Box.createHorizontalGlue());
            this.makeModel();
        }

        private void duplicateSelected() {
            Item selected = (Item)this.comboBox.getSelectedItem();
            if (selected != null) {
                if (selected.profile.isBuiltin()) {
                    Profile duplicate = this.manager.duplicate(selected.profile);
                    this.editor.storeProfile(duplicate);
                    this.manager.select(duplicate);
                    this.selectionListeners.list.forEach(l -> l.deselected(selected.profile));
                    this.selectionListeners.list.forEach(l -> l.selected(duplicate));
                } else {
                    this.editor.storeProfile(selected.profile);
                    Profile duplicate = this.manager.duplicate(selected.profile);
                    this.manager.select(duplicate);
                    this.selectionListeners.list.forEach(l -> l.deselected(selected.profile));
                    this.selectionListeners.list.forEach(l -> l.selected(duplicate));
                    this.editor.loadProfile(duplicate);
                }
                this.makeModel();
            }
        }

        private void deleteSelected() {
            Item selected = (Item)this.comboBox.getSelectedItem();
            if (selected != null) {
                this.manager.delete(selected.profile);
                this.selectionListeners.list.forEach(l -> l.deselected(selected.profile));
                this.selectionListeners.list.forEach(l -> l.selected(this.manager.getSelectedProfile()));
                this.editor.loadProfile(this.manager.getSelectedProfile());
                this.makeModel();
            }
        }

        private void renameSelected() {
            String oldName;
            String newName;
            Item selected = (Item)this.comboBox.getSelectedItem();
            if (selected != null && (newName = (String)JOptionPane.showInputDialog(this, "Enter the new name:", "Rename", -1, null, null, oldName = selected.getName())) != null && !newName.equals(oldName)) {
                try {
                    this.manager.rename(selected.profile, newName);
                    this.selectionListeners.list.forEach(l -> l.selected(selected.profile));
                    this.makeModel();
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Rename failed", 0);
                }
            }
        }

        @Override
        public void setModified() {
            if (((Item)this.comboBox.getSelectedItem()).isBuiltin()) {
                this.duplicateSelected();
            }
        }

        private void makeModel() {
            Vector items = new Vector();
            this.manager.getProfiles().forEach(profile -> items.add(new Item(this, profile)));
            this.comboBox.setModel(new DefaultComboBoxModel(items));
            Item selectedItem = new Item(this, this.manager.getSelectedProfile());
            this.buttonDelete.setEnabled(!selectedItem.isBuiltin());
            this.buttonRename.setEnabled(!selectedItem.isBuiltin());
            this.blockComboBoxItemListener = true;
            this.comboBox.setSelectedIndex(items.indexOf(selectedItem));
            this.blockComboBoxItemListener = false;
        }

        public Listeners<SelectionListener<T>> selectionListeners() {
            return this.selectionListeners;
        }

        static class Item {
            private final T profile;
            final /* synthetic */ ProfileSelectionPanel this$0;

            public Item(T profile) {
                this.this$0 = this$0;
                this.profile = profile;
            }

            public String toString() {
                return this.profile.isBuiltin() ? "<html><b>" + this.profile.getName() + "</b> <i>(built-in)</i></html>" : this.profile.getName();
            }

            public String getName() {
                return this.profile.getName();
            }

            public boolean isBuiltin() {
                return this.profile.isBuiltin();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Item item = (Item)o;
                return this.profile.equals(item.profile);
            }

            public int hashCode() {
                return this.profile.hashCode();
            }
        }
    }

    @FunctionalInterface
    static interface SelectionListener<T> {
        public void selected(T var1);

        default public void deselected(T profile) {
        }
    }

    public static interface ProfileEditPanel<T> {
        public Listeners<ModificationListener> modificationListeners();

        public void loadProfile(T var1);

        public void storeProfile(T var1);

        public JPanel getJPanel();
    }

    public static interface ProfileManager<T extends Profile> {
        public List<T> getProfiles();

        public T getSelectedProfile();

        public void select(T var1);

        public T duplicate(T var1);

        public void rename(T var1, String var2) throws IllegalArgumentException;

        public void delete(T var1);

        public void apply();

        public void cancel();
    }

    public static interface Profile {
        public boolean isBuiltin();

        public String getName();
    }
}

