/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

public enum DisplayMode {
    SINGLE(0, "single-source mode"),
    GROUP(1, "single-group mode"),
    FUSED(2, "fused mode"),
    FUSEDGROUP(3, "fused group mode");

    private final int id;
    private final String name;
    public static final int length;

    private DisplayMode(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int id() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public DisplayMode withFused(boolean activate) {
        switch (this) {
            default: {
                return activate ? FUSED : SINGLE;
            }
            case GROUP: 
            case FUSEDGROUP: 
        }
        return activate ? FUSEDGROUP : GROUP;
    }

    public DisplayMode withGrouping(boolean activate) {
        switch (this) {
            default: {
                return activate ? GROUP : SINGLE;
            }
            case FUSED: 
            case FUSEDGROUP: 
        }
        return activate ? FUSEDGROUP : FUSED;
    }

    public boolean hasFused() {
        return this == FUSED || this == FUSEDGROUP;
    }

    public boolean hasGrouping() {
        return this == GROUP || this == FUSEDGROUP;
    }

    static {
        length = DisplayMode.values().length;
    }
}

