/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.gui;

import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;

public class ScrollbarWithLabel
extends Panel
implements Adjustable,
AdjustmentListener {
    private static final long serialVersionUID = -7934396430763922931L;
    private final Scrollbar bar;
    private Label label;
    private final int orientation;
    transient AdjustmentListener adjustmentListener;

    public ScrollbarWithLabel(int orientation, int value, int visible, int minimum, int maximum, String label) {
        super(new BorderLayout(2, 0));
        this.orientation = orientation;
        this.bar = new Scrollbar(orientation, value, visible, minimum, maximum);
        this.label = label != null ? new Label(label) : new Label("");
        if (orientation == 0) {
            this.add((Component)this.label, "West");
        } else if (orientation == 1) {
            this.add((Component)this.label, "North");
        } else {
            throw new IllegalArgumentException("invalid orientation");
        }
        this.add((Component)this.bar, "Center");
        this.bar.addAdjustmentListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(0, 0);
        if (this.orientation == 0) {
            int width = this.bar.getPreferredSize().width + this.label.getPreferredSize().width;
            Dimension minSize = this.getMinimumSize();
            if (width < minSize.width) {
                width = minSize.width;
            }
            int height = this.bar.getPreferredSize().height;
            dim = new Dimension(width, height);
        } else {
            int height = this.bar.getPreferredSize().height + this.label.getPreferredSize().height;
            Dimension minSize = this.getMinimumSize();
            if (height < minSize.height) {
                height = minSize.height;
            }
            int width = this.bar.getPreferredSize().width;
            dim = new Dimension(width, height);
        }
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.orientation == 0) {
            return new Dimension(80, 15);
        }
        return new Dimension(15, 80);
    }

    @Deprecated
    public Scrollbar getScrollbar() {
        return this.bar;
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.bar.addKeyListener(l);
        this.label.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.bar.removeKeyListener(l);
        this.label.removeKeyListener(l);
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener l) {
        if (l == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, l);
    }

    @Override
    public int getBlockIncrement() {
        return this.bar.getBlockIncrement();
    }

    @Override
    public int getMaximum() {
        return this.bar.getMaximum();
    }

    @Override
    public int getMinimum() {
        return this.bar.getMinimum();
    }

    @Override
    public int getOrientation() {
        return this.bar.getOrientation();
    }

    @Override
    public int getUnitIncrement() {
        return this.bar.getUnitIncrement();
    }

    @Override
    public int getValue() {
        return this.bar.getValue();
    }

    @Override
    public int getVisibleAmount() {
        return this.bar.getVisibleAmount();
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener l) {
        if (l == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, l);
    }

    @Override
    public void setBlockIncrement(int b) {
        this.bar.setBlockIncrement(b);
    }

    @Override
    public void setMaximum(int max) {
        this.bar.setMaximum(max);
    }

    @Override
    public void setMinimum(int min) {
        this.bar.setMinimum(min);
    }

    @Override
    public void setUnitIncrement(int u) {
        this.bar.setUnitIncrement(u);
    }

    @Override
    public void setValue(int v) {
        this.bar.setValue(v);
    }

    @Override
    public void setVisibleAmount(int v) {
        this.bar.setVisibleAmount(v);
    }

    @Override
    public void setFocusable(boolean focusable) {
        super.setFocusable(focusable);
        this.bar.setFocusable(focusable);
        this.label.setFocusable(focusable);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.bar != null && e.getSource() == this.bar) {
            AdjustmentEvent myE = new AdjustmentEvent(this, e.getID(), e.getAdjustmentType(), e.getValue(), e.getValueIsAdjusting());
            AdjustmentListener listener = this.adjustmentListener;
            if (listener != null) {
                listener.adjustmentValueChanged(myE);
            }
        }
    }
}

