/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.launcher;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Arrays;
import net.imagej.launcher.ClassLoaderPlus;
import net.imagej.launcher.RemoteUpdater;
import net.imagej.launcher.SplashScreen;

public class ClassLauncher {
    protected static boolean debug;
    protected static String[] originalArguments;

    public static void main(String[] arguments) {
        originalArguments = arguments;
        if (Boolean.getBoolean("imagej.splash")) {
            try {
                SplashScreen.show();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        ClassLauncher.run(arguments);
    }

    public static void restart() {
        Thread.currentThread().setContextClassLoader(ClassLoader.class.getClassLoader());
        ClassLauncher.run(originalArguments);
    }

    protected static void run(String[] arguments) {
        String mainClass;
        URLClassLoader classLoader;
        boolean passClasspath;
        boolean jdb;
        block23: {
            int i;
            jdb = false;
            passClasspath = false;
            classLoader = null;
            for (i = 0; i < arguments.length && arguments[i].charAt(0) == '-'; ++i) {
                String option = arguments[i];
                if (option.equals("-cp") || option.equals("-classpath")) {
                    classLoader = ClassLoaderPlus.get(classLoader, new File(arguments[++i]));
                    continue;
                }
                if (option.equals("-ijcp") || option.equals("-ijclasspath")) {
                    classLoader = ClassLoaderPlus.getInImageJDirectory(classLoader, arguments[++i]);
                    continue;
                }
                if (option.equals("-jarpath")) {
                    classLoader = ClassLoaderPlus.getRecursively(classLoader, true, new File(arguments[++i]));
                    continue;
                }
                if (option.equals("-ijjarpath")) {
                    classLoader = ClassLoaderPlus.getRecursivelyInImageJDirectory(classLoader, true, arguments[++i]);
                    if (!"plugins".equals(arguments[i])) continue;
                    String ij1PluginDirs = System.getProperty("ij1.plugin.dirs");
                    if (debug) {
                        System.err.println("ij1.plugin.dirs: " + ij1PluginDirs);
                    }
                    if (ij1PluginDirs != null) {
                        for (String path : ij1PluginDirs.split(File.pathSeparator)) {
                            File dir = new File(path);
                            if (!dir.exists()) continue;
                            ClassLoaderPlus.getRecursively(classLoader, false, dir);
                        }
                        continue;
                    }
                    File dir = new File(System.getProperty("user.home"), ".plugins");
                    if (debug) {
                        System.err.println("$HOME/.plugins: " + dir + " " + (dir.exists() ? "exists" : "does not exist"));
                    }
                    if (!dir.exists()) continue;
                    ClassLoaderPlus.getRecursively(classLoader, false, dir);
                    continue;
                }
                if (option.equals("-jdb")) {
                    jdb = true;
                    continue;
                }
                if (option.equals("-pass-classpath")) {
                    passClasspath = true;
                    continue;
                }
                if (option.equals("-freeze-classloader")) {
                    ClassLoaderPlus.freeze(classLoader);
                    continue;
                }
                System.err.println("Unknown option: " + option + "!");
                System.exit(1);
            }
            if (i >= arguments.length) {
                System.err.println("Missing argument: main class");
                System.exit(1);
            }
            mainClass = arguments[i];
            arguments = ClassLauncher.slice(arguments, i + 1);
            if (!("false".equals(System.getProperty("patch.ij1")) || mainClass.equals("net.imagej.Main") || mainClass.equals("org.scijava.minimaven.MiniMaven"))) {
                classLoader = ClassLoaderPlus.getInImageJDirectory(null, "jars/fiji-compat.jar");
                try {
                    ClassLauncher.patchIJ1(classLoader);
                }
                catch (Exception e) {
                    if ("fiji.IJ1Patcher".equals(e.getMessage())) break block23;
                    e.printStackTrace();
                }
            }
        }
        if (passClasspath && classLoader != null) {
            arguments = ClassLauncher.prepend(arguments, "-classpath", ClassLoaderPlus.getClassPath(classLoader));
        }
        if (jdb) {
            arguments = ClassLauncher.prepend(arguments, mainClass);
            if (classLoader != null) {
                arguments = ClassLauncher.prepend(arguments, "-classpath", ClassLoaderPlus.getClassPath(classLoader));
            }
            mainClass = "com.sun.tools.example.debug.tty.TTY";
        }
        if (debug) {
            System.err.println("Launching main class " + mainClass + " with parameters " + Arrays.toString(arguments));
        }
        try {
            ClassLauncher.launch(classLoader, mainClass, arguments);
        }
        catch (Throwable t) {
            t.printStackTrace();
            if ("net.imagej.Main".equals(mainClass) && !ClassLauncher.containsBatchOption(arguments) && !GraphicsEnvironment.isHeadless() && RemoteUpdater.runRemote(t)) {
                return;
            }
            System.exit(1);
        }
    }

    private static boolean containsBatchOption(String[] arguments) {
        for (String argument : arguments) {
            if (!"-batch".equals(argument) && !"-batch-no-exit".equals(argument)) continue;
            return true;
        }
        return false;
    }

    protected static void patchIJ1(ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = classLoader.loadClass("fiji.IJ1Patcher");
        Runnable ij1Patcher = (Runnable)clazz.newInstance();
        ij1Patcher.run();
    }

    protected static String[] slice(String[] array, int from) {
        return ClassLauncher.slice(array, from, array.length);
    }

    protected static String[] slice(String[] array, int from, int to) {
        String[] result = new String[to - from];
        if (result.length > 0) {
            System.arraycopy(array, from, result, 0, result.length);
        }
        return result;
    }

    protected static String[] prepend(String[] array, String ... before) {
        if (before.length == 0) {
            return array;
        }
        String[] result = new String[before.length + array.length];
        System.arraycopy(before, 0, result, 0, before.length);
        System.arraycopy(array, 0, result, before.length, array.length);
        return result;
    }

    protected static void launch(ClassLoader classLoader, String className, String[] arguments) {
        Class<?> main;
        block16: {
            main = null;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (debug) {
                System.err.println("Class loader = " + classLoader);
            }
            String noSlashes = className.replace('/', '.');
            try {
                main = classLoader.loadClass(noSlashes);
            }
            catch (ClassNotFoundException e) {
                if (debug) {
                    e.printStackTrace();
                }
                if (!noSlashes.startsWith("net.imagej.")) break block16;
                try {
                    main = classLoader.loadClass(noSlashes.substring(4));
                }
                catch (ClassNotFoundException e2) {
                    if (debug) {
                        e2.printStackTrace();
                    }
                    System.err.println("Class '" + noSlashes + "' was not found");
                    System.exit(1);
                }
            }
        }
        Class[] argsType = new Class[]{arguments.getClass()};
        Method mainMethod = null;
        try {
            mainMethod = main.getMethod("main", argsType);
        }
        catch (NoSuchMethodException e) {
            if (debug) {
                e.printStackTrace();
            }
            System.err.println("Class '" + className + "' does not have a main() method.");
            System.exit(1);
        }
        Integer result = new Integer(1);
        try {
            result = (Integer)mainMethod.invoke(null, new Object[]{arguments});
        }
        catch (IllegalAccessException e) {
            if (debug) {
                e.printStackTrace();
            }
            System.err.println("The main() method of class '" + className + "' is not public.");
        }
        catch (InvocationTargetException e) {
            System.err.println("Error while executing the main() method of class '" + className + "':");
            e.getTargetException().printStackTrace();
        }
        if (result != null) {
            System.exit(result);
        }
    }

    static {
        try {
            debug = Boolean.getBoolean("ij.debug") || "debug".equalsIgnoreCase(System.getProperty("scijava.log.level")) || System.getenv("DEBUG_IJ_LAUNCHER") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

