/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Background;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.LeafState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.NullSceneGraphObjectState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.SceneGraphObjectState;
import org.scijava.vecmath.Color3f;

public class BackgroundState
extends LeafState {
    private int image;
    private int boundingLeaf;
    private SceneGraphObjectState branchState;

    public BackgroundState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.boundingLeaf = control.getSymbolTable().addReference(((Background)this.node).getApplicationBoundingLeaf());
            this.image = control.getSymbolTable().addReference(((Background)this.node).getImage());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.boundingLeaf);
        out.writeInt(0);
        out.writeInt(this.image);
        this.control.writeBounds(out, ((Background)this.node).getApplicationBounds());
        Color3f clr = new Color3f();
        ((Background)this.node).getColor(clr);
        this.control.writeColor3f(out, clr);
        out.writeInt(((Background)this.node).getImageScaleMode());
        this.control.writeObject(out, this.control.createState(((Background)this.node).getGeometry()));
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.boundingLeaf = in.readInt();
        in.readInt();
        this.image = in.readInt();
        ((Background)this.node).setApplicationBounds(this.control.readBounds(in));
        ((Background)this.node).setColor(this.control.readColor3f(in));
        ((Background)this.node).setImageScaleMode(in.readInt());
        if (this.control.getCurrentFileVersion() < 4) {
            return;
        }
        this.branchState = this.control.readObject(in);
        if (!(this.branchState instanceof NullSceneGraphObjectState)) {
            ((Background)this.node).setGeometry((BranchGroup)this.branchState.getNode());
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.image);
    }

    @Override
    public void buildGraph() {
        ((Background)this.node).setApplicationBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        ((Background)this.node).setImage((ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.image));
        if (this.branchState != null && !this.branchState.getSymbol().graphBuilt) {
            this.branchState.buildGraph();
            this.branchState.getSymbol().graphBuilt = true;
        }
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Background();
    }
}

