/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.LUDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawLU;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.type.context.NumberContext;

public interface LU<N extends Number>
extends LDU<N> {
    public static final Factory<BigDecimal> BIG = typical -> new LUDecomposition.Big();
    public static final Factory<ComplexNumber> COMPLEX = typical -> new LUDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> {
        if (16L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new LUDecomposition.Primitive();
        }
        return new RawLU();
    };
    public static final Factory<Quaternion> QUATERNION = typical -> new LUDecomposition.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new LUDecomposition.Rational();

    public static <N extends Number> LU<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return (LU)BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (LU)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (LU)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, LU<N> decomposition, NumberContext context) {
        MatrixStore<MatrixStore<N>> tmpL = decomposition.getL();
        MatrixStore<N> tmpU = decomposition.getU();
        int[] tmpPivotOrder = decomposition.getPivotOrder();
        return Access2D.equals(matrix.logical().row(tmpPivotOrder).get(), tmpL.multiply(tmpU), context);
    }

    public static <N extends Number> MatrixStore<N> reconstruct(LU<N> decomposition) {
        return decomposition.getL().multiply(decomposition.getU()).logical().row(decomposition.getPivotOrder()).get();
    }

    public boolean computeWithoutPivoting(ElementsSupplier<N> var1);

    public MatrixStore<N> getL();

    public int[] getPivotOrder();

    @Override
    public int getRank();

    public MatrixStore<N> getU();

    @Override
    default public MatrixStore<N> reconstruct() {
        return LU.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<LU<N>> {
    }
}

