/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.geometry;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.geometry.GeometryMatrix;
import org.ojalgo.matrix.geometry.Primitive64Vector2;
import org.ojalgo.matrix.transformation.TransformationMatrix;

public class Primitive64Matrix2
implements GeometryMatrix<Primitive64Matrix2>,
TransformationMatrix<Double, Primitive64Vector2> {
    public double m00;
    public double m10;
    public double m01;
    public double m11;

    @Override
    public final long countColumns() {
        return 2L;
    }

    @Override
    public final long countRows() {
        return 2L;
    }

    @Override
    public final double doubleValue(int row, int col) {
        switch (col) {
            case 0: {
                switch (row) {
                    case 0: {
                        return this.m00;
                    }
                    case 1: {
                        return this.m10;
                    }
                }
            }
            case 1: {
                switch (row) {
                    case 0: {
                        return this.m01;
                    }
                    case 1: {
                        return this.m11;
                    }
                }
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Primitive64Matrix2)) {
            return false;
        }
        Primitive64Matrix2 other = (Primitive64Matrix2)obj;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(other.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(other.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(other.m10)) {
            return false;
        }
        return Double.doubleToLongBits(this.m11) == Double.doubleToLongBits(other.m11);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m00);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m01);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m10);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m11);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public final void multiply(Primitive64Vector2 right, Primitive64Vector2 product) {
        double right0 = right.v0;
        double right1 = right.v1;
        product.v0 = this.m00 * right0 + this.m01 * right1;
        product.v1 = this.m10 * right0 + this.m11 * right1;
    }

    @Override
    public final void negate(Primitive64Matrix2 matrix) {
        this.m00 = -matrix.m00;
        this.m01 = -matrix.m01;
        this.m10 = -matrix.m10;
        this.m11 = -matrix.m11;
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    @Override
    public final void transform(Primitive64Vector2 transformable) {
        this.multiply(transformable, transformable);
    }

    @Override
    public final void transpose(Primitive64Matrix2 matrix) {
        this.m00 = matrix.m00;
        this.m01 = matrix.m10;
        this.m10 = matrix.m01;
        this.m11 = matrix.m11;
    }
}

