/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;

final class OffsetStore<N extends Number>
extends SelectingStore<N> {
    private final int myRowOffset;
    private final int myColumnOffset;

    OffsetStore(MatrixStore<N> base, int rowOffset, int columnOffset) {
        super(base, (int)base.countRows() - rowOffset, (int)base.countColumns() - columnOffset);
        this.myRowOffset = rowOffset;
        this.myColumnOffset = columnOffset;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.getBase().doubleValue((long)this.myRowOffset + row, (long)this.myColumnOffset + col);
    }

    @Override
    public N get(long row, long col) {
        return this.getBase().get((long)this.myRowOffset + row, (long)this.myColumnOffset + col);
    }
}

