/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.smurn.jply.DataType;
import org.smurn.jply.ListProperty;

public class Property {
    private final String name;
    private final DataType type;

    public Property(String name, DataType type) {
        if (name == null) {
            throw new NullPointerException("name must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null.");
        }
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    public String toString() {
        return "property " + (Object)((Object)this.type) + " " + this.name;
    }

    static Property parse(String propertyLine) throws IOException {
        DataType dataType;
        if (!propertyLine.startsWith("property ")) {
            throw new IOException("not a property: '" + propertyLine + "'");
        }
        String definition = propertyLine.substring("property ".length());
        if (definition.startsWith("list")) {
            return ListProperty.parse(propertyLine);
        }
        String[] parts = definition.split(" +", 2);
        if (parts.length != 2) {
            throw new IOException("Expected two parts in property definition: '" + propertyLine + "'");
        }
        String type = parts[0];
        String name = parts[1];
        try {
            dataType = DataType.parse(type);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        return new Property(name, dataType);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Property rhs = (Property)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.name, (Object)rhs.name);
        builder.append((Object)this.type, (Object)rhs.type);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.name);
        builder.append((Object)this.type);
        return builder.toHashCode();
    }
}

