/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.awt;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.display.ScreenCaptureService;
import net.imglib2.RandomAccess;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class AWTScreenCaptureService
extends AbstractService
implements ScreenCaptureService {
    @Parameter
    private DatasetService dataService;

    public Dataset captureScreenRegion(int x, int y, int width, int height) {
        try {
            Rectangle r = new Rectangle(x, y, width, height);
            Robot robot = new Robot();
            BufferedImage img = robot.createScreenCapture(r);
            return this.datasetFromImage(img);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Dataset captureScreen() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        return this.captureScreenRegion(0, 0, dim.width, dim.height);
    }

    private Dataset datasetFromImage(BufferedImage img) {
        int type = img.getType();
        switch (type) {
            case 10: {
                return this.grayDataset(img, 8);
            }
            case 11: {
                return this.grayDataset(img, 16);
            }
        }
        return this.rgbDataset(img);
    }

    private Dataset grayDataset(BufferedImage img, int bitsPerPixel) {
        int width = img.getWidth();
        int height = img.getHeight();
        Dataset dataset = this.makeDataset(width, height, bitsPerPixel);
        RandomAccess accessor = dataset.getImgPlus().randomAccess();
        Raster raster = img.getData();
        for (int x = 0; x < width; ++x) {
            accessor.setPosition(x, 0);
            for (int y = 0; y < height; ++y) {
                accessor.setPosition(y, 1);
                int value = raster.getSample(x, y, 0);
                ((RealType)accessor.get()).setReal((float)value);
            }
        }
        return dataset;
    }

    private Dataset rgbDataset(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        Dataset dataset = this.makeDataset(width, height, 24);
        RandomAccess accessor = dataset.getImgPlus().randomAccess();
        for (int x = 0; x < width; ++x) {
            accessor.setPosition(x, 0);
            for (int y = 0; y < height; ++y) {
                accessor.setPosition(y, 1);
                int pixel = img.getRGB(x, y);
                for (int c = 0; c < 3; ++c) {
                    int byteNum = 2 - c;
                    int shiftCount = 8 * byteNum;
                    double value = pixel >> shiftCount & 0xFF;
                    accessor.setPosition(c, 2);
                    ((RealType)accessor.get()).setReal(value);
                }
            }
        }
        return dataset;
    }

    private Dataset makeDataset(int width, int height, int bitsPerPixel) {
        int bpp;
        AxisType[] axes;
        long[] dims;
        switch (bitsPerPixel) {
            case 8: 
            case 16: 
            case 24: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid bit depth specified");
            }
        }
        String name = "Image Capture";
        if (bitsPerPixel == 24) {
            dims = new long[]{width, height, 3L};
            axes = new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL};
            bpp = 8;
        } else {
            dims = new long[]{width, height};
            axes = new AxisType[]{Axes.X, Axes.Y};
            bpp = bitsPerPixel;
        }
        boolean signed = false;
        boolean floating = false;
        Dataset ds = this.dataService.create(dims, name, axes, bpp, signed, floating);
        if (bitsPerPixel == 24) {
            ds.setRGBMerged(true);
        }
        return ds;
    }
}

