/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.fits;

import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.janelia.thickness.inference.Options;
import org.janelia.thickness.lut.AbstractLUTRealTransform;

public abstract class AbstractCorrelationFit {
    public <T extends RealType<T>, W extends RealType<W>> RandomAccessibleInterval<double[]> estimateFromMatrix(RandomAccessibleInterval<T> correlations, double[] coordinates, AbstractLUTRealTransform transform, RandomAccessibleInterval<W> estimateWeightMatrix, Options options, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory) {
        int range = options.comparisonRange;
        boolean forceMonotonicity = options.forceMonotonicity;
        RealType correlationsNaNExtension = (RealType)((RealType)correlations.randomAccess().get()).copy();
        correlationsNaNExtension.setReal(Double.NaN);
        RealRandomAccessible extendedInterpolatedCorrelations = Views.interpolate((EuclideanSpace)Views.extendValue(correlations, (Type)correlationsNaNExtension), interpolatorFactory);
        RealTransformRealRandomAccessible transformedCorrelations = RealViews.transformReal((RealRandomAccessible)extendedInterpolatedCorrelations, (InvertibleRealTransform)transform);
        RealRandomAccessible extendedInterpolatedWeights = Views.interpolate((EuclideanSpace)Views.extendBorder(estimateWeightMatrix), (InterpolatorFactory)new NLinearInterpolatorFactory());
        RealTransformRealRandomAccessible transformedWeights = RealViews.transformReal((RealRandomAccessible)extendedInterpolatedWeights, (InvertibleRealTransform)transform);
        RealTransformRealRandomAccessible.RealTransformRealRandomAccess access1 = transformedCorrelations.realRandomAccess();
        RealTransformRealRandomAccessible.RealTransformRealRandomAccess access2 = transformedCorrelations.realRandomAccess();
        RealTransformRealRandomAccessible.RealTransformRealRandomAccess wAccess1 = transformedWeights.realRandomAccess();
        RealTransformRealRandomAccessible.RealTransformRealRandomAccess wAccess2 = transformedWeights.realRandomAccess();
        this.init(range);
        for (int z = 0; z < coordinates.length; ++z) {
            access1.setPosition(z, 1);
            access1.setPosition(z, 0);
            transform.apply((RealLocalizable)access1, (RealPositionable)access1);
            access2.setPosition((RealLocalizable)access1);
            wAccess1.setPosition((RealLocalizable)access1);
            wAccess2.setPosition((RealLocalizable)access1);
            double currentMin1 = Double.MAX_VALUE;
            double currentMin2 = Double.MAX_VALUE;
            for (int k = 0; k <= range; ++k) {
                double a1 = ((RealType)access1.get()).getRealDouble();
                double a2 = ((RealType)access2.get()).getRealDouble();
                if (!Double.isNaN(a1) && a1 > 0.0 && (!forceMonotonicity || a1 < currentMin1)) {
                    currentMin1 = a1;
                    this.add(z, k, a1, ((RealType)wAccess1.get()).getRealDouble());
                }
                if (!Double.isNaN(a2) && a2 > 0.0 && (!forceMonotonicity || a2 < currentMin2)) {
                    currentMin2 = a2;
                    this.add(z, k, a2, ((RealType)wAccess2.get()).getRealDouble());
                }
                access1.fwd(0);
                access2.bck(0);
                wAccess1.fwd(0);
                wAccess2.bck(0);
            }
        }
        return this.estimate(coordinates.length);
    }

    protected abstract void add(int var1, int var2, double var3, double var5);

    protected abstract void init(int var1);

    protected abstract RandomAccessibleInterval<double[]> estimate(int var1);
}

