/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.visitor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.janelia.thickness.inference.visitor.CSVVisitor;

public class CorrelationFitVisitor
extends CSVVisitor {
    private int range;

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public CorrelationFitVisitor(String basePath, String relativeFilePattern, String separator, int range) {
        super(basePath, relativeFilePattern, separator);
        this.range = range;
    }

    @Override
    public <T extends RealType<T>> void act(int iteration, RandomAccessibleInterval<T> matrix, RandomAccessibleInterval<T> scaledMatrix, double[] lut, int[] permutation, int[] inversePermutation, double[] multipliers, RandomAccessibleInterval<double[]> estimatedFits) {
        if (estimatedFits == null) {
            return;
        }
        try {
            String path = this.fileDir(iteration);
            this.createParentDirectory(path);
            IterableInterval iterable = Views.iterable(estimatedFits);
            this.write(new CSVVisitor.IndexedIterable<String>(this.separator, new ArrayIterable((Iterable<double[]>)iterable)), path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class ArrayIterable
    implements Iterable<String> {
        private final Iterable<double[]> data;

        public ArrayIterable(Iterable<double[]> data) {
            this.data = data;
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<double[]> it = this.data.iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    double[] d = (double[])it.next();
                    return Arrays.toString(d).substring(1, d.length - 1);
                }
            };
        }
    }
}

