/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.utility.arrays;

import java.util.Arrays;

public class ReplaceNaNs {
    public static void replace(double[] array) {
        double val;
        int d;
        int lastElement = array.length - 1;
        double currentLower = array[0];
        if (Double.isNaN(currentLower)) {
            for (d = 1; d < array.length; ++d) {
                val = array[d];
                if (Double.isNaN(val)) continue;
                array[0] = currentLower = val - (double)d;
                break;
            }
        }
        for (d = 0; d < array.length; ++d) {
            val = array[d];
            if (Double.isNaN(val)) {
                int start = d;
                int currentLowerIndex = start - 1;
                double currentUpper = array[d];
                while (Double.isNaN(currentUpper)) {
                    if (++d == array.length) {
                        if (!Double.isNaN(currentUpper)) break;
                        currentUpper = currentLower + (double)d + (double)(-currentLowerIndex);
                        break;
                    }
                    currentUpper = array[d];
                }
                double normalize = 1.0 / (double)(d + -currentLowerIndex);
                double diff = currentUpper - currentLower;
                for (int s = start; s < d; ++s) {
                    array[s] = (double)(s - start + 1) * normalize * diff + currentLower;
                }
                if (d >= array.length) continue;
                currentLower = array[d];
                continue;
            }
            currentLower = val;
        }
    }

    public static void main(String[] args) {
        double[] array = new double[]{Double.NaN, Double.NaN, 3.0, Double.NaN, Double.NaN, 6.0, Double.NaN, 8.0, 9.0, Double.NaN};
        System.out.println(Arrays.toString(array));
        ReplaceNaNs.replace(array);
        System.out.println(Arrays.toString(array));
    }
}

