/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui;

import io.scif.services.DatasetIOService;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import net.imagej.Dataset;
import org.scijava.Context;
import org.scijava.ui.ApplicationFrame;
import org.scijava.ui.UIService;
import org.scijava.widget.UIComponent;
import sc.fiji.labkit.pixel_classification.utils.SingletonContext;
import sc.fiji.labkit.ui.InitialLabeling;
import sc.fiji.labkit.ui.MenuBar;
import sc.fiji.labkit.ui.SegmentationComponent;
import sc.fiji.labkit.ui.inputimage.DatasetInputImage;
import sc.fiji.labkit.ui.inputimage.InputImage;
import sc.fiji.labkit.ui.models.DefaultSegmentationModel;
import sc.fiji.labkit.ui.models.SegmentationModel;
import sc.fiji.labkit.ui.utils.Notifier;

public class LabkitFrame {
    private final JFrame frame = this.initFrame();
    private final Notifier onCloseListeners = new Notifier();

    public static LabkitFrame showForFile(Context context, String filename) {
        if (context == null) {
            context = SingletonContext.getInstance();
        }
        Dataset dataset = LabkitFrame.openDataset(context, filename);
        return LabkitFrame.showForImage(context, new DatasetInputImage(dataset));
    }

    private static Dataset openDataset(Context context, String filename) {
        try {
            return ((DatasetIOService)context.service(DatasetIOService.class)).open(filename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LabkitFrame showForImage(Context context, InputImage inputImage) {
        if (context == null) {
            context = SingletonContext.getInstance();
        }
        DefaultSegmentationModel model = new DefaultSegmentationModel(context, inputImage);
        model.imageLabelingModel().labeling().set(InitialLabeling.initialLabeling(context, inputImage));
        return LabkitFrame.show(model, inputImage.imageForSegmentation().getName());
    }

    public static LabkitFrame show(SegmentationModel model, String title) {
        return new LabkitFrame(model, title);
    }

    private LabkitFrame(SegmentationModel model, String title) {
        SegmentationComponent segmentationComponent = this.initSegmentationComponent(model);
        this.setTitle(title);
        this.frame.setIconImage(this.getImageJIcon(model.context()));
        this.frame.setJMenuBar(new MenuBar(segmentationComponent::createMenu));
        this.frame.setVisible(true);
    }

    private Image getImageJIcon(Context context) {
        try {
            Object uic;
            UIService uiService = (UIService)context.service(UIService.class);
            ApplicationFrame applicationFrame = uiService.getDefaultUI().getApplicationFrame();
            Frame frame = null;
            if (applicationFrame instanceof Frame) {
                frame = (Frame)applicationFrame;
            } else if (applicationFrame instanceof UIComponent && (uic = ((UIComponent)applicationFrame).getComponent()) instanceof Frame) {
                frame = (Frame)uic;
            }
            return frame == null ? null : frame.getIconImage();
        }
        catch (Exception e) {
            return null;
        }
    }

    private SegmentationComponent initSegmentationComponent(SegmentationModel segmentationModel) {
        final SegmentationComponent segmentationComponent = new SegmentationComponent(this.frame, segmentationModel, false);
        this.frame.add(segmentationComponent);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                segmentationComponent.close();
                LabkitFrame.this.onCloseListeners.notifyListeners();
            }
        });
        return segmentationComponent;
    }

    private JFrame initFrame() {
        JFrame frame = new JFrame();
        frame.setBounds(50, 50, 1200, 900);
        frame.setDefaultCloseOperation(2);
        return frame;
    }

    private void setTitle(String name) {
        if (name == null || name.isEmpty()) {
            this.frame.setTitle("Labkit");
        } else {
            this.frame.setTitle("Labkit - " + name);
        }
    }

    public Notifier onCloseListeners() {
        return this.onCloseListeners;
    }
}

