/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.bdv;

import bdv.tools.brightness.ConverterSetup;
import bdv.util.AxisOrder;
import bdv.util.BdvFunctions;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import sc.fiji.labkit.ui.bdv.BdvShowable;

class ImgPlusBdvShowable
implements BdvShowable {
    private final ImgPlus<? extends NumericType<?>> image;
    private static final List<ARGBType> CHANNEL_COLORS = Stream.of(Color.red, Color.green, Color.blue, Color.white, Color.cyan, Color.magenta, Color.yellow).mapToInt(Color::getRGB).mapToObj(ARGBType::new).collect(Collectors.toList());

    ImgPlusBdvShowable(ImgPlus<? extends NumericType<?>> image) {
        this.image = image;
    }

    @Override
    public Interval interval() {
        return this.image;
    }

    @Override
    public AffineTransform3D transformation() {
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(this.getCalibration(Axes.X), 0.0, 0.0, 0.0, 0.0, this.getCalibration(Axes.Y), 0.0, 0.0, 0.0, 0.0, this.getCalibration(Axes.Z), 0.0);
        return transform;
    }

    @Override
    public BdvStackSource<?> show(String title, BdvOptions options) {
        String name = this.image.getName();
        BdvOptions options1 = options.axisOrder(this.getAxisOrder()).sourceTransform(this.transformation());
        BdvStackSource stackSource = BdvFunctions.show(this.image, (String)(name == null ? title : name), (BdvOptions)options1);
        List converterSetups = stackSource.getConverterSetups();
        this.setChannelMinMax(converterSetups);
        this.setChannelColors(converterSetups);
        return stackSource;
    }

    private void setChannelColors(List<ConverterSetup> converterSetups) {
        if (converterSetups.size() == 1) {
            return;
        }
        for (int i = 0; i < Math.min(converterSetups.size(), CHANNEL_COLORS.size()); ++i) {
            converterSetups.get(i).setColor(CHANNEL_COLORS.get(i));
        }
    }

    private void setChannelMinMax(List<ConverterSetup> converterSetups) {
        if ((long)converterSetups.size() != this.image.dimension(this.image.dimensionIndex(Axes.CHANNEL))) {
            return;
        }
        for (int i = 0; i < converterSetups.size(); ++i) {
            ConverterSetup converterSetup = converterSetups.get(i);
            double channelMinimum = this.image.getChannelMinimum(i);
            double channelMaximum = this.image.getChannelMaximum(i);
            if (Double.isNaN(channelMinimum) || Double.isNaN(channelMaximum)) continue;
            converterSetup.setDisplayRange(channelMinimum, channelMaximum);
        }
    }

    private AxisOrder getAxisOrder() {
        String code = IntStream.range(0, this.image.numDimensions()).mapToObj(i -> ((CalibratedAxis)this.image.axis(i)).type().getLabel().substring(0, 1)).collect(Collectors.joining());
        try {
            return AxisOrder.valueOf((String)code);
        }
        catch (IllegalArgumentException e) {
            return AxisOrder.DEFAULT;
        }
    }

    private double getCalibration(AxisType axisType) {
        int d = this.image.dimensionIndex(axisType);
        if (d == -1) {
            return 1.0;
        }
        return ((CalibratedAxis)this.image.axis(d)).averageScale((double)this.image.min(d), (double)this.image.max(d));
    }
}

