/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.FloatPolygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class KymographMouseListener
implements MouseMotionListener,
WindowListener {
    protected ImageCanvas canvas;
    protected ImagePlus original;
    protected PolygonRoi[] rois;

    public KymographMouseListener(ImageCanvas canvas, ImagePlus original, PolygonRoi[] rois) {
        this.canvas = canvas;
        this.original = original;
        this.rois = rois;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = this.canvas.offScreenX(e.getX());
        int y = this.canvas.offScreenY(e.getY());
        this.original.setSlice(y + 1);
        PolygonRoi roi = this.rois[y];
        if (roi == null) {
            this.original.setOverlay(null);
            this.original.killRoi();
            return;
        }
        FloatPolygon polygon = roi.getFloatPolygon();
        if (polygon.npoints <= x) {
            return;
        }
        int x2 = (int)polygon.xpoints[x];
        int y2 = (int)polygon.ypoints[x];
        this.original.setOverlay(new Overlay((Roi)new PointRoi(x2, y2)));
        this.original.setRoi((Roi)roi);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.canvas.removeMouseMotionListener((MouseMotionListener)this);
        this.original.setOverlay(null);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

