/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.LabelImgExporterPanel;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.SpotUtil;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.GlasbeyLut;
import ij.ImagePlus;
import java.awt.Frame;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

public class LabelImgExporter
extends AbstractTMAction {
    public static final String INFO_TEXT = "<html>This action creates a label image from the tracking results. <p> A new 32-bit image is generated, of same dimension and size that of the input image. The label image has one channel, with black background (0 value) everywhere, except where there are spots. Each spot is painted with a uniform integer value, configurable to be the spot ID, the ID of the track it belongs to, or a simple index, unique to the frame or to the movie. <p> Only visible spots are painted. </html>";
    public static final String KEY = "EXPORT_LABEL_IMG";
    public static final String NAME = "Export label image";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame gui) {
        LabelIdPainting labelIdPainting;
        boolean exportTracksOnly;
        boolean exportSpotsAsDots;
        if (gui != null) {
            LabelImgExporterPanel panel = new LabelImgExporterPanel();
            int userInput = JOptionPane.showConfirmDialog(gui, panel, "Export to label image", 2, 3, Icons.TRACKMATE_ICON);
            if (userInput != 0) {
                return;
            }
            exportSpotsAsDots = panel.isExportSpotsAsDots();
            exportTracksOnly = panel.isExportTracksOnly();
            labelIdPainting = panel.labelIdPainting();
        } else {
            exportSpotsAsDots = false;
            exportTracksOnly = false;
            labelIdPainting = LabelIdPainting.LABEL_IS_INDEX_MOVIE_UNIQUE;
        }
        LabelImgExporter.createLabelImagePlus(trackmate, exportSpotsAsDots, exportTracksOnly, labelIdPainting, this.logger).show();
    }

    public static final ImagePlus createLabelImagePlus(TrackMate trackmate, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labeIdPainting) {
        return LabelImgExporter.createLabelImagePlus(trackmate, exportSpotsAsDots, exportTracksOnly, labeIdPainting, Logger.VOID_LOGGER);
    }

    public static final ImagePlus createLabelImagePlus(TrackMate trackmate, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labelIdPainting, Logger logger) {
        return LabelImgExporter.createLabelImagePlus(trackmate.getModel(), trackmate.getSettings().imp, exportSpotsAsDots, exportTracksOnly, labelIdPainting, logger);
    }

    public static final ImagePlus createLabelImagePlus(Model model, ImagePlus imp, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labelIdPainting) {
        return LabelImgExporter.createLabelImagePlus(model, imp, exportSpotsAsDots, exportTracksOnly, labelIdPainting, Logger.VOID_LOGGER);
    }

    public static final ImagePlus createLabelImagePlus(Model model, ImagePlus imp, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labelIdPainting, Logger logger) {
        int[] dimensions = imp.getDimensions();
        int[] dims = new int[]{dimensions[0], dimensions[1], dimensions[3], dimensions[4]};
        double[] calibration = new double[]{imp.getCalibration().pixelWidth, imp.getCalibration().pixelHeight, imp.getCalibration().pixelDepth, imp.getCalibration().frameInterval};
        ImagePlus lblImp = LabelImgExporter.createLabelImagePlus(model, dims, calibration, exportSpotsAsDots, exportTracksOnly, labelIdPainting, logger);
        lblImp.setCalibration(imp.getCalibration().copy());
        lblImp.setTitle("LblImg_" + imp.getTitle());
        return lblImp;
    }

    public static final ImagePlus createLabelImagePlus(Model model, int[] dimensions, double[] calibration, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labelIdPainting) {
        return LabelImgExporter.createLabelImagePlus(model, dimensions, calibration, exportSpotsAsDots, exportTracksOnly, labelIdPainting, Logger.VOID_LOGGER);
    }

    public static final ImagePlus createLabelImagePlus(Model model, int[] dimensions, double[] calibration, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labelIdPainting, Logger logger) {
        long[] dims = new long[4];
        for (int d = 0; d < dims.length; ++d) {
            dims[d] = dimensions[d];
        }
        ImagePlus lblImp = ImageJFunctions.wrap(LabelImgExporter.createLabelImg(model, dims, calibration, exportSpotsAsDots, exportTracksOnly, labelIdPainting, logger), (String)"LblImage");
        lblImp.setDimensions(1, dimensions[2], dimensions[3]);
        lblImp.setLut(GlasbeyLut.toLUT());
        lblImp.setDisplayRange(0.0, 255.0);
        lblImp.setOpenAsHyperStack(true);
        return lblImp;
    }

    public static final Img<FloatType> createLabelImg(Model model, long[] dimensions, double[] calibration, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labelIdPainting) {
        return LabelImgExporter.createLabelImg(model, dimensions, calibration, exportSpotsAsDots, exportTracksOnly, labelIdPainting, Logger.VOID_LOGGER);
    }

    public static final Img<FloatType> createLabelImg(Model model, long[] dimensions, double[] calibration, boolean exportSpotsAsDots, boolean exportTracksOnly, LabelIdPainting labelIdPainting, Logger logger) {
        FinalDimensions targetSize = FinalDimensions.wrap((long[])dimensions);
        Img lblImg = Util.getArrayOrCellImgFactory((Dimensions)targetSize, (NativeType)new FloatType()).create((Dimensions)targetSize);
        AxisType[] axes = new AxisType[]{Axes.X, Axes.Y, Axes.Z, Axes.TIME};
        ImgPlus imgPlus = new ImgPlus(lblImg, "LblImg", axes, calibration);
        IdGenerator idGenerator = labelIdPainting.idGenerator(model.getTrackModel(), exportTracksOnly);
        logger.log("Writing label image.\n");
        int frame = 0;
        while ((long)frame < dimensions[3]) {
            ImgPlus imgCT = TMUtils.hyperSlice(imgPlus, 0L, frame);
            SpotWriter spotWriter = exportSpotsAsDots ? new SpotAsDotWriter(imgCT) : new SpotRoiWriter(imgCT);
            idGenerator.nextFrame();
            for (Spot spot : model.getSpots().iterable(frame, true)) {
                int id = idGenerator.id(spot);
                spotWriter.write(spot, id);
            }
            logger.setProgress((double)(1 + frame) / (double)dimensions[3]);
            ++frame;
        }
        logger.log("Done.\n");
        return lblImg;
    }

    public static <T extends RealType<T> & NativeType<T>> ImgPlus<T> createLabelImg(SpotCollection spots, long[] dimensions, double[] calibration, boolean exportSpotsAsDots, LabelIdPainting labelIdPainting, T outputType, Logger logger) {
        FinalDimensions targetSize = FinalDimensions.wrap((long[])dimensions);
        Img lblImg = Util.getArrayOrCellImgFactory((Dimensions)targetSize, outputType).create((Dimensions)targetSize);
        AxisType[] axes = new AxisType[]{Axes.X, Axes.Y, Axes.Z, Axes.TIME};
        ImgPlus imgPlus = new ImgPlus(lblImg, "LblImg", axes, calibration);
        AbstractIdGenerator idGenerator = switch (labelIdPainting.ordinal()) {
            case 2 -> new SpotIndexGeneratorUniqueInFrame(null, false);
            case 3 -> new SpotIndexGeneratorUniqueInMovie(null, false);
            case 0, 1 -> new SpotIdGenerator(null, false);
            default -> throw new IllegalArgumentException("Unknown painting method: " + String.valueOf((Object)labelIdPainting));
        };
        logger.log("Writing label image.\n");
        int frame = 0;
        while ((long)frame < dimensions[3]) {
            ImgPlus imgCT = TMUtils.hyperSlice(imgPlus, 0L, frame);
            SpotWriter spotWriter = exportSpotsAsDots ? new SpotAsDotWriter(imgCT) : new SpotRoiWriter(imgCT);
            idGenerator.nextFrame();
            for (Spot spot : spots.iterable(frame, true)) {
                int id = idGenerator.id(spot);
                spotWriter.write(spot, id);
            }
            logger.setProgress((double)(1 + frame) / (double)dimensions[3]);
            ++frame;
        }
        logger.log("Done.\n");
        return imgPlus;
    }

    public static enum LabelIdPainting {
        LABEL_IS_TRACK_ID("Track ID", "The spot label is the ID of the track it belongs to, plus one (+1). Spots that do not belong to tracks are painted with a unique integer larger than the last trackID in the dataset."),
        LABEL_IS_SPOT_ID("Spot ID", "The spot label is the spot ID, plus one (+1)."),
        LABEL_IS_INDEX("Index unique in frame", "The spot label is an index starting from 1. It is unique within a frame, but can be repeated across frames."),
        LABEL_IS_INDEX_MOVIE_UNIQUE("Unique index", "The spot label is an index starting from 1. It is unique within the whole movie.");

        private final String info;
        private final String methodName;

        private LabelIdPainting(String methodName, String info) {
            this.methodName = methodName;
            this.info = info;
        }

        public String toString() {
            return this.methodName;
        }

        public String getInfo() {
            return this.info;
        }

        public IdGenerator idGenerator(TrackModel tm, boolean visibleTracksOnly) {
            switch (this.ordinal()) {
                case 2: {
                    return new SpotIndexGeneratorUniqueInFrame(tm, visibleTracksOnly);
                }
                case 3: {
                    return new SpotIndexGeneratorUniqueInMovie(tm, visibleTracksOnly);
                }
                case 1: {
                    return new SpotIdGenerator(tm, visibleTracksOnly);
                }
                case 0: {
                    return new TrackIdGenerator(tm, visibleTracksOnly);
                }
            }
            throw new IllegalArgumentException("Unknown painting id mode: " + String.valueOf((Object)this));
        }
    }

    private static interface IdGenerator {
        public int id(Spot var1);

        default public void nextFrame() {
        }
    }

    public static final class SpotAsDotWriter<T extends RealType<T>>
    implements SpotWriter {
        private final double[] calibration;
        private final long[] center;
        private final RandomAccess<T> ra;

        public SpotAsDotWriter(ImgPlus<T> img) {
            this.calibration = TMUtils.getSpatialCalibration(img);
            this.center = new long[img.numDimensions()];
            this.ra = Views.extendZero(img).randomAccess();
        }

        @Override
        public void write(Spot spot, int id) {
            for (int d = 0; d < this.center.length; ++d) {
                this.center[d] = Math.round(spot.getFeature(Spot.POSITION_FEATURES[d]) / this.calibration[d]);
            }
            this.ra.setPosition(this.center);
            ((RealType)this.ra.get()).setReal((float)id);
        }
    }

    public static final class SpotRoiWriter<T extends RealType<T>>
    implements SpotWriter {
        private final ImgPlus<T> img;

        public SpotRoiWriter(ImgPlus<T> img) {
            this.img = img;
        }

        @Override
        public void write(Spot spot, int id) {
            for (RealType pixel : SpotUtil.iterable(spot, this.img)) {
                pixel.setReal((float)id);
            }
        }
    }

    public static interface SpotWriter {
        public void write(Spot var1, int var2);
    }

    private static class SpotIndexGeneratorUniqueInFrame
    extends SpotIndexGeneratorUniqueInMovie {
        public SpotIndexGeneratorUniqueInFrame(TrackModel tm, boolean visibleTracksOnly) {
            super(tm, visibleTracksOnly);
        }

        @Override
        public void nextFrame() {
            this.index.set(0);
        }
    }

    private static class SpotIndexGeneratorUniqueInMovie
    extends AbstractIdGenerator {
        protected final AtomicInteger index = new AtomicInteger(0);

        public SpotIndexGeneratorUniqueInMovie(TrackModel tm, boolean visibleTracksOnly) {
            super(tm, visibleTracksOnly);
        }

        @Override
        public int id(Spot spot) {
            Integer trackID;
            if (this.tm != null && (null == (trackID = this.tm.trackIDOf(spot)) || !this.tm.isVisible(trackID)) && this.visibleTracksOnly) {
                return -1;
            }
            return this.index.incrementAndGet();
        }
    }

    private static class SpotIdGenerator
    extends AbstractIdGenerator {
        public SpotIdGenerator(TrackModel tm, boolean visibleTracksOnly) {
            super(tm, visibleTracksOnly);
        }

        @Override
        public int id(Spot spot) {
            Integer trackID;
            if (this.tm != null && (null == (trackID = this.tm.trackIDOf(spot)) || !this.tm.isVisible(trackID)) && this.visibleTracksOnly) {
                return -1;
            }
            return spot.ID() + 1;
        }
    }

    private static class TrackIdGenerator
    extends AbstractIdGenerator {
        private final AtomicInteger lonelySpotID;

        public TrackIdGenerator(TrackModel tm, boolean visibleTracksOnly) {
            super(tm, visibleTracksOnly);
            int maxTrackID = -1;
            Set<Integer> trackIDs = tm.trackIDs(false);
            if (null != trackIDs) {
                for (Integer trackID : trackIDs) {
                    if (trackID <= maxTrackID) continue;
                    maxTrackID = trackID;
                }
            }
            this.lonelySpotID = new AtomicInteger(maxTrackID + 2);
        }

        @Override
        public int id(Spot spot) {
            Integer trackID = this.tm.trackIDOf(spot);
            if (null == trackID || !this.tm.isVisible(trackID)) {
                if (this.visibleTracksOnly) {
                    return -1;
                }
                return this.lonelySpotID.getAndIncrement();
            }
            return trackID + 1;
        }
    }

    private static abstract class AbstractIdGenerator
    implements IdGenerator {
        protected final TrackModel tm;
        protected final boolean visibleTracksOnly;

        public AbstractIdGenerator(TrackModel tm, boolean visibleTracksOnly) {
            this.tm = tm;
            this.visibleTracksOnly = visibleTracksOnly;
        }
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return LabelImgExporter.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return LabelImgExporter.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new LabelImgExporter();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.LABEL_IMG_ICON;
        }

        @Override
        public String getName() {
            return LabelImgExporter.NAME;
        }
    }
}

