/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection.semiauto;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.LogDetector;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.util.Threads;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.Algorithm;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public abstract class AbstractSemiAutoTracker<T extends RealType<T> & NativeType<T>>
implements Algorithm,
MultiThreaded {
    protected static final double NEIGHBORHOOD_FACTOR = 2.0;
    protected static final String BASE_ERROR_MESSAGE = "[SemiAutoTracker] ";
    private static final double QUALITY_THRESHOLD = 0.2;
    private static final double DISTANCE_TOLERANCE = 1.1;
    private final Model model;
    private final SelectionModel selectionModel;
    protected String errorMessage;
    private int numThreads;
    protected boolean ok;
    protected final Logger logger;
    protected double distanceTolerance = 1.1;
    protected double qualityThreshold = 0.2;
    private int nFrames;

    public AbstractSemiAutoTracker(Model model, SelectionModel selectionModel, Logger logger) {
        this.model = model;
        this.selectionModel = selectionModel;
        this.logger = logger;
    }

    public void setParameters(double qualityThreshold, double distanceTolerance, int nFrames) {
        this.qualityThreshold = qualityThreshold;
        this.distanceTolerance = distanceTolerance;
        this.nFrames = nFrames;
    }

    public boolean process() {
        HashSet<Spot> spots = new HashSet<Spot>(this.selectionModel.getSpotSelection());
        if (spots.isEmpty()) {
            this.errorMessage = "[SemiAutoTracker] No spots in selection.\n";
            return false;
        }
        this.selectionModel.clearSelection();
        this.ok = true;
        int nThreads = Math.min(this.numThreads, spots.size());
        ExecutorService executors = Threads.newFixedThreadPool(nThreads);
        ArrayList futures = new ArrayList(spots.size());
        for (Spot spot : spots) {
            Future<?> future = executors.submit(() -> this.processSpot(spot));
            futures.add(future);
        }
        try {
            for (Future future : futures) {
                future.get();
            }
            executors.shutdown();
        }
        catch (InterruptedException | ExecutionException e) {
            this.ok = false;
            this.errorMessage = e.getMessage();
            e.printStackTrace();
        }
        return this.ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSpot(Spot initialSpot) {
        Spot spot = initialSpot;
        int nSpotProcessed = 0;
        while (this.nFrames < 1 || nSpotProcessed < this.nFrames) {
            ++nSpotProcessed;
            int frame = spot.getFeature("FRAME").intValue() + 1;
            double radius = spot.getFeature("RADIUS");
            double quality = spot.getFeature("QUALITY");
            SearchRegion<T> sn = this.getNeighborhood(spot, frame);
            if (null == sn) {
                return;
            }
            RandomAccessible source = sn.source;
            Interval interval = sn.interval;
            AffineTransform3D transform = sn.transform;
            double[] calibration = sn.calibration;
            SpotDetector detector = this.createDetector(source, interval, calibration, radius, quality * this.qualityThreshold);
            if (!detector.checkInput() || !detector.process()) {
                this.ok = false;
                this.errorMessage = detector.getErrorMessage();
                return;
            }
            List detectedSpots = (List)detector.getResult();
            if (detectedSpots.isEmpty()) {
                this.logger.log("Spot: " + String.valueOf(initialSpot) + ": No suitable spot found.\n");
                return;
            }
            String[] features = new String[]{"POSITION_X", "POSITION_Y", "POSITION_Z"};
            for (Spot ds : detectedSpots) {
                double[] coords = new double[3];
                ds.localize(coords);
                double[] target = new double[3];
                transform.apply(coords, target);
                for (int i = 0; i < target.length; ++i) {
                    ds.putFeature(features[i], target[i]);
                }
            }
            Collections.sort(detectedSpots, Spot.featureComparator("QUALITY"));
            Collections.reverse(detectedSpots);
            boolean found = false;
            Spot target = null;
            for (Spot candidate : detectedSpots) {
                if (!(candidate.squareDistanceTo(spot) < this.distanceTolerance * this.distanceTolerance * radius * radius)) continue;
                found = true;
                target = candidate;
                break;
            }
            if (!found || target == null) {
                this.logger.log("Spot: " + String.valueOf(initialSpot) + ": Suitable spot found, but outside the tolerance radius.\n");
                return;
            }
            target.putFeature("POSITION_T", Double.valueOf(frame));
            this.exposeSpot(target, spot);
            target.putFeature("RADIUS", radius);
            this.model.beginUpdate();
            try {
                this.model.addSpotTo(target, frame);
                this.model.addEdge(spot, target, spot.squareDistanceTo(target));
            }
            finally {
                this.model.endUpdate();
            }
            spot = target;
        }
        if (nSpotProcessed > 0) {
            this.logger.log("Finished semi-auto tracking after processing " + nSpotProcessed + " spots from " + String.valueOf(initialSpot) + " to " + String.valueOf(spot) + ".\n");
        }
    }

    protected abstract void exposeSpot(Spot var1, Spot var2);

    protected abstract SearchRegion<T> getNeighborhood(Spot var1, int var2);

    protected SpotDetector<T> createDetector(RandomAccessible<T> img, Interval interval, double[] calibration, double radius, double quality) {
        LogDetector<T> detector = new LogDetector<T>(img, interval, calibration, radius, quality, true, false);
        detector.setNumThreads(1);
        return detector;
    }

    public boolean checkInput() {
        if (null == this.model) {
            this.errorMessage = "[SemiAutoTracker] model is null.\n";
            return false;
        }
        if (null == this.selectionModel) {
            this.errorMessage = "[SemiAutoTracker] selectionModel is null.\n";
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public static class SearchRegion<R> {
        public RandomAccessible<R> source;
        public double[] calibration;
        public Interval interval;
        public AffineTransform3D transform;
    }
}

