/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kalman;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.tracker.AdvancedKalmanTrackerSettingsPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.tracking.TrackerKeys;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import fiji.plugin.trackmate.tracking.jaqaman.SegmentTrackerFactory;
import fiji.plugin.trackmate.tracking.kalman.AdvancedKalmanTracker;
import fiji.plugin.trackmate.tracking.kalman.KalmanTrackerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jdom2.Content;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotTrackerFactory.class)
public class AdvancedKalmanTrackerFactory
extends SegmentTrackerFactory {
    public static final String THIS_TRACKER_KEY = "ADVANCED_KALMAN_TRACKER";
    public static final String THIS_NAME = "Advanced Kalman Tracker";
    public static final String THIS_INFO_TEXT = "<html>This tracker is an extended version of the Kalman tracker, that adds the possibility to customize linking costs and detect track fusion (segments merging) and track division (segments splitting). <p> This tracker is especially well suited to objects that move following a nearly constant velocity vector. The velocity vectors of each object can be completely different from one another. But for the velocity vector of one object need not to change too much from one frame to another. <p> In the frame-to-frame linking step, the classic Kalman tracker infer most likely spot positions in the target frame from growing tracks and link all extrapolated positions against all spots in the target frame, based on the square distance. This advanced version of the tracker allows for penalizing links to spots with different features values using the same framework that of the LAP tracker in TrackMate. Also, after the frame-to-frame linking step, track segments are post-processed to detect splitting and merging events, and perform gap-closing. This is again based on the LAP tracker implementation. </html>";

    @Override
    public String getInfoText() {
        return THIS_INFO_TEXT;
    }

    @Override
    public String getKey() {
        return THIS_TRACKER_KEY;
    }

    @Override
    public String getName() {
        return THIS_NAME;
    }

    @Override
    public ImageIcon getIcon() {
        return KalmanTrackerFactory.ICON;
    }

    @Override
    public SpotTracker create(SpotCollection spots, Map<String, Object> settings) {
        return new AdvancedKalmanTracker(spots, settings);
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        Map<String, Object> settings = LAPUtils.getDefaultSegmentSettingsMap();
        settings.put("LINKING_MAX_DISTANCE", 15.0);
        settings.put("KALMAN_SEARCH_RADIUS", 20.0);
        settings.put("LINKING_FEATURE_PENALTIES", new HashMap<String, Double>(TrackerKeys.DEFAULT_LINKING_FEATURE_PENALTIES));
        return settings;
    }

    @Override
    public String marshal(Map<String, Object> settings, Element element) {
        boolean ok = true;
        StringBuilder str = new StringBuilder();
        ok &= IOUtils.writeAttribute(settings, element, "KALMAN_SEARCH_RADIUS", Double.class, str);
        Element linkingElement = new Element("Linking");
        ok &= IOUtils.writeAttribute(settings, linkingElement, "LINKING_MAX_DISTANCE", Double.class, str);
        Map lfpm = (Map)settings.get("LINKING_FEATURE_PENALTIES");
        Element lfpElement = new Element("FeaturePenalties");
        IOUtils.marshallMap(lfpm, lfpElement);
        linkingElement.addContent((Content)lfpElement);
        element.addContent((Content)linkingElement);
        if (!ok) {
            return str.toString();
        }
        return super.marshal(settings, element);
    }

    @Override
    public String unmarshal(Element element, Map<String, Object> settings) {
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = this.unmarshallSegment(element, settings, errorHolder);
        ok &= IOUtils.readDoubleAttribute(element, settings, "KALMAN_SEARCH_RADIUS", errorHolder);
        Element linkingElement = element.getChild("Linking");
        if (null == linkingElement) {
            errorHolder.append("Could not found the Linking element in XML.\n");
            ok = false;
        } else {
            ok &= IOUtils.readDoubleAttribute(linkingElement, settings, "LINKING_MAX_DISTANCE", errorHolder);
            HashMap<String, Double> lfpMap = new HashMap<String, Double>();
            Element lfpElement = linkingElement.getChild("FeaturePenalties");
            if (null != lfpElement) {
                ok &= IOUtils.unmarshallMap(lfpElement, lfpMap, errorHolder);
            }
            settings.put("LINKING_FEATURE_PENALTIES", lfpMap);
        }
        String error = this.checkSettings(settings);
        if (null != error) {
            ok = false;
            errorHolder.append(error);
        }
        if (!ok) {
            return errorHolder.toString();
        }
        return null;
    }

    @Override
    public String checkSettings(Map<String, Object> settings) {
        if (null == settings) {
            return "Settings map is null.\n";
        }
        StringBuilder str = new StringBuilder();
        if (!LAPUtils.checkSettingsValidity(settings, str, true)) {
            return str.toString();
        }
        return null;
    }

    @Override
    public String toString(Map<String, Object> sm) {
        String error = this.checkSettings(sm);
        if (null != error) {
            return error;
        }
        StringBuilder str = new StringBuilder();
        double maxSearchRadius = (Double)sm.get("KALMAN_SEARCH_RADIUS");
        double initialSearchRadius = (Double)sm.get("LINKING_MAX_DISTANCE");
        str.append(String.format("  - initial search radius: %.1f\n", initialSearchRadius));
        str.append(String.format("  - search radius: %.1f\n", maxSearchRadius));
        str.append("  Linking conditions:\n");
        str.append(LAPUtils.echoFeaturePenalties((Map)sm.get("LINKING_FEATURE_PENALTIES")));
        str.append(super.toString(sm));
        return str.toString();
    }

    @Override
    public ConfigurationPanel getTrackerConfigurationPanel(Model model) {
        String spaceUnits = model.getSpaceUnits();
        Collection<String> features = model.getFeatureModel().getSpotFeatures();
        Map<String, String> featureNames = model.getFeatureModel().getSpotFeatureNames();
        return new AdvancedKalmanTrackerSettingsPanel(this.getName(), spaceUnits, features, featureNames);
    }
}

