/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.FileChooser;
import fiji.plugin.trackmate.visualization.table.TablePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class ExportableChartValueTable
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static String selectedFile = System.getProperty("user.home") + File.separator + "export.csv";
    private final TablePanel<ModelDataset.DataItem> table;

    public ExportableChartValueTable(ModelDataset dataset, String xFeature, String xFeatureName, String xUnits, String tableTitle, String yUnits) {
        super(tableTitle);
        this.setName(tableTitle);
        this.setIconImage(Icons.PLOT_ICON.getImage());
        selectedFile = new File(new File(selectedFile).getParent(), tableTitle.replaceAll("\\.+$", "") + ".csv").getAbsolutePath();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.table = ExportableChartValueTable.createDatasetTable(dataset, xFeature, xFeatureName, xUnits, yUnits);
        mainPanel.add((Component)this.table.getPanel(), "Center");
        JPanel toolbar = new JPanel();
        BoxLayout layout = new BoxLayout(toolbar, 2);
        toolbar.setLayout(layout);
        JButton exportBtn = new JButton("Export to CSV", Icons.CSV_ICON);
        exportBtn.addActionListener(e -> this.exportToCsv());
        toolbar.add(exportBtn);
        toolbar.add(Box.createHorizontalGlue());
        JToggleButton tglColoring = new JToggleButton("coloring");
        tglColoring.addActionListener(e -> {
            this.table.setUseColoring(tglColoring.isSelected());
            this.repaint();
        });
        toolbar.add(tglColoring);
        mainPanel.add((Component)toolbar, "North");
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    public void exportToCsv() {
        File file = FileChooser.chooseFile(this, selectedFile, new FileNameExtensionFilter("CSV files", "csv"), "Export table to CSV", FileChooser.DialogType.SAVE, FileChooser.SelectionMode.FILES_ONLY);
        if (null == file) {
            return;
        }
        selectedFile = file.getAbsolutePath();
        this.exportToCsv(selectedFile);
    }

    public void exportToCsv(String csvFile) {
        try {
            this.table.exportToCsv(new File(csvFile));
        }
        catch (IOException e) {
            System.err.println("Problem exporting to file " + csvFile + "\n" + e.getMessage());
        }
    }

    private static final TablePanel<ModelDataset.DataItem> createDatasetTable(ModelDataset dataset, String xFeature, String xFeatureName, String xUnits, String yUnits) {
        int nSeries = dataset.getSeriesCount();
        ArrayList<String> features = new ArrayList<String>(nSeries + 1);
        HashMap<String, String> featureNames = new HashMap<String, String>(nSeries + 1);
        HashMap<String, String> featureUnits = new HashMap<String, String>(nSeries + 1);
        HashMap<String, Boolean> isInts = new HashMap<String, Boolean>(nSeries + 1);
        HashMap<String, String> infoTexts = new HashMap<String, String>();
        features.add(xFeature);
        featureNames.put(xFeature, xFeatureName);
        featureUnits.put(xFeature, xUnits);
        isInts.put(xFeature, Boolean.FALSE);
        for (int i = 0; i < nSeries; ++i) {
            String str = dataset.getSeriesKey(i).toString();
            features.add(str);
            featureNames.put(str, str);
            featureUnits.put(str, yUnits);
            isInts.put(str, Boolean.FALSE);
        }
        BiFunction<ModelDataset.DataItem, String, Double> featureFun = (row, feature) -> row.get((String)feature);
        Function<ModelDataset.DataItem, String> labelGenerator = row -> dataset.getItemLabel(row.item);
        BiConsumer<ModelDataset.DataItem, String> labelSetter = (row, label) -> dataset.setItemLabel(row.item, (String)label);
        XYItemRenderer renderer = dataset.getRenderer();
        Supplier coloring = () -> row -> (Color)renderer.getItemPaint(0, row.item);
        TablePanel<ModelDataset.DataItem> table = new TablePanel<ModelDataset.DataItem>(dataset, features, featureFun, featureNames, featureNames, featureUnits, isInts, infoTexts, coloring, labelGenerator, labelSetter);
        return table;
    }
}

