/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Volume;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TFalpha1
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private int height = 128;
    private int width = 256;
    int[] pixels;
    private int sampleValue = -1;
    private Control control;
    private Volume vol;
    private final float[] alpha1 = new float[256];
    final int[] a1 = new int[256];
    private int alphaOffset = 0;
    int xLast = -1;
    int yLast = -1;
    int count = 0;

    public int getScaleAlpha1() {
        return this.alphaOffset;
    }

    public void setAlphaOffset(int alphaOffset) {
        this.alphaOffset = alphaOffset;
    }

    public void setValues(int[] vals) {
        this.sampleValue = vals[0];
    }

    public TFalpha1(Control control, Volume vol) {
        this.control = control;
        this.vol = vol;
        this.pixels = new int[this.width * this.height];
        this.setPreferredSize(new Dimension(256, this.height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setAlphaAuto();
    }

    public void scaleAlpha() {
        for (int x = 0; x < 256; ++x) {
            int alpha = (int)this.alpha1[x];
            if (alpha > 0) {
                alpha += this.alphaOffset;
            }
            if (alpha > 255) {
                alpha = 255;
            }
            if (alpha < 0) {
                alpha = 0;
            }
            this.a1[x] = alpha;
        }
        this.control.alphaWasChanged = true;
    }

    public void setAlphaAuto() {
        int x;
        float max1 = 0.0f;
        for (int i = 0; i < this.vol.histVal.length; ++i) {
            int val = this.vol.histVal[i];
            if (!((float)val > max1)) continue;
            max1 = val;
        }
        float sum = 0.0f;
        for (int x2 = 0; x2 < 256; ++x2) {
            float val = (float)(1.0 - 1.2 * Math.pow((float)this.vol.histVal[x2] / max1, 0.3));
            if (val > 0.0f) {
                sum += val;
            }
            this.alpha1[x2] = val;
        }
        sum /= 256.0f;
        float[] alpha1Dauto = new float[256];
        for (x = 0; x < 256; ++x) {
            int xm2 = x > 1 ? x - 2 : 0;
            int xm1 = x > 0 ? x - 1 : 0;
            int xp1 = x < 255 ? x + 1 : 255;
            int xp2 = x < 254 ? x + 2 : 255;
            float val = (this.alpha1[xm2] + this.alpha1[xm1] + this.alpha1[x] + this.alpha1[xp1] + this.alpha1[xp2]) * 0.2f;
            alpha1Dauto[x] = 255.0f * (val += 0.5f - sum);
        }
        for (x = 0; x < 256; ++x) {
            this.alpha1[x] = alpha1Dauto[x];
            this.a1[x] = (int)Math.min(Math.max(0.0f, this.alpha1[x]), 255.0f);
        }
        this.control.alphaWasChanged = true;
    }

    public void clearAlpha() {
        for (int x = 0; x < 256; ++x) {
            this.alpha1[x] = 0.0f;
            this.a1[x] = 0;
        }
        this.control.alphaWasChanged = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.xLast = e.getX();
        this.yLast = e.getY();
        this.control.drag = true;
        this.handleMouseDragged(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.control.drag = false;
        this.control.newDisplayMode();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseDragged(e);
        if (this.count++ % 10 == 0) {
            this.control.newDisplayMode();
        }
    }

    public void handleMouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > 255) {
            x = 255;
        }
        if (y > this.height) {
            y = this.height - 1;
        }
        int sx = this.xLast;
        int ex = x;
        int sy = this.yLast;
        int ey = y;
        if (ex < sx) {
            sx = x;
            ex = this.xLast;
            sy = y;
            ey = this.yLast;
        }
        if (e.isAltDown()) {
            sy = ey = this.height - 1;
        }
        int lx = ex - sx;
        int ly = ey - sy;
        for (int i = sx; i <= ex; ++i) {
            float r;
            float yi;
            float v;
            if (lx == 0) {
                lx = 1;
            }
            if ((v = 255.0f * ((float)(this.height - 1) - (yi = (float)sy + (r = (float)(i - sx) / (float)lx) * (float)ly)) / (float)(this.height - 1)) < 0.0f) {
                v = 0.0f;
            }
            if (v > 255.0f) {
                v = 255.0f;
            }
            this.a1[i] = (int)v;
            this.alpha1[i] = v > 0.0f ? v - (float)this.alphaOffset : 0.0f;
        }
        this.yLast = y;
        this.xLast = x;
        this.control.alphaWasChanged = true;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int y;
        int val;
        int i;
        Graphics2D g2 = (Graphics2D)g;
        double max1 = 0.0;
        double max2 = 0.0;
        int mode = 0;
        for (i = 0; i < this.vol.histVal.length; ++i) {
            val = this.vol.histVal[i];
            if (!((double)val > max1)) continue;
            max1 = val;
            mode = i;
        }
        for (i = 0; i < this.vol.histVal.length; ++i) {
            val = this.vol.histVal[i];
            if (i == mode || !((double)val > max2)) continue;
            max2 = val;
        }
        if (max1 > max2 * 2.0 && max2 != 0.0) {
            max1 = (int)(max2 * 1.5);
        }
        double norm = 1.0 / max1;
        double maxL = Math.log(max1);
        for (int x = 0; x < this.width; ++x) {
            double valL;
            int val2 = (int)((double)((this.height - 1) * this.vol.histVal[x]) * norm);
            double d = valL = this.vol.histVal[x] == 0 ? 0.0 : (double)((int)((double)this.height * Math.log(this.vol.histVal[x]) / maxL));
            if (valL > (double)(this.height - 1)) {
                valL = this.height - 1;
            }
            for (int y2 = 0; y2 < this.height; ++y2) {
                int pos = y2 * this.width + x;
                this.pixels[pos] = this.height - y2 < val2 ? -16777216 : ((double)(this.height - y2) < valL ? -8947849 : -1);
            }
        }
        for (int x = 0; x < this.width - 1; ++x) {
            y = (this.height - 1) * this.a1[x] / 256;
            int y1 = (this.height - 1) * this.a1[x + 1] / 256;
            int min = Math.min(y1, y);
            int max = Math.max(y1, y);
            for (int i2 = min; i2 <= max; ++i2) {
                this.pixels[(this.height - 1 - i2) * 256 + x] = -35072;
            }
        }
        if (this.sampleValue >= 0) {
            for (y = 0; y < this.height; ++y) {
                int pos = y * this.width + this.sampleValue;
                this.pixels[pos] = -14769409;
            }
        }
        BufferedImage image = new BufferedImage(this.width, this.height, 2);
        image.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        g2.drawImage((Image)image, 0, 0, null);
    }
}

