/*
 * Decompiled with CFR 0.152.
 */
package imglib.ops.observer;

import imglib.ops.observer.IterationStatus;
import java.util.Observable;
import java.util.Observer;

public class ProgressTracker
implements Observer {
    private long expectedOperations;
    private long updateFrequency;
    private long operationsSoFar;

    public ProgressTracker(long expectedOperations, long updateFrequency) {
        this.expectedOperations = expectedOperations;
        this.updateFrequency = updateFrequency;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof IterationStatus) {
            IterationStatus status = (IterationStatus)arg;
            switch (status.getMessage()) {
                case INITIALIZE: {
                    this.operationsSoFar = 0L;
                    break;
                }
                case UPDATE: {
                    ++this.operationsSoFar;
                    if (this.operationsSoFar % this.updateFrequency != 0L) break;
                    double d = (double)this.operationsSoFar / (double)this.expectedOperations;
                    break;
                }
            }
        }
    }
}

