/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import mpicbg.imglib.algorithm.gauss.GaussianConvolution3;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.ExponentialMathType;
import mpicbg.imglib.util.Util;

public class GaussianConvolution4<A extends Type<A>, B extends ExponentialMathType<B>, C extends Type<C>>
extends GaussianConvolution3<A, B, C> {
    final B[] sigma;
    final B[][] kernel;
    final B entity;

    public GaussianConvolution4(Image<A> image, ImageFactory<B> factoryProcess, ImageFactory<C> factoryOut, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, Converter<A, B> converterIn, Converter<B, C> converterOut, B[] sigma) {
        super(image, factoryProcess, factoryOut, outOfBoundsFactory, converterIn, converterOut, 0.0);
        this.sigma = sigma;
        this.entity = (ExponentialMathType)sigma[0].createVariable();
        this.kernel = (ExponentialMathType[][])this.entity.createArray2D(this.numDimensions, 1);
        for (int d = 0; d < this.numDimensions; ++d) {
            this.kernel[d] = Util.createGaussianKernel1D(sigma[d], (boolean)true);
        }
    }

    public GaussianConvolution4(Image<A> image, ImageFactory<B> factoryProcess, ImageFactory<C> factoryOut, OutOfBoundsStrategyFactory<B> outOfBoundsFactory, Converter<A, B> converterIn, Converter<B, C> converterOut, B sigma) {
        this(image, factoryProcess, factoryOut, outOfBoundsFactory, converterIn, converterOut, (ExponentialMathType[])GaussianConvolution4.createArray(image, sigma));
    }

    @Override
    protected void convolveDim(LocalizableByDimCursor<B> inputIterator, LocalizableCursor<B> outputIterator, int currentDim, long startPos, long loopSize) {
        this.convolve(inputIterator, outputIterator, currentDim, (ExponentialMathType[])this.kernel[currentDim], startPos, loopSize);
    }

    protected void convolve(LocalizableByDimCursor<B> inputIterator, LocalizableCursor<B> outputIterator, int dim, B[] kernel, long startPos, long loopSize) {
        outputIterator.fwd(startPos);
        int filterSize = kernel.length;
        int filterSizeMinus1 = filterSize - 1;
        int filterSizeHalf = filterSize / 2;
        int filterSizeHalfMinus1 = filterSizeHalf - 1;
        int numDimensions = inputIterator.getImage().getNumDimensions();
        int iteratorPosition = filterSizeHalf;
        int[] to = new int[numDimensions];
        ExponentialMathType sum = (ExponentialMathType)((ExponentialMathType)inputIterator.getType()).createVariable();
        ExponentialMathType tmp = (ExponentialMathType)((ExponentialMathType)inputIterator.getType()).createVariable();
        for (long j = 0L; j < loopSize; ++j) {
            outputIterator.fwd();
            sum.setZero();
            outputIterator.getPosition(to);
            int n = dim;
            to[n] = to[n] - iteratorPosition;
            inputIterator.setPosition(to);
            for (int f = -filterSizeHalf; f <= filterSizeHalfMinus1; ++f) {
                tmp.set(inputIterator.getType());
                tmp.mul(kernel[f + filterSizeHalf]);
                sum.add(tmp);
                inputIterator.fwd(dim);
            }
            tmp.set(inputIterator.getType());
            tmp.mul(kernel[filterSizeMinus1]);
            sum.add(tmp);
            ((ExponentialMathType)outputIterator.getType()).set(sum);
        }
    }

    @Override
    public int getKernelSize(int dim) {
        return this.kernel[dim].length;
    }

    protected static <B extends Type<B>> B[] createArray(Image<?> image, B sigma) {
        Type[] sigmas = sigma.createArray1D(image.getNumDimensions());
        for (int d = 0; d < image.getNumDimensions(); ++d) {
            sigmas[d] = sigma.copy();
        }
        return sigmas;
    }

    protected static int[] createArray2(Image<?> image, int kernelSize) {
        int[] kernelSizes = new int[image.getNumDimensions()];
        for (int d = 0; d < image.getNumDimensions(); ++d) {
            kernelSizes[d] = kernelSize;
        }
        return kernelSizes;
    }
}

