/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.dct;

import java.util.ArrayList;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.InterpolatorImpl;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.label.FakeType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;

public class DCTInterpolator<T extends RealType<T>>
extends InterpolatorImpl<T> {
    final Image<FloatType> coefficients;
    final ArrayList<Image<FloatType>> inverseDCT;
    final int numDimensions;
    final T interpolatedValue;

    protected DCTInterpolator(Image<T> img, InterpolatorFactory<T> interpolatorFactory, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(img, interpolatorFactory, outOfBoundsStrategyFactory);
        this.interpolatedValue = (RealType)img.createType();
        this.numDimensions = img.getNumDimensions();
        ImageFactory<FloatType> imgFactory = new ImageFactory<FloatType>(new FloatType(), img.getContainerFactory());
        this.coefficients = imgFactory.createImage(img.getDimensions());
        if (this.numDimensions <= 2) {
            this.inverseDCT = null;
        } else {
            this.inverseDCT = new ArrayList();
            for (int d = 1; d < this.numDimensions - 1; ++d) {
                int[] dimensions = new int[d];
                for (int e = 0; e < d; ++e) {
                    dimensions[e] = img.getDimension(e);
                }
                this.inverseDCT.add(imgFactory.createImage(dimensions));
            }
            this.inverseDCT.add(this.coefficients);
        }
        this.computeCoefficients();
        this.moveTo(this.position);
    }

    public Image<FloatType> getCoefficients() {
        return this.coefficients;
    }

    protected void computeCoefficients() {
        LocalizableByDimCursor cursor = this.img.createLocalizableByDimCursor();
        LocalizableByDimCursor<FloatType> cursorCoeff = this.coefficients.createLocalizableByDimCursor();
        if (this.numDimensions > 1) {
            int[] fakeSize = new int[this.numDimensions - 1];
            int[] tmp = new int[this.numDimensions];
            for (int d = 1; d < this.numDimensions; ++d) {
                fakeSize[d - 1] = this.img.getDimension(d);
            }
            ArrayLocalizableCursor<FakeType> cursorDim0 = ArrayLocalizableCursor.createLinearCursor(fakeSize);
            int length0 = this.img.getDimension(0);
            float[] tempIn0 = new float[length0];
            float[] tempOut0 = new float[length0];
            while (cursorDim0.hasNext()) {
                int x;
                cursorDim0.fwd();
                cursorDim0.getPosition(fakeSize);
                tmp[0] = 0;
                for (int d = 1; d < this.numDimensions; ++d) {
                    tmp[d] = fakeSize[d - 1];
                }
                cursor.setPosition(tmp);
                cursorCoeff.setPosition(tmp);
                for (x = 0; x < length0 - 1; ++x) {
                    tempIn0[x] = ((RealType)cursor.getType()).getRealFloat();
                    cursor.fwd(0);
                }
                tempIn0[length0 - 1] = ((RealType)cursor.getType()).getRealFloat();
                DCTInterpolator.computeDCTCoefficients(tempIn0, tempOut0);
                for (x = 0; x < length0 - 1; ++x) {
                    ((FloatType)cursorCoeff.getType()).setReal(tempOut0[x]);
                    cursorCoeff.fwd(0);
                }
                ((FloatType)cursorCoeff.getType()).setReal(tempOut0[length0 - 1]);
            }
            for (int dim = 1; dim < this.numDimensions; ++dim) {
                int countDim = 0;
                for (int d = 0; d < this.numDimensions; ++d) {
                    if (d == dim) continue;
                    fakeSize[countDim++] = this.img.getDimension(d);
                }
                ArrayLocalizableCursor<FakeType> cursorDim = ArrayLocalizableCursor.createLinearCursor(fakeSize);
                int length = this.img.getDimension(dim);
                float[] tempIn = new float[length];
                float[] tempOut = new float[length];
                while (cursorDim.hasNext()) {
                    int i;
                    cursorDim.fwd();
                    cursorDim.getPosition(fakeSize);
                    tmp[dim] = 0;
                    countDim = 0;
                    for (int d = 0; d < this.numDimensions; ++d) {
                        if (d == dim) continue;
                        tmp[d] = fakeSize[countDim++];
                    }
                    cursorCoeff.setPosition(tmp);
                    for (i = 0; i < length - 1; ++i) {
                        tempIn[i] = ((FloatType)cursorCoeff.getType()).getRealFloat();
                        cursorCoeff.fwd(dim);
                    }
                    tempIn[length - 1] = ((FloatType)cursorCoeff.getType()).getRealFloat();
                    DCTInterpolator.computeDCTCoefficients(tempIn, tempOut);
                    cursorCoeff.setPosition(tmp);
                    for (i = 0; i < length - 1; ++i) {
                        ((FloatType)cursorCoeff.getType()).setReal(tempOut[i]);
                        cursorCoeff.fwd(dim);
                    }
                    ((FloatType)cursorCoeff.getType()).setReal(tempOut[length - 1]);
                }
            }
        } else {
            int x;
            int length0 = this.img.getDimension(0);
            float[] tempIn0 = new float[length0];
            float[] tempOut0 = new float[length0];
            cursor.setPosition(0, 0);
            cursorCoeff.setPosition(0, 0);
            for (x = 0; x < length0 - 1; ++x) {
                tempIn0[x] = ((RealType)cursor.getType()).getRealFloat();
                cursor.fwd(0);
            }
            tempIn0[length0 - 1] = ((RealType)cursor.getType()).getRealFloat();
            DCTInterpolator.computeDCTCoefficients(tempIn0, tempOut0);
            for (x = 0; x < length0 - 1; ++x) {
                ((FloatType)cursorCoeff.getType()).setReal(tempOut0[x]);
                cursor.fwd(0);
            }
            ((FloatType)cursorCoeff.getType()).setReal(tempOut0[length0 - 1]);
        }
    }

    private static final void computeDCTCoefficients(float[] in, float[] out) {
        int maxN = in.length;
        for (int k = 0; k < maxN; ++k) {
            out[k] = 0.0f;
            for (int x = 0; x < maxN; ++x) {
                int n = k;
                out[n] = (float)((double)out[n] + (double)in[x] * Math.cos(Math.PI / (double)maxN * (double)k * ((double)x + 0.5)));
            }
            if (k == 0) {
                int n = k;
                out[n] = (float)((double)out[n] * (2.0 / Math.sqrt(2.0) / (double)maxN));
                continue;
            }
            int n = k;
            out[n] = (float)((double)out[n] * (2.0 / (double)maxN));
        }
    }

    private static final float inverseDCT(float[] ck, float x) {
        int maxN = ck.length;
        float f = 0.0f;
        f = (float)((double)f + 1.0 / Math.sqrt(2.0) * (double)ck[0]);
        for (int k = 1; k < maxN; ++k) {
            f = (float)((double)f + (double)ck[k] * Math.cos(Math.PI / (double)maxN * (double)k * ((double)x + 0.5)));
        }
        return f;
    }

    @Override
    public T getType() {
        if (this.numDimensions == 1) {
            LocalizableByDimCursor<FloatType> cursor = this.coefficients.createLocalizableByDimCursor();
            int length = this.img.getDimension(0);
            float[] temp = new float[length];
            cursor.setPosition(0, 0);
            for (int x = 0; x < length - 1; ++x) {
                temp[x] = ((FloatType)cursor.getType()).getRealFloat();
                cursor.fwd(0);
            }
            temp[length - 1] = ((FloatType)cursor.getType()).getRealFloat();
            this.interpolatedValue.setReal(DCTInterpolator.inverseDCT(temp, this.position[0]));
        } else {
            Image<FloatType> iDCT2d;
            if (this.numDimensions > 2) {
                for (int dim = this.numDimensions - 1; dim >= 1; --dim) {
                    Image<FloatType> iDCTtarget = this.inverseDCT.get(dim - 2);
                    LocalizableCursor<FloatType> cursorOut = iDCTtarget.createLocalizableCursor();
                    Image<FloatType> iDCTsource = this.inverseDCT.get(dim - 1);
                    LocalizableByDimCursor<FloatType> cursorIn = iDCTsource.createLocalizableByDimCursor();
                    int numDimensionsTarget = iDCTtarget.getNumDimensions();
                    int[] tmp = new int[iDCTsource.getNumDimensions()];
                    int length = iDCTsource.getDimension(numDimensionsTarget);
                    float[] temp = new float[length];
                    float pos = this.position[dim];
                    while (cursorOut.hasNext()) {
                        cursorOut.fwd();
                        for (int d = 0; d < numDimensionsTarget; ++d) {
                            tmp[d] = cursorOut.getPosition(d);
                        }
                        tmp[numDimensionsTarget] = 0;
                        cursorIn.setPosition(tmp);
                        for (int i = 0; i < length - 1; ++i) {
                            temp[i] = ((FloatType)cursorIn.getType()).getRealFloat();
                            cursorIn.fwd(dim);
                        }
                        temp[length - 1] = ((FloatType)cursorIn.getType()).getRealFloat();
                        ((FloatType)cursorOut.getType()).setReal(DCTInterpolator.inverseDCT(temp, pos));
                    }
                }
                iDCT2d = this.inverseDCT.get(0);
            } else {
                iDCT2d = this.coefficients;
            }
            int length0 = iDCT2d.getDimension(0);
            int length1 = iDCT2d.getDimension(1);
            float[] temp1 = new float[length1];
            float[] idct1d = new float[length0];
            float positionY = this.position[1];
            LocalizableByDimCursor<FloatType> cursor1 = iDCT2d.createLocalizableByDimCursor();
            for (int x = 0; x < length0; ++x) {
                cursor1.setPosition(x, 0);
                cursor1.setPosition(0, 1);
                for (int y = 0; y < length1 - 1; ++y) {
                    temp1[y] = ((FloatType)cursor1.getType()).getRealFloat();
                    cursor1.fwd(1);
                }
                temp1[length1 - 1] = ((FloatType)cursor1.getType()).getRealFloat();
                idct1d[x] = DCTInterpolator.inverseDCT(temp1, positionY);
            }
            this.interpolatedValue.setReal(DCTInterpolator.inverseDCT(idct1d, this.position[0]));
        }
        return this.interpolatedValue;
    }

    @Override
    public void close() {
    }

    @Override
    public void moveTo(float[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = pos[d];
        }
    }

    @Override
    public void moveTo(double[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = (float)pos[d];
        }
    }

    @Override
    public void moveRel(float[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.position[n] = this.position[n] + vector[d];
        }
    }

    @Override
    public void moveRel(double[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.position[n] = (float)((double)this.position[n] + vector[d]);
        }
    }

    @Override
    public void setPosition(float[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = pos[d];
        }
    }

    @Override
    public void setPosition(double[] pos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = (float)pos[d];
        }
    }
}

